/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.portlet;

import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.DocumentFragmentEntryProcessor;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.fragment.processor.PortletRegistry;
import com.liferay.fragment.renderer.FragmentPortletRenderer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.PortletPreferenceValueLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.exportimport.staging.StagingAdvicesThreadLocal;
import java.util.Arrays;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.servlet.http.HttpServletRequest;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"fragment.entry.processor.priority:Integer=3"}, service={DocumentFragmentEntryProcessor.class})
public class PortletDocumentFragmentEntryProcessor
implements DocumentFragmentEntryProcessor {
    @Reference
    private FragmentPortletRenderer _fragmentPortletRenderer;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    @Reference
    private PortletPreferenceValueLocalService _portletPreferenceValueLocalService;
    @Reference
    private PortletRegistry _portletRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFragmentEntryLinkHTML(FragmentEntryLink fragmentEntryLink, Document document, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        String html = fragmentEntryLink.getHtml();
        if (!html.contains("lfr-widget-") && !html.contains("@liferay_portlet")) {
            return;
        }
        Elements elements = document.getAllElements();
        for (Element element : elements) {
            String tagName = element.tagName();
            String portletName = this._getPortletName(tagName);
            if (Validator.isNull((String)portletName)) continue;
            Portlet portlet = this._portletLocalService.getPortletById(portletName);
            String instanceId = String.valueOf('0');
            String id = element.attr("id");
            if (portlet.isInstanceable()) {
                instanceId = this._getInstanceId(fragmentEntryLink.getNamespace(), id);
            }
            String portletHTML = "";
            String defaultPreferences = portlet.getDefaultPreferences();
            if (fragmentEntryProcessorContext.isPreviewMode()) {
                portletHTML = this._fragmentPortletRenderer.renderPortlet(fragmentEntryLink, fragmentEntryProcessorContext.getHttpServletRequest(), fragmentEntryProcessorContext.getHttpServletResponse(), portletName, instanceId, defaultPreferences);
            } else {
                long plid = ParamUtil.getLong((HttpServletRequest)fragmentEntryProcessorContext.getHttpServletRequest(), (String)"p_l_id");
                boolean stagingAdvicesThreadLocalEnabled = StagingAdvicesThreadLocal.isEnabled();
                try {
                    StagingAdvicesThreadLocal.setEnabled((boolean)false);
                    defaultPreferences = this._getPreferences(plid, portletName, fragmentEntryLink, id, portlet.getDefaultPreferences());
                }
                finally {
                    StagingAdvicesThreadLocal.setEnabled((boolean)stagingAdvicesThreadLocalEnabled);
                }
                portletHTML = this._fragmentPortletRenderer.renderPortlet(fragmentEntryLink, fragmentEntryProcessorContext.getHttpServletRequest(), fragmentEntryProcessorContext.getHttpServletResponse(), portletName, instanceId, this._getPreferences(plid, portletName, fragmentEntryLink, id, defaultPreferences));
            }
            Element portletElement = new Element("div");
            portletElement.attr("class", "portlet");
            portletElement.html(portletHTML);
            element.replaceWith((Node)portletElement);
        }
    }

    private boolean _comparePreferences(PortletPreferences currentPortletPreferences, PortletPreferences sourcePortletPreferences) {
        Map currentPreferences = currentPortletPreferences.getMap();
        Map sourcePreferences = sourcePortletPreferences.getMap();
        if (currentPreferences.size() != sourcePreferences.size()) {
            return false;
        }
        for (Map.Entry entry : currentPreferences.entrySet()) {
            if (Arrays.equals((Object[])sourcePreferences.get(entry.getKey()), (Object[])entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private String _getInstanceId(String namespace, String id) {
        if (Validator.isNull((String)namespace)) {
            namespace = StringUtil.randomId();
        }
        return namespace + id;
    }

    private String _getPortletId(String portletName, String namespace, String id) {
        return PortletIdCodec.encode((String)PortletIdCodec.decodePortletName((String)portletName), (long)PortletIdCodec.decodeUserId((String)portletName), (String)this._getInstanceId(namespace, id));
    }

    private String _getPortletName(String tagName) {
        if (!StringUtil.startsWith((String)tagName, (String)"lfr-widget-")) {
            return "";
        }
        String alias = tagName.substring(11);
        return this._portletRegistry.getPortletName(alias);
    }

    private String _getPreferences(long plid, String portletName, FragmentEntryLink fragmentEntryLink, String id, String defaultPreferences) {
        String defaultPortletId = this._getPortletId(portletName, fragmentEntryLink.getNamespace(), id);
        PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((long)fragmentEntryLink.getCompanyId(), (long)0L, (int)3, (long)fragmentEntryLink.getPlid(), (String)defaultPortletId, (String)defaultPreferences);
        String portletId = this._getPortletId(portletName, fragmentEntryLink.getNamespace(), id);
        com.liferay.portal.kernel.model.PortletPreferences portletPreferences = this._portletPreferencesLocalService.fetchPortletPreferences(0L, 3, plid, portletId);
        if (portletPreferences != null) {
            jxPortletPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((long)fragmentEntryLink.getCompanyId(), (long)0L, (int)3, (long)fragmentEntryLink.getPlid(), (String)portletId, (String)PortletPreferencesFactoryUtil.toXML((PortletPreferences)jxPortletPreferences));
            this._updateLayoutPortletSetup(portletPreferences, jxPortletPreferences);
        } else {
            int count = this._portletPreferencesLocalService.getPortletPreferencesCount(fragmentEntryLink.getCompanyId(), 0L, 3, portletId);
            if (count > 0) {
                jxPortletPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((long)fragmentEntryLink.getCompanyId(), (long)0L, (int)3, (long)fragmentEntryLink.getPlid(), (String)portletId, (String)PortletPreferencesFactoryUtil.toXML((PortletPreferences)jxPortletPreferences));
            }
        }
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)jxPortletPreferences);
    }

    private void _updateLayoutPortletSetup(com.liferay.portal.kernel.model.PortletPreferences portletPreferences, PortletPreferences jxPortletPreferences) {
        PortletPreferences currentPortletPreferences = this._portletPreferenceValueLocalService.getPreferences(portletPreferences);
        if (this._comparePreferences(currentPortletPreferences, jxPortletPreferences)) {
            return;
        }
        this._portletPreferencesLocalService.updatePreferences(portletPreferences.getOwnerId(), portletPreferences.getOwnerType(), portletPreferences.getPlid(), portletPreferences.getPortletId(), jxPortletPreferences);
    }
}

