/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.portlet;

import com.liferay.fragment.exception.FragmentEntryContentException;
import com.liferay.fragment.processor.DocumentFragmentEntryValidator;
import com.liferay.fragment.processor.PortletRegistry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"fragment.entry.processor.priority:Integer=3"}, service={DocumentFragmentEntryValidator.class})
public class PortletFragmentEntryValidator
implements DocumentFragmentEntryValidator {
    @Reference
    private Language _language;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private PortletRegistry _portletRegistry;

    public void validateFragmentEntryHTML(Document document, String configuration, Locale locale) throws PortalException {
        for (Element element : document.getAllElements()) {
            Portlet portlet;
            Elements elements;
            String htmlTagName = element.tagName();
            if (!StringUtil.startsWith((String)htmlTagName, (String)"lfr-widget-")) continue;
            String alias = StringUtil.removeSubstring((String)htmlTagName, (String)"lfr-widget-");
            if (Validator.isNull((String)this._portletRegistry.getPortletName(alias))) {
                throw new FragmentEntryContentException(this._language.format(locale, "there-is-no-widget-available-for-alias-x", (Object)alias));
            }
            String id = element.id();
            if (Validator.isNotNull((String)id) && !Validator.isAlphanumericName((String)id)) {
                throw new FragmentEntryContentException(this._language.format(locale, "widget-id-must-contain-only-alphanumeric-characters", (Object)alias));
            }
            if (Validator.isNotNull((String)id)) {
                elements = document.select("#" + id);
                if (elements.size() > 1) {
                    throw new FragmentEntryContentException(this._language.get(locale, "widget-id-must-be-unique"));
                }
                if (id.length() > GetterUtil.getInteger((String)"75")) {
                    throw new FragmentEntryContentException(this._language.format(locale, "widget-id-cannot-exceed-x-characters", (Object)"75"));
                }
            }
            if ((elements = document.getElementsByTag(htmlTagName)).size() > 1 && Validator.isNull((String)id)) {
                throw new FragmentEntryContentException(this._language.get(locale, "duplicate-widgets-within-the-same-fragment-must-have-an-id"));
            }
            if (elements.size() <= 1 || (portlet = this._portletLocalService.getPortletById(this._portletRegistry.getPortletName(alias))).isInstanceable()) continue;
            throw new FragmentEntryContentException(this._language.format(locale, "you-cannot-add-the-widget-x-more-than-once", (Object)alias));
        }
    }
}

