/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.freemarker;

import com.liferay.fragment.entry.processor.freemarker.internal.configuration.FreeMarkerFragmentEntryProcessorConfiguration;
import com.liferay.fragment.exception.FragmentEntryContentException;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.FragmentEntryProcessor;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.fragment.util.FragmentEntryConfigUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"fragment.entry.processor.priority:Integer=1"}, service={FragmentEntryProcessor.class})
public class FreeMarkerFragmentEntryProcessor
implements FragmentEntryProcessor {
    private static final Log _log = LogFactoryUtil.getLog(FreeMarkerFragmentEntryProcessor.class);
    @Reference
    private ConfigurationProvider _configurationProvider;

    public JSONObject getDefaultEditableValuesJSONObject(String html, String configuration) {
        return JSONFactoryUtil.createJSONObject();
    }

    public String processFragmentEntryLinkHTML(FragmentEntryLink fragmentEntryLink, String html, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        if (Validator.isNull((String)html)) {
            return html;
        }
        FreeMarkerFragmentEntryProcessorConfiguration freeMarkerFragmentEntryProcessorConfiguration = (FreeMarkerFragmentEntryProcessorConfiguration)this._configurationProvider.getCompanyConfiguration(FreeMarkerFragmentEntryProcessorConfiguration.class, fragmentEntryLink.getCompanyId());
        if (!freeMarkerFragmentEntryProcessorConfiguration.enable()) {
            return html;
        }
        if (fragmentEntryProcessorContext.getHttpServletRequest() == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"HTTP servlet request is not set in the fragment entry processor context");
            }
            return html;
        }
        if (fragmentEntryProcessorContext.getHttpServletResponse() == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"HTTP servlet response is not set in the fragment entry processor context");
            }
            return html;
        }
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)new StringTemplateResource("template_id", "[#ftl] " + html), (boolean)true);
        template.put((Object)"writer", (Object)unsyncStringWriter);
        JSONObject configurationValuesJSONObject = FragmentEntryConfigUtil.getConfigurationJSONObject((String)fragmentEntryLink.getConfiguration(), (String)fragmentEntryLink.getEditableValues(), (long[])fragmentEntryProcessorContext.getSegmentsExperienceIds());
        HashMap contextObjects = HashMapBuilder.put((Object)"configuration", (Object)configurationValuesJSONObject).put((Object)"fragmentEntryLinkNamespace", (Object)fragmentEntryLink.getNamespace()).build();
        contextObjects.putAll(FragmentEntryConfigUtil.getContextObjects((JSONObject)configurationValuesJSONObject, (String)fragmentEntryLink.getConfiguration()));
        template.putAll((Map)contextObjects);
        template.prepareTaglib(fragmentEntryProcessorContext.getHttpServletRequest(), fragmentEntryProcessorContext.getHttpServletResponse());
        template.prepare(fragmentEntryProcessorContext.getHttpServletRequest());
        try {
            template.processTemplate((Writer)unsyncStringWriter);
        }
        catch (TemplateException templateException) {
            throw new FragmentEntryContentException(this._getMessage(templateException), (Throwable)templateException);
        }
        return unsyncStringWriter.toString();
    }

    public void validateFragmentEntryHTML(String html, String configuration) throws PortalException {
        FreeMarkerFragmentEntryProcessorConfiguration freeMarkerFragmentEntryProcessorConfiguration = (FreeMarkerFragmentEntryProcessorConfiguration)this._configurationProvider.getCompanyConfiguration(FreeMarkerFragmentEntryProcessorConfiguration.class, CompanyThreadLocal.getCompanyId().longValue());
        if (!freeMarkerFragmentEntryProcessorConfiguration.enable()) {
            return;
        }
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)new StringTemplateResource("template_id", "[#ftl] " + html), (boolean)true);
        try {
            HttpServletRequest httpServletRequest = null;
            HttpServletResponse httpServletResponse = null;
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            if (serviceContext != null) {
                httpServletRequest = serviceContext.getRequest();
                httpServletResponse = serviceContext.getResponse();
            }
            if (httpServletRequest != null && httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY") != null) {
                JSONObject configurationDefaultValuesJSONObject = FragmentEntryConfigUtil.getConfigurationDefaultValuesJSONObject((String)configuration);
                HashMap contextObjects = HashMapBuilder.put((Object)"configuration", (Object)configurationDefaultValuesJSONObject).put((Object)"fragmentEntryLinkNamespace", (Object)"").build();
                contextObjects.putAll(FragmentEntryConfigUtil.getContextObjects((JSONObject)configurationDefaultValuesJSONObject, (String)configuration));
                template.putAll((Map)contextObjects);
                template.prepareTaglib(httpServletRequest, httpServletResponse);
                template.prepare(httpServletRequest);
                template.processTemplate((Writer)new UnsyncStringWriter());
            }
        }
        catch (TemplateException templateException) {
            throw new FragmentEntryContentException(this._getMessage(templateException), (Throwable)templateException);
        }
    }

    private String _getMessage(TemplateException templateException) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
        String message = LanguageUtil.get((ResourceBundle)resourceBundle, (String)"freemarker-syntax-is-invalid");
        Throwable causeThrowable = templateException.getCause();
        String causeThrowableMessage = causeThrowable.getLocalizedMessage();
        if (Validator.isNotNull((String)causeThrowableMessage)) {
            message = message + "\n\n" + causeThrowableMessage;
        }
        return message;
    }
}

