/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.editable;

import com.liferay.fragment.entry.processor.editable.parser.EditableElementParser;
import com.liferay.fragment.entry.processor.util.EditableFragmentEntryProcessorUtil;
import com.liferay.fragment.processor.DefaultEditableValuesFragmentEntryProcessor;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"fragment.entry.processor.priority:Integer=2"}, service={DefaultEditableValuesFragmentEntryProcessor.class})
public class EditableDefaultEditableValuesFragmentEntryProcessor
implements DefaultEditableValuesFragmentEntryProcessor {
    @Reference
    private JSONFactory _jsonFactory;
    private ServiceTrackerMap<String, EditableElementParser> _serviceTrackerMap;

    public JSONObject getDefaultEditableValuesJSONObject(JSONObject configurationJSONObject, Document document) {
        JSONObject defaultValueJSONObject;
        JSONObject defaultEditableValuesJSONObject = this._jsonFactory.createJSONObject();
        for (Element element : document.getElementsByAttribute("data-lfr-editable-id")) {
            defaultValueJSONObject = this._getDefaultValueJSONObject(element, element.attr("data-lfr-editable-type"));
            if (defaultValueJSONObject == null) continue;
            defaultEditableValuesJSONObject.put(EditableFragmentEntryProcessorUtil.getElementId((Element)element), defaultValueJSONObject);
        }
        for (Element element : document.getElementsByTag("lfr-editable")) {
            defaultValueJSONObject = this._getDefaultValueJSONObject(element, element.attr("type"));
            if (defaultValueJSONObject == null) continue;
            defaultEditableValuesJSONObject.put(EditableFragmentEntryProcessorUtil.getElementId((Element)element), defaultValueJSONObject);
        }
        return defaultEditableValuesJSONObject;
    }

    public String getKey() {
        return "com.liferay.fragment.entry.processor.editable.EditableFragmentEntryProcessor";
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, EditableElementParser.class, (String)"type");
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private JSONObject _getDefaultValueJSONObject(Element element, String type) {
        EditableElementParser editableElementParser = (EditableElementParser)this._serviceTrackerMap.getService((Object)type);
        if (editableElementParser == null) {
            return null;
        }
        return JSONUtil.put((String)"config", (Object)editableElementParser.getAttributes(element)).put("defaultValue", editableElementParser.getValue(element));
    }
}

