/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.editable;

import com.liferay.fragment.entry.processor.editable.mapper.EditableElementMapper;
import com.liferay.fragment.entry.processor.editable.parser.EditableElementParser;
import com.liferay.fragment.entry.processor.helper.FragmentEntryProcessorHelper;
import com.liferay.fragment.entry.processor.util.AnalyticsAttributesUtil;
import com.liferay.fragment.entry.processor.util.EditableFragmentEntryProcessorUtil;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.DocumentFragmentEntryProcessor;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"fragment.entry.processor.priority:Integer=2"}, service={DocumentFragmentEntryProcessor.class})
public class EditableDocumentFragmentEntryProcessor
implements DocumentFragmentEntryProcessor {
    private ServiceTrackerMap<String, EditableElementMapper> _editableElementMapperServiceTrackerMap;
    private ServiceTrackerMap<String, EditableElementParser> _editableElementParserServiceTrackerMap;
    @Reference
    private FragmentEntryProcessorHelper _fragmentEntryProcessorHelper;
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Portal _portal;

    public void processFragmentEntryLinkHTML(FragmentEntryLink fragmentEntryLink, Document document, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        InfoItemReference infoItemReference;
        JSONObject editableValuesJSONObject;
        JSONObject jsonObject = this._jsonFactory.createJSONObject(fragmentEntryLink.getEditableValues());
        if (jsonObject.length() == 0) {
            jsonObject.put("com.liferay.fragment.entry.processor.editable.EditableFragmentEntryProcessor", this._getDefaultEditableValuesJSONObject(document));
        }
        if ((editableValuesJSONObject = jsonObject.getJSONObject("com.liferay.fragment.entry.processor.editable.EditableFragmentEntryProcessor")) == null) {
            return;
        }
        HashMap infoDisplaysFieldValues = new HashMap();
        for (Element element : document.select("lfr-editable,*[data-lfr-editable-id]")) {
            String id;
            EditableElementParser editableElementParser = this._getEditableElementParser(element);
            if (editableElementParser == null || !editableValuesJSONObject.has(id = EditableFragmentEntryProcessorUtil.getElementId((Element)element))) continue;
            JSONObject editableValueJSONObject = editableValuesJSONObject.getJSONObject(id);
            String value = null;
            JSONObject mappedValueConfigJSONObject = this._jsonFactory.createJSONObject();
            if (this._fragmentEntryProcessorHelper.isMapped(editableValueJSONObject) || this._fragmentEntryProcessorHelper.isMappedCollection(editableValueJSONObject) || this._fragmentEntryProcessorHelper.isMappedDisplayPage(editableValueJSONObject)) {
                Object fieldValue = this._fragmentEntryProcessorHelper.getFieldValue(editableValueJSONObject, infoDisplaysFieldValues, fragmentEntryProcessorContext);
                if (fieldValue != null) {
                    String fieldId = editableValueJSONObject.getString("collectionFieldId");
                    if (this._fragmentEntryProcessorHelper.isMappedDisplayPage(editableValueJSONObject)) {
                        fieldId = editableValueJSONObject.getString("mappedField");
                    } else if (this._fragmentEntryProcessorHelper.isMapped(editableValueJSONObject)) {
                        fieldId = editableValueJSONObject.getString("fieldId");
                    }
                    mappedValueConfigJSONObject = editableElementParser.getFieldTemplateConfigJSONObject(fieldId, fragmentEntryProcessorContext.getLocale(), fieldValue);
                    value = editableElementParser.parseFieldValue(fieldValue);
                } else {
                    value = editableValueJSONObject.getString("defaultValue");
                }
            } else {
                value = this._fragmentEntryProcessorHelper.getEditableValue(editableValueJSONObject, fragmentEntryProcessorContext.getLocale());
            }
            JSONObject configJSONObject = JSONUtil.merge((JSONObject)editableValueJSONObject.getJSONObject("config"), (JSONObject)mappedValueConfigJSONObject);
            JSONObject localizedJSONObject = configJSONObject.getJSONObject(LocaleUtil.toLanguageId((Locale)fragmentEntryProcessorContext.getLocale()));
            String mapperType = configJSONObject.getString("mapperType", element.attr("type"));
            if (localizedJSONObject != null && localizedJSONObject.length() > 0) {
                configJSONObject = localizedJSONObject;
            }
            if (value != null) {
                editableElementParser.replace(element, value, configJSONObject);
            }
            if (!fragmentEntryProcessorContext.isEditMode()) {
                EditableElementMapper editableElementMapper;
                if (Validator.isNull((String)mapperType)) {
                    mapperType = element.attr("data-lfr-editable-type");
                }
                if ((editableElementMapper = (EditableElementMapper)this._editableElementMapperServiceTrackerMap.getService((Object)mapperType)) != null) {
                    editableElementMapper.map(element, configJSONObject, fragmentEntryProcessorContext);
                }
            }
            if ((fragmentEntryProcessorContext.isPreviewMode() || fragmentEntryProcessorContext.isViewMode()) && Objects.equals(element.tagName(), "lfr-editable")) {
                element.removeAttr("id");
                element.removeAttr("type");
                String tagName = element.attr("view-tag-name");
                if (!Objects.equals(tagName, "span")) {
                    tagName = "div";
                }
                element.tagName(tagName);
                element.removeAttr("view-tag-name");
            }
            if (!FeatureFlagManagerUtil.isEnabled((long)fragmentEntryLink.getCompanyId(), (String)"LPD-39437") || !fragmentEntryProcessorContext.isViewMode()) continue;
            AnalyticsAttributesUtil.addAnalyticsAttributes((JSONObject)editableValueJSONObject, (Element)element, (FragmentEntryProcessorContext)fragmentEntryProcessorContext, (FragmentEntryProcessorHelper)this._fragmentEntryProcessorHelper, infoDisplaysFieldValues, (InfoItemServiceRegistry)this._infoItemServiceRegistry);
        }
        if (fragmentEntryProcessorContext.getPreviewClassNameId() > 0L && fragmentEntryProcessorContext.getPreviewClassPK() > 0L && infoDisplaysFieldValues.containsKey(infoItemReference = new InfoItemReference(this._portal.getClassName(fragmentEntryProcessorContext.getPreviewClassNameId()), (InfoItemIdentifier)new ClassPKInfoItemIdentifier(fragmentEntryProcessorContext.getPreviewClassPK())))) {
            Element previewElement = new Element("div");
            previewElement.attr("style", "border: 1px solid #0B5FFF");
            Element bodyElement = document.body();
            previewElement.html(bodyElement.html());
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._editableElementMapperServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, EditableElementMapper.class, (String)"type");
        this._editableElementParserServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, EditableElementParser.class, (String)"type");
    }

    @Deactivate
    protected void deactivate() {
        this._editableElementMapperServiceTrackerMap.close();
        this._editableElementParserServiceTrackerMap.close();
    }

    private JSONObject _getDefaultEditableValuesJSONObject(Document document) {
        JSONObject defaultEditableValuesJSONObject = this._jsonFactory.createJSONObject();
        for (Element element : document.select("lfr-editable,*[data-lfr-editable-id]")) {
            EditableElementParser editableElementParser = this._getEditableElementParser(element);
            if (editableElementParser == null) continue;
            JSONObject defaultValueJSONObject = JSONUtil.put((String)"config", (Object)editableElementParser.getAttributes(element)).put("defaultValue", editableElementParser.getValue(element));
            defaultEditableValuesJSONObject.put(EditableFragmentEntryProcessorUtil.getElementId((Element)element), defaultValueJSONObject);
        }
        return defaultEditableValuesJSONObject;
    }

    private EditableElementParser _getEditableElementParser(Element element) {
        String type = EditableFragmentEntryProcessorUtil.getElementType((Element)element);
        return (EditableElementParser)this._editableElementParserServiceTrackerMap.getService((Object)type);
    }
}

