/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.editable;

import com.liferay.fragment.entry.processor.editable.mapper.EditableElementMapper;
import com.liferay.fragment.entry.processor.editable.parser.EditableElementParser;
import com.liferay.fragment.entry.processor.helper.FragmentEntryProcessorHelper;
import com.liferay.fragment.exception.FragmentEntryContentException;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.FragmentEntryProcessor;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, property={"fragment.entry.processor.priority:Integer=2"}, service={FragmentEntryProcessor.class})
public class EditableFragmentEntryProcessor
implements FragmentEntryProcessor {
    private static final String[] _REQUIRED_ATTRIBUTE_NAMES = new String[]{"id", "type"};
    private final Map<String, EditableElementMapper> _editableElementMappers = new HashMap<String, EditableElementMapper>();
    private final Map<String, EditableElementParser> _editableElementParsers = new HashMap<String, EditableElementParser>();
    @Reference
    private FragmentEntryProcessorHelper _fragmentEntryProcessorHelper;

    public JSONArray getAvailableTagsJSONArray() {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (Map.Entry<String, EditableElementParser> editableElementParser : this._editableElementParsers.entrySet()) {
            StringBundler sb = new StringBundler(2 + 5 * _REQUIRED_ATTRIBUTE_NAMES.length);
            sb.append("<lfr-editable");
            for (String attributeName : _REQUIRED_ATTRIBUTE_NAMES) {
                sb.append(" ");
                sb.append(attributeName);
                sb.append("=\"");
                String value = "";
                if (attributeName.equals("type")) {
                    value = editableElementParser.getKey();
                }
                sb.append(value);
                sb.append("\"");
            }
            sb.append("></lfr-editable>");
            jsonArray.put(JSONUtil.put((String)"content", (Object)sb.toString()).put("name", "lfr-editable:" + editableElementParser.getKey()));
        }
        return jsonArray;
    }

    public JSONObject getDefaultEditableValuesJSONObject(String html) {
        return this._getDefaultEditableValuesJSONObject(html);
    }

    public JSONObject getDefaultEditableValuesJSONObject(String html, String configuration) {
        return this._getDefaultEditableValuesJSONObject(html);
    }

    public String processFragmentEntryLinkHTML(FragmentEntryLink fragmentEntryLink, String html, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)fragmentEntryLink.getEditableValues());
        if (jsonObject.length() == 0) {
            Class<?> clazz = this.getClass();
            jsonObject.put(clazz.getName(), this.getDefaultEditableValuesJSONObject(fragmentEntryLink.getHtml(), fragmentEntryLink.getConfiguration()));
        }
        Document document = this._getDocument(html);
        HashMap infoDisplaysFieldValues = new HashMap();
        for (Element element : document.select("lfr-editable")) {
            Object fieldValue;
            EditableElementParser editableElementParser = this._editableElementParsers.get(element.attr("type"));
            if (editableElementParser == null) continue;
            String id = element.attr("id");
            Class<?> clazz = this.getClass();
            JSONObject editableValuesJSONObject = jsonObject.getJSONObject(clazz.getName());
            if (editableValuesJSONObject == null || !editableValuesJSONObject.has(id)) continue;
            JSONObject editableValueJSONObject = editableValuesJSONObject.getJSONObject(id);
            String value = "";
            JSONObject mappedValueConfigJSONObject = JSONFactoryUtil.createJSONObject();
            if (this._fragmentEntryProcessorHelper.isAssetDisplayPage(fragmentEntryProcessorContext.getMode()) && Validator.isNotNull((String)(value = editableValueJSONObject.getString("mappedField")))) {
                mappedValueConfigJSONObject = editableElementParser.getFieldTemplateConfigJSONObject(value, fragmentEntryProcessorContext.getLocale(), null);
                if (mappedValueConfigJSONObject.has("alt")) {
                    String alt = mappedValueConfigJSONObject.getString("alt", "");
                    alt = this._fragmentEntryProcessorHelper.processTemplate(alt, fragmentEntryProcessorContext);
                    mappedValueConfigJSONObject.put("alt", alt);
                }
                value = StringUtil.replace((String)editableElementParser.getFieldTemplate(), (String)"field_name", (String)value);
                value = this._fragmentEntryProcessorHelper.processTemplate(value, fragmentEntryProcessorContext);
            }
            if (this._fragmentEntryProcessorHelper.isMapped(editableValueJSONObject) && (fieldValue = this._fragmentEntryProcessorHelper.getMappedValue(editableValueJSONObject, infoDisplaysFieldValues, fragmentEntryProcessorContext)) != null) {
                String fieldId = editableValueJSONObject.getString("fieldId");
                mappedValueConfigJSONObject = editableElementParser.getFieldTemplateConfigJSONObject(fieldId, fragmentEntryProcessorContext.getLocale(), fieldValue);
                value = editableElementParser.parseFieldValue(fieldValue);
                value = this._fragmentEntryProcessorHelper.processTemplate(value, fragmentEntryProcessorContext);
            }
            if (Validator.isNull((String)value)) {
                value = this._fragmentEntryProcessorHelper.getEditableValue(editableValueJSONObject, fragmentEntryProcessorContext.getLocale(), fragmentEntryProcessorContext.getSegmentsExperienceIds());
            }
            if (Objects.equals(fragmentEntryProcessorContext.getMode(), "EDIT")) {
                editableElementParser.replace(element, value);
                continue;
            }
            JSONObject configJSONObject = JSONUtil.merge((JSONObject)editableValueJSONObject.getJSONObject("config"), (JSONObject)mappedValueConfigJSONObject);
            editableElementParser.replace(element, value, configJSONObject);
            String mapperType = configJSONObject.getString("mapperType", element.attr("type"));
            EditableElementMapper editableElementMapper = this._editableElementMappers.get(mapperType);
            if (editableElementMapper == null) continue;
            editableElementMapper.map(element, configJSONObject, fragmentEntryProcessorContext);
        }
        if (Objects.equals(fragmentEntryProcessorContext.getMode(), "ASSET_DISPLAY_PAGE") || Objects.equals(fragmentEntryProcessorContext.getMode(), "VIEW")) {
            for (Element element : document.select("lfr-editable")) {
                element.removeAttr("id");
                element.removeAttr("type");
                String tagName = element.attr("view-tag-name");
                if (!Objects.equals(tagName, "span")) {
                    tagName = "div";
                }
                element.tagName(tagName);
                element.removeAttr("view-tag-name");
            }
        }
        Element bodyElement = document.body();
        if (!infoDisplaysFieldValues.containsKey(fragmentEntryProcessorContext.getPreviewClassPK())) {
            return bodyElement.html();
        }
        Element previewElement = new Element("div");
        previewElement.attr("style", "border: 1px solid #0B5FFF");
        bodyElement = previewElement.html(bodyElement.html());
        return bodyElement.outerHtml();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void registerEditableElementMapper(EditableElementMapper editableElementMapper, Map<String, Object> properties) {
        String type = (String)properties.get("type");
        this._editableElementMappers.put(type, editableElementMapper);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void registerEditableElementParser(EditableElementParser editableElementParser, Map<String, Object> properties) {
        String editableTagName = (String)properties.get("type");
        this._editableElementParsers.put(editableTagName, editableElementParser);
    }

    public void unregisterEditableElementMapper(EditableElementMapper editableElementMapper, Map<String, Object> properties) {
        String type = (String)properties.get("type");
        this._editableElementMappers.remove(type);
    }

    public void unregisterEditableElementParser(EditableElementParser editableElementParser, Map<String, Object> properties) {
        String editableTagName = (String)properties.get("type");
        this._editableElementParsers.remove(editableTagName);
    }

    public void validateFragmentEntryHTML(String html, String configuration) throws PortalException {
        this._validateAttributes(html);
        this._validateDuplicatedIds(html);
        this._validateEditableElements(html);
    }

    private JSONObject _getDefaultEditableValuesJSONObject(String html) {
        JSONObject defaultEditableValuesJSONObject = JSONFactoryUtil.createJSONObject();
        Document document = this._getDocument(html);
        for (Element element : document.select("lfr-editable")) {
            EditableElementParser editableElementParser = this._editableElementParsers.get(element.attr("type"));
            if (editableElementParser == null) continue;
            defaultEditableValuesJSONObject.put(element.attr("id"), JSONUtil.put((String)"config", (Object)editableElementParser.getAttributes(element)).put("defaultValue", editableElementParser.getValue(element)));
        }
        return defaultEditableValuesJSONObject;
    }

    private Document _getDocument(String html) {
        Document document = Jsoup.parseBodyFragment((String)html);
        Document.OutputSettings outputSettings = new Document.OutputSettings();
        outputSettings.prettyPrint(false);
        document.outputSettings(outputSettings);
        return document;
    }

    private void _validateAttribute(Element element, String attributeName) throws FragmentEntryContentException {
        if (Validator.isNotNull((String)element.attr(attributeName))) {
            return;
        }
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
        throw new FragmentEntryContentException(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"you-must-define-all-require-attributes-x-for-each-editable-element", (Object)StringUtil.merge((Object[])_REQUIRED_ATTRIBUTE_NAMES)));
    }

    private void _validateAttributes(String html) throws FragmentEntryContentException {
        Document document = this._getDocument(html);
        for (Element element : document.getElementsByTag("lfr-editable")) {
            for (String attributeName : _REQUIRED_ATTRIBUTE_NAMES) {
                this._validateAttribute(element, attributeName);
            }
            this._validateType(element);
        }
    }

    private void _validateDuplicatedIds(String html) throws FragmentEntryContentException {
        Document document = this._getDocument(html);
        Elements elements = document.getElementsByTag("lfr-editable");
        Stream uniqueNodesStream = elements.stream();
        Map<String, Long> idsMap = uniqueNodesStream.collect(Collectors.groupingBy(element -> element.attr("id"), Collectors.counting()));
        Set<String> ids = idsMap.keySet();
        Stream<Object> idsStream = ids.stream();
        if ((idsStream = idsStream.filter(id -> (Long)idsMap.get(id) > 1L)).count() > 0L) {
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
            throw new FragmentEntryContentException(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"you-must-define-a-unique-id-for-each-editable-element"));
        }
    }

    private void _validateEditableElements(String html) throws FragmentEntryContentException {
        Document document = this._getDocument(html);
        for (Element element : document.select("lfr-editable")) {
            EditableElementParser editableElementParser = this._editableElementParsers.get(element.attr("type"));
            if (editableElementParser == null) continue;
            this._validateNestedEditableElements(element);
            editableElementParser.validate(element);
        }
    }

    private void _validateNestedEditableElements(Element element) throws FragmentEntryContentException {
        Elements elements = element.select("> lfr-editable");
        if (elements.size() > 0) {
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
            throw new FragmentEntryContentException(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"editable-fields-cannot-include-nested-editables-in-it"));
        }
    }

    private void _validateType(Element element) throws FragmentEntryContentException {
        EditableElementParser editableElementParser = this._editableElementParsers.get(element.attr("type"));
        if (editableElementParser != null) {
            return;
        }
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
        throw new FragmentEntryContentException(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"you-must-define-a-valid-type-for-each-editable-element"));
    }
}

