/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.data.handler;

import com.liferay.batch.engine.BatchEngineExportTaskExecutor;
import com.liferay.batch.engine.BatchEngineImportTaskExecutor;
import com.liferay.batch.engine.BatchEngineTaskExecuteStatus;
import com.liferay.batch.engine.BatchEngineTaskOperation;
import com.liferay.batch.engine.constants.CreateStrategy;
import com.liferay.batch.engine.model.BatchEngineExportTask;
import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.batch.engine.service.BatchEngineExportTaskLocalService;
import com.liferay.batch.engine.service.BatchEngineImportTaskService;
import com.liferay.exportimport.internal.data.handler.BatchEnginePortletDataHandlerUtil;
import com.liferay.exportimport.internal.lar.PortletDataContextThreadLocal;
import com.liferay.exportimport.kernel.lar.BasePortletDataHandler;
import com.liferay.exportimport.kernel.lar.DataLevel;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerControl;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.vulcan.batch.engine.ExportImportVulcanBatchEngineTaskItemDelegate;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.staging.StagingGroupHelper;
import jakarta.portlet.PortletPreferences;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class BatchEnginePortletDataHandler
extends BasePortletDataHandler {
    public static final String BATCH_DELETE_CLASS_NAME_POSTFIX = "_batchDeleteExternalReferenceCodes";
    public static final String SCHEMA_VERSION = "4.0.0";
    protected static final TransactionConfig transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRES_NEW, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    private final BatchEngineExportTaskExecutor _batchEngineExportTaskExecutor;
    private final BatchEngineExportTaskLocalService _batchEngineExportTaskLocalService;
    private final BatchEngineImportTaskExecutor _batchEngineImportTaskExecutor;
    private final BatchEngineImportTaskService _batchEngineImportTaskService;
    private final GroupLocalService _groupLocalService;
    private final List<Registration> _registrations = new ArrayList<Registration>();
    private final StagingGroupHelper _stagingGroupHelper;

    public BatchEnginePortletDataHandler(BatchEngineExportTaskExecutor batchEngineExportTaskExecutor, BatchEngineExportTaskLocalService batchEngineExportTaskLocalService, BatchEngineImportTaskExecutor batchEngineImportTaskExecutor, BatchEngineImportTaskService batchEngineImportTaskService, GroupLocalService groupLocalService, StagingGroupHelper stagingGroupHelper) {
        this._batchEngineExportTaskExecutor = batchEngineExportTaskExecutor;
        this._batchEngineExportTaskLocalService = batchEngineExportTaskLocalService;
        this._batchEngineImportTaskExecutor = batchEngineImportTaskExecutor;
        this._batchEngineImportTaskService = batchEngineImportTaskService;
        this._groupLocalService = groupLocalService;
        this._stagingGroupHelper = stagingGroupHelper;
    }

    public void exportDeletionSystemEvents(PortletDataContext portletDataContext) throws Exception {
        for (Registration registration : this._getActiveRegistrations(portletDataContext)) {
            ExportImportVulcanBatchEngineTaskItemDelegate.ExportImportDescriptor exportImportDescriptor = registration.getExportImportDescriptor();
            Map newPrimaryKeysMap = portletDataContext.getNewPrimaryKeysMap(exportImportDescriptor.getModelClassName() + BATCH_DELETE_CLASS_NAME_POSTFIX);
            portletDataContext.addZipEntry(this._normalize(registration.getDeletionsFileName(), portletDataContext.getScopeGroupId()), JSONUtil.toJSONArray((Collection)ListUtil.filter((List)ListUtil.fromCollection(newPrimaryKeysMap.keySet()), arg_0 -> ((ExportImportVulcanBatchEngineTaskItemDelegate.ExportImportDescriptor)exportImportDescriptor).isApplicableExternalReferenceCode(arg_0)), externalReferenceCode -> JSONUtil.put((String)"externalReferenceCode", (Object)externalReferenceCode)).toString());
        }
    }

    public String[] getClassNames() {
        return (String[])TransformUtil.transformToArray((Collection)TransformUtil.transform(this._registrations, Registration::getExportImportDescriptor), ExportImportVulcanBatchEngineTaskItemDelegate.ExportImportDescriptor::getModelClassName, String.class);
    }

    public String getName() {
        return this.getPortletId();
    }

    public String getSchemaVersion() {
        return SCHEMA_VERSION;
    }

    public boolean isBatch() {
        return true;
    }

    public void registerExportImportVulcanBatchEngineTaskItemDelegate(final String batchEngineClassName, final ExportImportVulcanBatchEngineTaskItemDelegate.ExportImportDescriptor exportImportDescriptor, final String taskItemDelegateName) {
        final String fileNamePrefix = GetterUtil.getString((String)taskItemDelegateName, (String)batchEngineClassName);
        this._registrations.add(new Registration(){

            @Override
            public String getBatchEngineClassName() {
                return batchEngineClassName;
            }

            @Override
            public String getDeletionsFileName() {
                return fileNamePrefix + "_deletions.json";
            }

            @Override
            public ExportImportVulcanBatchEngineTaskItemDelegate.ExportImportDescriptor getExportImportDescriptor() {
                return exportImportDescriptor;
            }

            @Override
            public String getFileName() {
                return fileNamePrefix + ".json";
            }

            @Override
            public String getTaskItemDelegateName() {
                return taskItemDelegateName;
            }
        });
        if (ExportImportVulcanBatchEngineTaskItemDelegate.Scope.COMPANY.equals((Object)exportImportDescriptor.getScope())) {
            this.setDataLevel(DataLevel.PORTAL);
        } else if (ExportImportVulcanBatchEngineTaskItemDelegate.Scope.DEPOT.equals((Object)exportImportDescriptor.getScope())) {
            this.setDataLevel(DataLevel.DEPOT);
        } else if (ExportImportVulcanBatchEngineTaskItemDelegate.Scope.SITE.equals((Object)exportImportDescriptor.getScope())) {
            this.setDataLevel(DataLevel.SITE);
        }
        this._updateDeletionSystemEventStagedModelTypes();
        this._updateExportControls();
    }

    public void unregisterExportImportVulcanBatchEngineTaskItemDelegate(String batchEngineClassName, String taskItemDelegateName) {
        Iterator<Registration> iterator = this._registrations.iterator();
        while (iterator.hasNext()) {
            Registration registration = iterator.next();
            if (!Objects.equals(registration.getBatchEngineClassName(), batchEngineClassName) || !Objects.equals(registration.getTaskItemDelegateName(), taskItemDelegateName)) continue;
            iterator.remove();
            this._updateDeletionSystemEventStagedModelTypes();
            this._updateExportControls();
            return;
        }
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletDataContext.getZipReader() == null) {
            return portletPreferences;
        }
        for (Registration registration : this._getActiveRegistrations(portletDataContext)) {
            InputStream inputStream = portletDataContext.getZipEntryAsInputStream(this._normalize(registration.getDeletionsFileName(), portletDataContext.getSourceGroupId()));
            if (inputStream == null) {
                return portletPreferences;
            }
            BatchEngineImportTask batchEngineDeleteTask = this._batchEngineImportTaskService.addBatchEngineImportTask(null, portletDataContext.getCompanyId(), this._getUserId(), 100L, null, registration.getBatchEngineClassName(), this._getBytes(this._normalize(registration.getFileName(), portletDataContext.getSourceGroupId()), inputStream), "JSON", BatchEngineTaskExecuteStatus.INITIAL.name(), Collections.emptyMap(), 1, BatchEngineTaskOperation.DELETE.name(), (Map)HashMapBuilder.put((Object)"createStrategy", (Object)CreateStrategy.UPSERT.getDBOperation()).build(), registration.getTaskItemDelegateName());
            this._batchEngineImportTaskExecutor.execute(batchEngineDeleteTask);
        }
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) {
        try (SafeCloseable safeCloseable = PortletDataContextThreadLocal.setPortletDataContextWithSafeCloseable(portletDataContext);){
            List<Registration> activeRegistrations = this._getActiveRegistrations(portletDataContext);
            for (Registration registration : activeRegistrations) {
                BatchEngineExportTaskExecutor.Result result;
                ExportImportVulcanBatchEngineTaskItemDelegate.ExportImportDescriptor exportImportDescriptor = registration.getExportImportDescriptor();
                if (activeRegistrations.size() > 1 && !portletDataContext.getBooleanParameter(this.getPortletId(), exportImportDescriptor.getResourceClassName()) || (result = this._executeExportTask(Integer.MAX_VALUE, portletDataContext, registration)) == null) continue;
                portletDataContext.addZipEntry(this._normalize(registration.getFileName(), portletDataContext.getScopeGroupId()), result.getInputStream());
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                BatchEngineExportTask batchEngineExportTask = result.getBatchEngineExportTask();
                manifestSummary.addModelAdditionCount(new StagedModelType(exportImportDescriptor.getResourceClassName()), (long)batchEngineExportTask.getProcessedItemsCount());
            }
            portletDataContext.setValidateExistingDataHandler(true);
            String string = this.getExportDataRootElementString(this.addExportDataRootElement(portletDataContext));
            return string;
        }
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        List<Registration> activeRegistrations = this._getActiveRegistrations(portletDataContext);
        for (Registration registration : activeRegistrations) {
            String normalizedFileName;
            InputStream inputStream;
            ExportImportVulcanBatchEngineTaskItemDelegate.ExportImportDescriptor exportImportDescriptor = registration.getExportImportDescriptor();
            if (activeRegistrations.size() > 1 && !portletDataContext.getBooleanParameter(this.getPortletId(), exportImportDescriptor.getResourceClassName()) || (inputStream = portletDataContext.getZipEntryAsInputStream(normalizedFileName = this._normalize(registration.getFileName(), portletDataContext.getSourceGroupId()))) == null) continue;
            BatchEngineImportTask batchEngineImportTask = this._batchEngineImportTaskService.addBatchEngineImportTask(null, portletDataContext.getCompanyId(), this._getUserId(), 100L, null, registration.getBatchEngineClassName(), this._getBytes(normalizedFileName, inputStream), "JSON", BatchEngineTaskExecuteStatus.INITIAL.name(), Collections.emptyMap(), 1, BatchEngineTaskOperation.CREATE.name(), BatchEnginePortletDataHandlerUtil.buildImportParameters(registration.getExportImportDescriptor(), portletDataContext, this._getSiteExternalReferenceCode(portletDataContext)), registration.getTaskItemDelegateName());
            try (SafeCloseable safeCloseable = PortletDataContextThreadLocal.setPortletDataContextWithSafeCloseable(portletDataContext);){
                this._batchEngineImportTaskExecutor.execute(batchEngineImportTask);
            }
            BatchEngineTaskExecuteStatus batchEngineTaskExecuteStatus = BatchEngineTaskExecuteStatus.valueOf((String)(batchEngineImportTask = this._batchEngineImportTaskService.getBatchEngineImportTask(batchEngineImportTask.getBatchEngineImportTaskId())).getExecuteStatus());
            if (batchEngineTaskExecuteStatus != BatchEngineTaskExecuteStatus.FAILED) continue;
            throw new PortletDataException("Unable to import batch data: " + batchEngineImportTask.getErrorMessage());
        }
        return portletPreferences;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) {
        for (Registration registration : this._getActiveRegistrations(portletDataContext)) {
            SafeCloseable safeCloseable = PortletDataContextThreadLocal.setPortletDataContextWithSafeCloseable(portletDataContext);
            try {
                BatchEngineExportTaskExecutor.Result result = this._executeExportTask(1, portletDataContext, registration);
                if (result == null) continue;
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                ExportImportVulcanBatchEngineTaskItemDelegate.ExportImportDescriptor exportImportDescriptor = registration.getExportImportDescriptor();
                BatchEngineExportTask batchEngineExportTask = result.getBatchEngineExportTask();
                manifestSummary.addModelAdditionCount(new StagedModelType(exportImportDescriptor.getResourceClassName()), (long)batchEngineExportTask.getTotalItemsCount());
            }
            finally {
                if (safeCloseable == null) continue;
                safeCloseable.close();
            }
        }
    }

    protected long getExportModelCount(ManifestSummary manifestSummary, PortletDataHandlerControl[] portletDataHandlerControls) {
        if (this._registrations.size() == 1) {
            return super.getExportModelCount(manifestSummary, new PortletDataHandlerControl[]{this._getPortletDataHandlerControl(this._registrations.get(0))});
        }
        return super.getExportModelCount(manifestSummary, portletDataHandlerControls);
    }

    private BatchEngineExportTaskExecutor.Result _executeExportTask(final int maxItems, PortletDataContext portletDataContext, Registration registration) {
        return this._batchEngineExportTaskExecutor.execute(this._batchEngineExportTaskLocalService.createBatchEngineExportTask(0L, null, portletDataContext.getCompanyId(), this._getUserId(), null, registration.getBatchEngineClassName(), "JSON", BatchEngineTaskExecuteStatus.INITIAL.name(), Collections.emptyList(), BatchEnginePortletDataHandlerUtil.buildExportParameters(registration.getExportImportDescriptor(), portletDataContext, this._getSiteExternalReferenceCode(portletDataContext)), registration.getTaskItemDelegateName()), new BatchEngineExportTaskExecutor.Settings(){

            public int getMaxItems() {
                return maxItems;
            }

            public boolean isCompressContent() {
                return false;
            }

            public boolean isPersist() {
                return false;
            }
        });
    }

    private List<Registration> _getActiveRegistrations(PortletDataContext portletDataContext) {
        return ListUtil.filter(this._registrations, registration -> {
            ExportImportVulcanBatchEngineTaskItemDelegate.ExportImportDescriptor exportImportDescriptor = registration.getExportImportDescriptor();
            return exportImportDescriptor.isActive(portletDataContext);
        });
    }

    private byte[] _getBytes(String fileName, InputStream inputStream) throws Exception {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        try (ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)unsyncByteArrayOutputStream);){
            ZipEntry zipEntry = new ZipEntry(fileName);
            zipOutputStream.putNextEntry(zipEntry);
            StreamUtil.transfer((InputStream)inputStream, (OutputStream)zipOutputStream, (boolean)false);
        }
        return unsyncByteArrayOutputStream.toByteArray();
    }

    private PortletDataHandlerControl _getPortletDataHandlerControl(Registration registration) {
        ExportImportVulcanBatchEngineTaskItemDelegate.ExportImportDescriptor exportImportDescriptor = registration.getExportImportDescriptor();
        return new PortletDataHandlerBoolean(this.getPortletId(), exportImportDescriptor.getResourceClassName(), exportImportDescriptor.getLabelLanguageKey(), true, false, null, exportImportDescriptor.getResourceClassName(), null);
    }

    private String _getSiteExternalReferenceCode(PortletDataContext portletDataContext) {
        Group group = this._groupLocalService.fetchGroup(portletDataContext.getScopeGroupId());
        if (group != null && !this._stagingGroupHelper.isCompanyGroup(group)) {
            return group.getExternalReferenceCode();
        }
        return null;
    }

    private long _getUserId() {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        return permissionChecker.getUserId();
    }

    private String _normalize(String fileName, long groupId) {
        return StringBundler.concat((Object[])new Object[]{"/", "group", "/", groupId, "/", fileName});
    }

    private void _updateDeletionSystemEventStagedModelTypes() {
        this.setDeletionSystemEventStagedModelTypes((StagedModelType[])TransformUtil.transformToArray(this._registrations, registration -> {
            ExportImportVulcanBatchEngineTaskItemDelegate.ExportImportDescriptor exportImportDescriptor = registration.getExportImportDescriptor();
            return new StagedModelType(exportImportDescriptor.getModelClassName());
        }, StagedModelType.class));
    }

    private void _updateExportControls() {
        if (this._registrations.size() > 1) {
            this.setExportControls((PortletDataHandlerControl[])TransformUtil.transformToArray(this._registrations, this::_getPortletDataHandlerControl, PortletDataHandlerControl.class));
            this.setEmptyControlsAllowed(false);
        } else {
            this.setEmptyControlsAllowed(true);
            this.setExportControls(new PortletDataHandlerControl[0]);
        }
    }

    private static interface Registration {
        public String getBatchEngineClassName();

        public String getDeletionsFileName();

        public ExportImportVulcanBatchEngineTaskItemDelegate.ExportImportDescriptor getExportImportDescriptor();

        public String getFileName();

        public String getTaskItemDelegateName();
    }
}

