/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.staging;

import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.staging.StagingURLHelper;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={StagingURLHelper.class})
public class StagingURLHelperImpl
implements StagingURLHelper {
    public String buildRemoteURL(ExportImportConfiguration exportImportConfiguration) {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        String remoteAddress = MapUtil.getString((Map)settingsMap, (String)"remoteAddress");
        int remotePort = MapUtil.getInteger((Map)settingsMap, (String)"remotePort");
        String remotePathContext = MapUtil.getString((Map)settingsMap, (String)"remotePathContext");
        boolean secureConnection = MapUtil.getBoolean((Map)settingsMap, (String)"secureConnection");
        return this.buildRemoteURL(remoteAddress, remotePort, remotePathContext, secureConnection);
    }

    public String buildRemoteURL(String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection) {
        StringBundler sb = new StringBundler(5);
        if (secureConnection) {
            sb.append("https://");
        } else {
            sb.append("http://");
        }
        sb.append(remoteAddress);
        if (remotePort > 0) {
            sb.append(":");
            sb.append(remotePort);
        }
        if (Validator.isNotNull((String)remotePathContext)) {
            sb.append(remotePathContext);
        }
        return sb.toString();
    }

    public String buildRemoteURL(UnicodeProperties typeSettingsUnicodeProperties) {
        String remoteAddress = typeSettingsUnicodeProperties.getProperty("remoteAddress");
        int remotePort = GetterUtil.getInteger((String)typeSettingsUnicodeProperties.getProperty("remotePort"));
        String remotePathContext = typeSettingsUnicodeProperties.getProperty("remotePathContext");
        boolean secureConnection = GetterUtil.getBoolean((String)typeSettingsUnicodeProperties.getProperty("secureConnection"));
        return this.buildRemoteURL(remoteAddress, remotePort, remotePathContext, secureConnection);
    }
}

