/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.template;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.template.DDMTemplateResource;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.template.TemplateResourceParser;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"lang.type=ftl", "lang.type=vm"}, service={TemplateResourceParser.class})
public class DDMTemplateResourceParser
implements TemplateResourceParser {
    private static final Log _log = LogFactoryUtil.getLog(DDMTemplateResourceParser.class);
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Portal _portal;

    public TemplateResource getTemplateResource(String templateId) throws TemplateException {
        int pos = templateId.indexOf("_TEMPLATE_CONTEXT_/");
        if (pos == -1) {
            return null;
        }
        try {
            DDMTemplate ddmTemplate;
            int w = templateId.indexOf(47, pos);
            int x = templateId.indexOf(47, w + 1);
            int y = templateId.indexOf(47, x + 1);
            int z = templateId.indexOf(47, y + 1);
            long companyId = GetterUtil.getLong((String)templateId.substring(w + 1, x));
            long groupId = GetterUtil.getLong((String)templateId.substring(x + 1, y));
            long classNameId = GetterUtil.getLong((String)templateId.substring(y + 1, z));
            String ddmTemplateKey = templateId.substring(z + 1);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Loading {companyId=", companyId, ", groupId=", groupId, ", classNameId=", classNameId, ", ddmTemplateKey=", ddmTemplateKey, "}"}));
            }
            if ((ddmTemplate = this._ddmTemplateLocalService.fetchTemplate(groupId, classNameId, ddmTemplateKey)) == null) {
                Group companyGroup = this._groupLocalService.getCompanyGroup(companyId);
                ddmTemplate = this._ddmTemplateLocalService.fetchTemplate(companyGroup.getGroupId(), classNameId, ddmTemplateKey);
                if (ddmTemplate == null) {
                    classNameId = this._portal.getClassNameId(DDMStructure.class);
                    ddmTemplate = this._ddmTemplateLocalService.fetchTemplate(groupId, classNameId, ddmTemplateKey);
                }
                if (ddmTemplate == null) {
                    ddmTemplate = this._ddmTemplateLocalService.fetchTemplate(companyGroup.getGroupId(), classNameId, ddmTemplateKey);
                }
            }
            if (ddmTemplate == null) {
                return null;
            }
            return new DDMTemplateResource(ddmTemplate.getTemplateKey(), ddmTemplate);
        }
        catch (Exception exception) {
            throw new TemplateException("Unable to find template " + templateId, (Throwable)exception);
        }
    }

    public boolean isTemplateResourceValid(String templateId, String langType) {
        return templateId.contains("_TEMPLATE_CONTEXT_");
    }
}

