/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.exception.FormInstanceNameException;
import com.liferay.dynamic.data.mapping.exception.FormInstanceStructureIdException;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceSettings;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceVersion;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordLocalService;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceVersionLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.base.DDMFormInstanceLocalServiceBaseImpl;
import com.liferay.dynamic.data.mapping.service.persistence.DDMFormInstanceVersionPersistence;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.StorageType;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.dynamic.data.mapping.util.DDMFormInstanceFactory;
import com.liferay.dynamic.data.mapping.validator.DDMFormValuesValidator;
import com.liferay.mail.kernel.model.MailMessage;
import com.liferay.mail.kernel.service.MailService;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinition;
import com.liferay.portal.workflow.kaleo.service.KaleoDefinitionLocalService;
import jakarta.mail.internet.InternetAddress;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.dynamic.data.mapping.model.DDMFormInstance"}, service={AopService.class})
public class DDMFormInstanceLocalServiceImpl
extends DDMFormInstanceLocalServiceBaseImpl {
    private static final String _VERSION_DEFAULT = "1.0";
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private DDMFormInstanceRecordLocalService _ddmFormInstanceRecordLocalService;
    @Reference
    private DDMFormInstanceVersionLocalService _ddmFormInstanceVersionLocalService;
    @Reference
    private DDMFormInstanceVersionPersistence _ddmFormInstanceVersionPersistence;
    @Reference
    private DDMFormValuesValidator _ddmFormValuesValidator;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference(target="(ddm.form.values.deserializer.type=json)")
    private DDMFormValuesDeserializer _jsonDDMFormValuesDeserializer;
    @Reference(target="(ddm.form.values.serializer.type=json)")
    private DDMFormValuesSerializer _jsonDDMFormValuesSerializer;
    @Reference
    private KaleoDefinitionLocalService _kaleoDefinitionLocalService;
    @Reference
    private MailService _mailService;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;

    public DDMFormInstance addFormInstance(long userId, long groupId, long ddmStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMFormValues settingsDDMFormValues, ServiceContext serviceContext) throws PortalException {
        Locale defaultLocale = this._getDDMFormDefaultLocale(ddmStructureId);
        User user = this._userLocalService.getUser(userId);
        this._validate(ddmStructureId, defaultLocale, nameMap, settingsDDMFormValues, user.getTimeZone());
        long ddmFormInstanceId = this.counterLocalService.increment();
        DDMFormInstance ddmFormInstance = this.ddmFormInstancePersistence.create(ddmFormInstanceId);
        ddmFormInstance.setUuid(serviceContext.getUuid());
        ddmFormInstance.setGroupId(groupId);
        ddmFormInstance.setCompanyId(user.getCompanyId());
        ddmFormInstance.setUserId(user.getUserId());
        ddmFormInstance.setUserName(user.getFullName());
        ddmFormInstance.setStructureId(ddmStructureId);
        ddmFormInstance.setVersion(_VERSION_DEFAULT);
        ddmFormInstance.setNameMap(nameMap, defaultLocale);
        ddmFormInstance.setDescriptionMap(descriptionMap, defaultLocale);
        ddmFormInstance.setSettings(this._serialize(settingsDDMFormValues));
        DDMFormInstance updatedDDMFormInstance = (DDMFormInstance)this.ddmFormInstancePersistence.update((BaseModel)ddmFormInstance);
        this._updateWorkflowDefinitionLink(ddmFormInstance, settingsDDMFormValues, serviceContext);
        if (GetterUtil.getBoolean((Object)serviceContext.getAttribute("addResources"), (boolean)true)) {
            if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
                this.addFormInstanceResources(ddmFormInstance, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
            } else {
                this.addFormInstanceResources(ddmFormInstance, serviceContext.getModelPermissions());
            }
        }
        this._addFormInstanceVersion(this._getStructureVersionId(ddmStructureId), user, ddmFormInstance, _VERSION_DEFAULT, serviceContext);
        return updatedDDMFormInstance;
    }

    public DDMFormInstance addFormInstance(long userId, long groupId, long ddmStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String serializedSettingsDDMFormValues, ServiceContext serviceContext) throws PortalException {
        DDMFormValues settingsDDMFormValues = this._getFormInstanceSettingsFormValues(serializedSettingsDDMFormValues);
        return this.addFormInstance(userId, groupId, ddmStructureId, nameMap, descriptionMap, settingsDDMFormValues, serviceContext);
    }

    public DDMFormInstance addFormInstance(long userId, long groupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, DDMFormValues settingsDDMFormValues, ServiceContext serviceContext) throws PortalException {
        DDMStructure ddmStructure = this._ddmStructureLocalService.addStructure(null, userId, groupId, 0L, this._classNameLocalService.getClassNameId(DDMFormInstance.class), "", nameMap, descriptionMap, ddmForm, ddmFormLayout, this._getStorageType(settingsDDMFormValues), 1, serviceContext);
        return this.addFormInstance(userId, groupId, ddmStructure.getStructureId(), nameMap, descriptionMap, settingsDDMFormValues, serviceContext);
    }

    public void addFormInstanceResources(DDMFormInstance ddmFormInstance, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this._resourceLocalService.addResources(ddmFormInstance.getCompanyId(), ddmFormInstance.getGroupId(), ddmFormInstance.getUserId(), DDMFormInstance.class.getName(), ddmFormInstance.getFormInstanceId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addFormInstanceResources(DDMFormInstance ddmFormInstance, ModelPermissions modelPermissions) throws PortalException {
        this._resourceLocalService.addModelResources(ddmFormInstance.getCompanyId(), ddmFormInstance.getGroupId(), ddmFormInstance.getUserId(), DDMFormInstance.class.getName(), ddmFormInstance.getFormInstanceId(), modelPermissions);
    }

    public DDMFormInstance copyFormInstance(long userId, long groupId, Map<Locale, String> nameMap, DDMFormInstance sourceDDMFormInstance, DDMFormValues settingsDDMFormValues, ServiceContext serviceContext) throws PortalException {
        DDMStructure sourceDDMStructure = sourceDDMFormInstance.getStructure();
        serviceContext.setAttribute("addResources", (Serializable)Boolean.FALSE);
        DDMFormInstance targetDDMFormInstance = this.addFormInstance(userId, groupId, nameMap, sourceDDMFormInstance.getDescriptionMap(), sourceDDMStructure.getDDMForm(), sourceDDMStructure.getDDMFormLayout(), settingsDDMFormValues, serviceContext);
        this._resourceLocalService.copyModelResources(sourceDDMFormInstance.getCompanyId(), DDMFormInstance.class.getName(), sourceDDMFormInstance.getFormInstanceId(), targetDDMFormInstance.getFormInstanceId());
        return targetDDMFormInstance;
    }

    @SystemEvent(action=1, type=1)
    public void deleteFormInstance(DDMFormInstance ddmFormInstance) throws PortalException {
        this._resourceLocalService.deleteResource(ddmFormInstance.getCompanyId(), DDMFormInstance.class.getName(), 4, ddmFormInstance.getFormInstanceId());
        this._ddmFormInstanceRecordLocalService.deleteFormInstanceRecords(ddmFormInstance.getFormInstanceId());
        this._ddmFormInstanceVersionLocalService.deleteByFormInstanceId(ddmFormInstance.getFormInstanceId());
        long structureId = ddmFormInstance.getStructureId();
        if (this._ddmStructureLocalService.fetchDDMStructure(structureId) != null) {
            this._ddmStructureLocalService.deleteStructure(structureId);
        }
        this._workflowDefinitionLinkLocalService.deleteWorkflowDefinitionLink(ddmFormInstance.getCompanyId(), ddmFormInstance.getGroupId(), DDMFormInstance.class.getName(), ddmFormInstance.getFormInstanceId(), 0L);
        this.deleteDDMFormInstance(ddmFormInstance);
    }

    public void deleteFormInstance(long ddmFormInstanceId) throws PortalException {
        DDMFormInstance ddmFormInstance = this.ddmFormInstancePersistence.findByPrimaryKey(ddmFormInstanceId);
        this.deleteFormInstance(ddmFormInstance);
    }

    public void deleteFormInstances(long groupId) throws PortalException {
        List ddmFormInstances = this.ddmFormInstancePersistence.findByGroupId(groupId);
        for (DDMFormInstance ddmFormInstance : ddmFormInstances) {
            this.deleteFormInstance(ddmFormInstance);
        }
    }

    public DDMFormInstance fetchFormInstance(long ddmFormInstanceId) {
        return this.ddmFormInstancePersistence.fetchByPrimaryKey(ddmFormInstanceId);
    }

    public DDMFormInstance getFormInstance(long ddmFormInstanceId) throws PortalException {
        return this.ddmFormInstancePersistence.findByPrimaryKey(ddmFormInstanceId);
    }

    public DDMFormInstance getFormInstance(String uuid, long ddmFormInstanceId) throws PortalException {
        return this.ddmFormInstancePersistence.findByUUID_G(uuid, ddmFormInstanceId);
    }

    public DDMFormInstance getFormInstanceByStructureId(long structureId) throws PortalException {
        return this.ddmFormInstancePersistence.findByStructureId(structureId);
    }

    public List<DDMFormInstance> getFormInstances(long groupId) {
        return this.ddmFormInstancePersistence.findByGroupId(groupId);
    }

    public int getFormInstancesCount(long groupId) {
        return this.ddmFormInstancePersistence.countByGroupId(groupId);
    }

    public int getFormInstancesCount(String uuid) throws PortalException {
        return this.ddmFormInstancePersistence.countByUuid(uuid);
    }

    public DDMFormValues getFormInstanceSettingsFormValues(DDMFormInstance formInstance) throws PortalException {
        return this._getFormInstanceSettingsFormValues(formInstance.getSettings());
    }

    public DDMFormInstanceSettings getFormInstanceSettingsModel(DDMFormInstance formInstance) throws PortalException {
        DDMFormValues formValues = this.getFormInstanceSettingsFormValues(formInstance);
        return (DDMFormInstanceSettings)DDMFormInstanceFactory.create(DDMFormInstanceSettings.class, (DDMFormValues)formValues);
    }

    public List<DDMFormInstance> search(long companyId, long groupId, String keywords, int start, int end, OrderByComparator<DDMFormInstance> orderByComparator) {
        return this.ddmFormInstanceFinder.findByKeywords(companyId, groupId, keywords, start, end, orderByComparator);
    }

    public List<DDMFormInstance> search(long companyId, long groupId, String[] names, String[] descriptions, boolean andOperator, int start, int end, OrderByComparator<DDMFormInstance> orderByComparator) {
        return this.ddmFormInstanceFinder.findByC_G_N_D(companyId, groupId, names, descriptions, andOperator, start, end, orderByComparator);
    }

    public int searchCount(long companyId, long groupId, String keywords) {
        return this.ddmFormInstanceFinder.countByKeywords(companyId, groupId, keywords);
    }

    public int searchCount(long companyId, long groupId, String[] names, String[] descriptions, boolean andOperator) {
        return this.ddmFormInstanceFinder.countByC_G_N_D(companyId, groupId, names, descriptions, andOperator);
    }

    public void sendEmail(long userId, String message, String subject, String[] toEmailAddresses) throws Exception {
        User user = this._userLocalService.getUser(userId);
        MailMessage mailMessage = new MailMessage(new InternetAddress(user.getEmailAddress(), user.getFullName()), subject, message, false);
        ArrayList<InternetAddress> internetAddresses = new ArrayList<InternetAddress>();
        for (String toEmailAddress : toEmailAddresses) {
            internetAddresses.add(new InternetAddress(toEmailAddress));
        }
        mailMessage.setTo(internetAddresses.toArray(new InternetAddress[0]));
        this._mailService.sendEmail(mailMessage);
    }

    public DDMFormInstance updateFormInstance(long formInstanceId, DDMFormValues settingsDDMFormValues) throws PortalException {
        Date date = new Date();
        this._validateFormInstanceSettings(settingsDDMFormValues, null);
        DDMFormInstance formInstance = this.ddmFormInstancePersistence.findByPrimaryKey(formInstanceId);
        formInstance.setModifiedDate(date);
        formInstance.setSettings(this._serialize(settingsDDMFormValues));
        return (DDMFormInstance)this.ddmFormInstancePersistence.update((BaseModel)formInstance);
    }

    public DDMFormInstance updateFormInstance(long userId, long ddmFormInstanceId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, DDMFormValues settingsDDMFormValues, ServiceContext serviceContext) throws PortalException {
        DDMFormInstance ddmFormInstance = this.ddmFormInstancePersistence.findByPrimaryKey(ddmFormInstanceId);
        this._ddmStructureLocalService.updateStructure(serviceContext.getUserId(), ddmFormInstance.getStructureId(), 0L, nameMap, descriptionMap, ddmForm, ddmFormLayout, serviceContext);
        return this._updateFormInstance(userId, ddmFormInstance.getStructureId(), nameMap, descriptionMap, settingsDDMFormValues, serviceContext, ddmFormInstance);
    }

    public DDMFormInstance updateFormInstance(long ddmFormInstanceId, long ddmStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMFormValues settingsDDMFormValues, ServiceContext serviceContext) throws PortalException {
        DDMFormInstance ddmFormInstance = this.ddmFormInstancePersistence.findByPrimaryKey(ddmFormInstanceId);
        return this._updateFormInstance(serviceContext.getUserId(), ddmStructureId, nameMap, descriptionMap, settingsDDMFormValues, serviceContext, ddmFormInstance);
    }

    private DDMFormInstanceVersion _addFormInstanceVersion(long ddmStructureVersionId, User user, DDMFormInstance ddmFormInstance, String version, ServiceContext serviceContext) throws PortalException {
        long ddmFormInstanceVersionId = this.counterLocalService.increment();
        DDMFormInstanceVersion ddmFormInstanceVersion = this._ddmFormInstanceVersionPersistence.create(ddmFormInstanceVersionId);
        ddmFormInstanceVersion.setGroupId(ddmFormInstance.getGroupId());
        ddmFormInstanceVersion.setCompanyId(ddmFormInstance.getCompanyId());
        ddmFormInstanceVersion.setUserId(ddmFormInstance.getUserId());
        ddmFormInstanceVersion.setUserName(ddmFormInstance.getUserName());
        ddmFormInstanceVersion.setCreateDate(ddmFormInstance.getModifiedDate());
        ddmFormInstanceVersion.setFormInstanceId(ddmFormInstance.getFormInstanceId());
        ddmFormInstanceVersion.setStructureVersionId(ddmStructureVersionId);
        ddmFormInstanceVersion.setName(ddmFormInstance.getName());
        ddmFormInstanceVersion.setDescription(ddmFormInstance.getDescription());
        ddmFormInstanceVersion.setSettings(ddmFormInstance.getSettings());
        ddmFormInstanceVersion.setVersion(version);
        ddmFormInstanceVersion.setStatus(GetterUtil.getInteger((Object)serviceContext.getAttribute("status"), (int)0));
        ddmFormInstanceVersion.setStatusByUserId(user.getUserId());
        ddmFormInstanceVersion.setStatusByUserName(user.getFullName());
        ddmFormInstanceVersion.setStatusDate(ddmFormInstance.getModifiedDate());
        return (DDMFormInstanceVersion)this._ddmFormInstanceVersionPersistence.update((BaseModel)ddmFormInstanceVersion);
    }

    private Locale _getDDMFormDefaultLocale(DDMFormInstance ddmFormInstance) throws PortalException {
        DDMStructure ddmStructure = ddmFormInstance.getStructure();
        DDMForm ddmForm = ddmStructure.getDDMForm();
        return ddmForm.getDefaultLocale();
    }

    private Locale _getDDMFormDefaultLocale(long ddmStructureId) throws PortalException {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructure(ddmStructureId);
        DDMForm ddmForm = ddmStructure.getDDMForm();
        return ddmForm.getDefaultLocale();
    }

    private DDMFormValues _getFormInstanceSettingsFormValues(String serializedSettingsDDMFormValues) throws PortalException {
        DDMForm ddmForm = DDMFormFactory.create(DDMFormInstanceSettings.class);
        DDMFormValuesDeserializerDeserializeRequest.Builder builder = DDMFormValuesDeserializerDeserializeRequest.Builder.newBuilder((String)serializedSettingsDDMFormValues, (DDMForm)ddmForm);
        DDMFormValuesDeserializerDeserializeResponse ddmFormValuesDeserializerDeserializeResponse = this._jsonDDMFormValuesDeserializer.deserialize(builder.build());
        return ddmFormValuesDeserializerDeserializeResponse.getDDMFormValues();
    }

    private String _getNextVersion(String version, boolean majorVersion) {
        int[] versionParts = StringUtil.split((String)version, (String)".", (int)0);
        if (majorVersion) {
            versionParts[0] = versionParts[0] + 1;
            versionParts[1] = 0;
        } else {
            versionParts[1] = versionParts[1] + 1;
        }
        return versionParts[0] + "." + versionParts[1];
    }

    private String _getStorageType(DDMFormValues settingsDDMFormValues) {
        DDMFormInstanceSettings ddmFormInstanceSettings = (DDMFormInstanceSettings)DDMFormInstanceFactory.create(DDMFormInstanceSettings.class, (DDMFormValues)settingsDDMFormValues);
        String storageType = ddmFormInstanceSettings.storageType();
        if (Validator.isNotNull((String)storageType)) {
            return storageType;
        }
        return StorageType.DEFAULT.toString();
    }

    private long _getStructureVersionId(long ddmStructureId) throws PortalException {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(ddmStructureId);
        DDMStructureVersion ddmStructureVersion = ddmStructure.getStructureVersion();
        return ddmStructureVersion.getStructureVersionId();
    }

    private String _getWorkflowDefinition(DDMFormValues ddmFormValues) throws PortalException {
        DDMFormInstanceSettings ddmFormInstanceSettings = (DDMFormInstanceSettings)DDMFormInstanceFactory.create(DDMFormInstanceSettings.class, (DDMFormValues)ddmFormValues);
        return ddmFormInstanceSettings.workflowDefinition();
    }

    private String _serialize(DDMFormValues ddmFormValues) {
        DDMFormValuesSerializerSerializeRequest.Builder builder = DDMFormValuesSerializerSerializeRequest.Builder.newBuilder((DDMFormValues)ddmFormValues);
        DDMFormValuesSerializerSerializeResponse ddmFormValuesSerializerSerializeResponse = this._jsonDDMFormValuesSerializer.serialize(builder.build());
        return ddmFormValuesSerializerSerializeResponse.getContent();
    }

    private DDMFormInstance _updateFormInstance(long userId, long ddmStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMFormValues settingsDDMFormValues, ServiceContext serviceContext, DDMFormInstance ddmFormInstance) throws PortalException {
        Locale defaultLocale = this._getDDMFormDefaultLocale(ddmStructureId);
        User user = this._userLocalService.getUser(userId);
        this._validate(ddmStructureId, defaultLocale, nameMap, settingsDDMFormValues, user.getTimeZone());
        DDMFormInstanceVersion latestDDMFormInstanceVersion = this._ddmFormInstanceVersionLocalService.getLatestFormInstanceVersion(ddmFormInstance.getFormInstanceId());
        int status = GetterUtil.getInteger((Object)serviceContext.getAttribute("status"), (int)0);
        boolean updateVersion = false;
        if (latestDDMFormInstanceVersion.getStatus() == 2) {
            updateVersion = true;
        }
        boolean majorVersion = GetterUtil.getBoolean((Object)serviceContext.getAttribute("majorVersion"));
        String version = this._getNextVersion(latestDDMFormInstanceVersion.getVersion(), majorVersion);
        if (!updateVersion) {
            ddmFormInstance.setVersionUserId(user.getUserId());
            ddmFormInstance.setVersionUserName(user.getFullName());
            ddmFormInstance.setVersion(version);
        }
        ddmFormInstance.setNameMap(nameMap, defaultLocale);
        ddmFormInstance.setDescriptionMap(descriptionMap, defaultLocale);
        ddmFormInstance.setSettings(this._serialize(settingsDDMFormValues));
        DDMFormInstance updatedDDMFormInstance = (DDMFormInstance)this.ddmFormInstancePersistence.update((BaseModel)ddmFormInstance);
        if (status != 2) {
            this._updateWorkflowDefinitionLink(ddmFormInstance, settingsDDMFormValues, serviceContext);
        }
        long ddmStructureVersionId = this._getStructureVersionId(ddmStructureId);
        if (updateVersion) {
            this._updateFormInstanceVersion(ddmStructureVersionId, user, ddmFormInstance, status);
        } else {
            this._addFormInstanceVersion(ddmStructureVersionId, user, ddmFormInstance, version, serviceContext);
        }
        return updatedDDMFormInstance;
    }

    private void _updateFormInstanceVersion(long ddmStructureVersionId, User user, DDMFormInstance ddmFormInstance, int status) throws PortalException {
        DDMFormInstanceVersion ddmFormInstanceVersion = this._ddmFormInstanceVersionLocalService.getLatestFormInstanceVersion(ddmFormInstance.getFormInstanceId());
        ddmFormInstanceVersion.setUserId(ddmFormInstance.getUserId());
        ddmFormInstanceVersion.setUserName(ddmFormInstance.getUserName());
        ddmFormInstanceVersion.setStructureVersionId(ddmStructureVersionId);
        ddmFormInstanceVersion.setName(ddmFormInstance.getName());
        ddmFormInstanceVersion.setDescription(ddmFormInstance.getDescription());
        ddmFormInstanceVersion.setSettings(ddmFormInstance.getSettings());
        ddmFormInstanceVersion.setStatus(status);
        ddmFormInstanceVersion.setStatusByUserId(user.getUserId());
        ddmFormInstanceVersion.setStatusByUserName(user.getFullName());
        ddmFormInstanceVersion.setStatusDate(ddmFormInstance.getModifiedDate());
        this._ddmFormInstanceVersionPersistence.update((BaseModel)ddmFormInstanceVersion);
    }

    private void _updateWorkflowDefinitionLink(DDMFormInstance formInstance, DDMFormValues settingsDDMFormValues, ServiceContext serviceContext) throws PortalException {
        KaleoDefinition kaleoDefinition;
        String workflowDefinition = this._getWorkflowDefinition(settingsDDMFormValues);
        Object latestWorkflowDefinition = "";
        if (Validator.isNotNull((String)workflowDefinition) && !workflowDefinition.equals("no-workflow") && (kaleoDefinition = this._kaleoDefinitionLocalService.fetchKaleoDefinition(workflowDefinition, serviceContext)) != null) {
            latestWorkflowDefinition = workflowDefinition + "@" + kaleoDefinition.getVersion();
        }
        this._workflowDefinitionLinkLocalService.updateWorkflowDefinitionLink(serviceContext.getUserId(), serviceContext.getCompanyId(), formInstance.getGroupId(), DDMFormInstance.class.getName(), formInstance.getFormInstanceId(), 0L, (String)latestWorkflowDefinition);
    }

    private void _validate(long ddmStructureId, Locale defaultLocale, Map<Locale, String> nameMap, DDMFormValues settingsDDMFormValues, TimeZone timeZone) throws PortalException {
        this._validateStructureId(ddmStructureId);
        this._validateName(nameMap, defaultLocale);
        this._validateFormInstanceSettings(settingsDDMFormValues, timeZone.getID());
    }

    private void _validateFormInstanceSettings(DDMFormValues settingsDDMFormValues, String timeZoneId) throws PortalException {
        this._ddmFormValuesValidator.validate(settingsDDMFormValues, timeZoneId);
    }

    private void _validateName(Map<Locale, String> nameMap, Locale defaultLocale) throws PortalException {
        String name = nameMap.get(defaultLocale);
        if (Validator.isNull((String)name)) {
            throw new FormInstanceNameException("Name is null for locale " + defaultLocale.getDisplayName());
        }
    }

    private void _validateStructureId(long ddmStructureId) throws PortalException {
        DDMStructure ddmStructure = this._ddmStructureLocalService.fetchStructure(ddmStructureId);
        if (ddmStructure == null) {
            throw new FormInstanceStructureIdException("No DDM structure exists with the DDM structure ID " + ddmStructureId);
        }
    }
}

