/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.exportimport.staged.model.repository;

import com.liferay.dynamic.data.mapping.exception.NoSuchFormInstanceRecordVersionException;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordVersion;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordLocalService;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordVersionLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.service.ServiceContext;
import java.io.Serializable;
import java.util.Objects;

public class DDMFormInstanceRecordStagedModelRepositoryUtil {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormInstanceRecordStagedModelRepositoryUtil.class);
    private static final Snapshot<DDMFormInstanceRecordLocalService> _ddmFormInstanceRecordLocalServiceSnapshot = new Snapshot(DDMFormInstanceRecordStagedModelRepositoryUtil.class, DDMFormInstanceRecordLocalService.class);
    private static final Snapshot<DDMFormInstanceRecordVersionLocalService> _ddmFormInstanceRecordVersionLocalServiceSnapshot = new Snapshot(DDMFormInstanceRecordStagedModelRepositoryUtil.class, DDMFormInstanceRecordVersionLocalService.class);

    public static DDMFormInstanceRecord addStagedModel(PortletDataContext portletDataContext, DDMFormInstanceRecord ddmFormInstanceRecord, DDMFormValues ddmFormValues) throws PortalException {
        long userId = portletDataContext.getUserId(ddmFormInstanceRecord.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)ddmFormInstanceRecord);
        serviceContext.setAttribute("validateDDMFormValues", (Serializable)Boolean.FALSE);
        if (portletDataContext.isDataStrategyMirror()) {
            serviceContext.setUuid(ddmFormInstanceRecord.getUuid());
        }
        DDMFormInstanceRecordLocalService ddmFormInstanceRecordLocalService = (DDMFormInstanceRecordLocalService)_ddmFormInstanceRecordLocalServiceSnapshot.get();
        DDMFormInstanceRecord importedDDMFormInstanceRecord = ddmFormInstanceRecordLocalService.addFormInstanceRecord(userId, ddmFormInstanceRecord.getGroupId(), ddmFormInstanceRecord.getFormInstanceId(), ddmFormValues, serviceContext);
        DDMFormInstanceRecordStagedModelRepositoryUtil._updateVersions(importedDDMFormInstanceRecord, ddmFormInstanceRecord.getVersion());
        return importedDDMFormInstanceRecord;
    }

    public static DDMFormInstanceRecord updateStagedModel(PortletDataContext portletDataContext, DDMFormInstanceRecord ddmFormInstanceRecord, DDMFormValues ddmFormValues) throws PortalException {
        long userId = portletDataContext.getUserId(ddmFormInstanceRecord.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)ddmFormInstanceRecord);
        serviceContext.setAttribute("validateDDMFormValues", (Serializable)Boolean.FALSE);
        DDMFormInstanceRecordLocalService ddmFormInstanceRecordLocalService = (DDMFormInstanceRecordLocalService)_ddmFormInstanceRecordLocalServiceSnapshot.get();
        DDMFormInstanceRecord importedDDMFormInstanceRecord = ddmFormInstanceRecordLocalService.updateFormInstanceRecord(userId, ddmFormInstanceRecord.getFormInstanceRecordId(), false, ddmFormValues, serviceContext);
        DDMFormInstanceRecordStagedModelRepositoryUtil._updateVersions(importedDDMFormInstanceRecord, ddmFormInstanceRecord.getVersion());
        return importedDDMFormInstanceRecord;
    }

    private static void _updateVersions(DDMFormInstanceRecord importedDDMFormInstanceRecord, String version) throws PortalException {
        DDMFormInstanceRecordVersionLocalService ddmFormInstanceRecordVersionLocalService;
        block3: {
            if (Objects.equals(importedDDMFormInstanceRecord.getVersion(), version)) {
                return;
            }
            ddmFormInstanceRecordVersionLocalService = (DDMFormInstanceRecordVersionLocalService)_ddmFormInstanceRecordVersionLocalServiceSnapshot.get();
            try {
                DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion = ddmFormInstanceRecordVersionLocalService.getFormInstanceRecordVersion(importedDDMFormInstanceRecord.getFormInstanceRecordId(), version);
                ddmFormInstanceRecordVersionLocalService.deleteDDMFormInstanceRecordVersion(ddmFormInstanceRecordVersion);
            }
            catch (NoSuchFormInstanceRecordVersionException noSuchFormInstanceRecordVersionException) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Throwable)noSuchFormInstanceRecordVersionException);
            }
        }
        DDMFormInstanceRecordVersion importedDDMFormInstanceRecordVersion = importedDDMFormInstanceRecord.getFormInstanceRecordVersion();
        importedDDMFormInstanceRecordVersion.setVersion(version);
        ddmFormInstanceRecordVersionLocalService.updateDDMFormInstanceRecordVersion(importedDDMFormInstanceRecordVersion);
        importedDDMFormInstanceRecord.setVersion(version);
        DDMFormInstanceRecordLocalService ddmFormInstanceRecordLocalService = (DDMFormInstanceRecordLocalService)_ddmFormInstanceRecordLocalServiceSnapshot.get();
        ddmFormInstanceRecordLocalService.updateDDMFormInstanceRecord(importedDDMFormInstanceRecord);
    }
}

