/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.dynamic.data.mapping.model.impl;

import com.liferay.dynamic.data.mapping.model.DDMFormInstanceVersion;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceVersionLocalServiceUtil;

/**
 * The extended model base implementation for the DDMFormInstanceVersion service. Represents a row in the &quot;DDMFormInstanceVersion&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link DDMFormInstanceVersionImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DDMFormInstanceVersionImpl
 * @see DDMFormInstanceVersion
 * @generated
 */
public abstract class DDMFormInstanceVersionBaseImpl
	extends DDMFormInstanceVersionModelImpl implements DDMFormInstanceVersion {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a ddm form instance version model instance should use the <code>DDMFormInstanceVersion</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			DDMFormInstanceVersionLocalServiceUtil.addDDMFormInstanceVersion(
				this);
		}
		else {
			DDMFormInstanceVersionLocalServiceUtil.updateDDMFormInstanceVersion(
				this);
		}
	}

}