/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.util;

import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalServiceUtil;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.storage.constants.FieldConstants;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesToFieldsConverter;
import com.liferay.dynamic.data.mapping.util.FieldsToDDMFormValuesConverter;
import com.liferay.dynamic.data.mapping.util.comparator.StructureIdComparator;
import com.liferay.dynamic.data.mapping.util.comparator.StructureModifiedDateComparator;
import com.liferay.dynamic.data.mapping.util.comparator.TemplateIdComparator;
import com.liferay.dynamic.data.mapping.util.comparator.TemplateModifiedDateComparator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadRequest;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.UnicodeFormatter;
import com.liferay.portal.kernel.util.Validator;
import jakarta.portlet.PortletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DDM.class})
public class DDMImpl
implements DDM {
    private static final Log _log = LogFactoryUtil.getLog(DDMImpl.class);
    @Reference
    private DDMFormValuesToFieldsConverter _ddmFormValuesToFieldsConverter;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference
    private FieldsToDDMFormValuesConverter _fieldsToDDMFormValuesConverter;
    @Reference
    private ImageLocalService _imageLocalService;
    @Reference(target="(ddm.form.deserializer.type=json)")
    private DDMFormDeserializer _jsonDDMFormDeserializer;
    @Reference(target="(ddm.form.serializer.type=json)")
    private DDMFormSerializer _jsonDDMFormSerializer;
    @Reference(target="(ddm.form.values.deserializer.type=json)")
    private DDMFormValuesDeserializer _jsonDDMFormValuesDeserializer;
    @Reference(target="(ddm.form.values.serializer.type=json)")
    private DDMFormValuesSerializer _jsonDDMFormValuesSerializer;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;

    public DDMForm getDDMForm(long classNameId, long classPK) throws PortalException {
        if (classNameId <= 0L || classPK <= 0L) {
            return null;
        }
        long ddmStructureClassNameId = this._portal.getClassNameId(DDMStructure.class);
        long ddmTemplateClassNameId = this._portal.getClassNameId(DDMTemplate.class);
        if (classNameId == ddmStructureClassNameId) {
            DDMStructure structure = DDMStructureLocalServiceUtil.getStructure((long)classPK);
            return structure.getFullHierarchyDDMForm();
        }
        if (classNameId == ddmTemplateClassNameId) {
            DDMTemplate template = DDMTemplateLocalServiceUtil.getTemplate((long)classPK);
            return this.getDDMForm(template.getScript());
        }
        return null;
    }

    public DDMForm getDDMForm(PortletRequest portletRequest) throws PortalException {
        String definition = ParamUtil.getString((PortletRequest)portletRequest, (String)"definition");
        return this.getDDMForm(definition);
    }

    public DDMForm getDDMForm(String content) throws PortalException {
        DDMFormDeserializerDeserializeRequest.Builder builder = DDMFormDeserializerDeserializeRequest.Builder.newBuilder((String)content);
        DDMFormDeserializerDeserializeResponse ddmFormDeserializerDeserializeResponse = this._jsonDDMFormDeserializer.deserialize(builder.build());
        return ddmFormDeserializerDeserializeResponse.getDDMForm();
    }

    public JSONArray getDDMFormFieldsJSONArray(DDMStructure ddmStructure, String script) {
        DDMForm ddmForm = null;
        if (ddmStructure != null) {
            ddmForm = ddmStructure.getFullHierarchyDDMForm();
        }
        return this.getDDMFormFieldsJSONArray(ddmForm, script);
    }

    public JSONArray getDDMFormFieldsJSONArray(DDMStructureVersion ddmStructureVersion, String script) {
        DDMForm ddmForm = null;
        if (ddmStructureVersion != null) {
            ddmForm = ddmStructureVersion.getDDMForm();
        }
        return this.getDDMFormFieldsJSONArray(ddmForm, script);
    }

    public String getDDMFormJSONString(DDMForm ddmForm) {
        DDMFormSerializerSerializeRequest.Builder builder = DDMFormSerializerSerializeRequest.Builder.newBuilder((DDMForm)ddmForm);
        DDMFormSerializerSerializeResponse ddmFormSerializerSerializeResponse = this._jsonDDMFormSerializer.serialize(builder.build());
        return ddmFormSerializerSerializeResponse.getContent();
    }

    public DDMFormValues getDDMFormValues(DDMForm ddmForm, String serializedJSONDDMFormValues) {
        DDMFormValuesDeserializerDeserializeRequest.Builder builder = DDMFormValuesDeserializerDeserializeRequest.Builder.newBuilder((String)serializedJSONDDMFormValues, (DDMForm)ddmForm);
        DDMFormValuesDeserializerDeserializeResponse ddmFormValuesDeserializerDeserializeResponse = this._jsonDDMFormValuesDeserializer.deserialize(builder.build());
        return ddmFormValuesDeserializerDeserializeResponse.getDDMFormValues();
    }

    public DDMFormValues getDDMFormValues(long ddmStructureId, long ddmTemplateId, String fieldNamespace, ServiceContext serviceContext) throws PortalException {
        DDMStructure ddmStructure = this._getDDMStructure(ddmStructureId, ddmTemplateId);
        String serializedDDMFormValues = GetterUtil.getString((Object)serviceContext.getAttribute(fieldNamespace + "ddmFormValues"));
        if (Validator.isNotNull((String)serializedDDMFormValues)) {
            return this.getDDMFormValues(ddmStructure.getFullHierarchyDDMForm(), serializedDDMFormValues);
        }
        return this._fieldsToDDMFormValuesConverter.convert(ddmStructure, this.getFields(ddmStructureId, 0L, fieldNamespace, serviceContext));
    }

    public DDMFormValues getDDMFormValues(long ddmStructureId, String fieldNamespace, ServiceContext serviceContext) throws PortalException {
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)ddmStructureId);
        Fields fields = this.getFields(ddmStructure.getStructureId(), fieldNamespace, serviceContext);
        return this._fieldsToDDMFormValuesConverter.convert(ddmStructure, fields);
    }

    public String getDDMFormValuesJSONString(DDMFormValues ddmFormValues) {
        DDMFormValuesSerializerSerializeRequest.Builder builder = DDMFormValuesSerializerSerializeRequest.Builder.newBuilder((DDMFormValues)ddmFormValues);
        DDMFormValuesSerializerSerializeResponse ddmFormValuesSerializerSerializeResponse = this._jsonDDMFormValuesSerializer.serialize(builder.build());
        return ddmFormValuesSerializerSerializeResponse.getContent();
    }

    public DDMFormLayout getDefaultDDMFormLayout(DDMForm ddmForm) {
        DDMFormLayout ddmFormLayout = new DDMFormLayout();
        Locale defaultLocale = ddmForm.getDefaultLocale();
        ddmFormLayout.setDefaultLocale(defaultLocale);
        ddmFormLayout.setPaginationMode("single-page");
        DDMFormLayoutPage ddmFormLayoutPage = new DDMFormLayoutPage();
        ddmFormLayoutPage.setTitle(this._getDefaultDDMFormPageTitle(defaultLocale));
        for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
            ddmFormLayoutPage.addDDMFormLayoutRow(this._getDefaultDDMFormLayoutRow(ddmFormField));
        }
        ddmFormLayout.addDDMFormLayoutPage(ddmFormLayoutPage);
        return ddmFormLayout;
    }

    public Serializable getDisplayFieldValue(ThemeDisplay themeDisplay, Serializable fieldValue, String type) throws Exception {
        if (type.equals("ddm-date")) {
            fieldValue = DateUtil.formatDate((String)"yyyy-MM-dd", (String)fieldValue.toString(), (Locale)themeDisplay.getLocale());
        } else if (type.equals("checkbox")) {
            Boolean valueBoolean = (Boolean)fieldValue;
            fieldValue = valueBoolean.booleanValue() ? this._language.get(themeDisplay.getLocale(), "true") : this._language.get(themeDisplay.getLocale(), "false");
        } else if (type.equals("ddm-documentlibrary")) {
            if (Validator.isNull((Object)fieldValue)) {
                return "";
            }
            String valueString = String.valueOf(fieldValue);
            JSONObject jsonObject = this._jsonFactory.createJSONObject(valueString);
            String uuid = jsonObject.getString("uuid");
            long groupId = jsonObject.getLong("groupId");
            FileEntry fileEntry = this._dlAppLocalService.getFileEntryByUuidAndGroupId(uuid, groupId);
            fieldValue = this._dlURLHelper.getPreviewURL(fileEntry, fileEntry.getFileVersion(), null, "", false, true);
        } else if (type.equals("ddm-link-to-page")) {
            if (Validator.isNull((Object)fieldValue)) {
                return "";
            }
            String valueString = String.valueOf(fieldValue);
            JSONObject jsonObject = this._jsonFactory.createJSONObject(valueString);
            long groupId = jsonObject.getLong("groupId");
            boolean privateLayout = jsonObject.getBoolean("privateLayout");
            long layoutId = jsonObject.getLong("layoutId");
            fieldValue = this._portal.getLayoutFriendlyURL(this._layoutLocalService.getLayout(groupId, privateLayout, layoutId), themeDisplay);
        } else if (type.equals("select")) {
            String valueString = String.valueOf(fieldValue);
            JSONArray jsonArray = this._jsonFactory.createJSONArray(valueString);
            Object[] stringArray = ArrayUtil.toStringArray((JSONArray)jsonArray);
            fieldValue = StringUtil.merge((Object[])stringArray, (String)", ");
        }
        return fieldValue;
    }

    public Fields getFields(long ddmStructureId, DDMFormValues ddmFormValues) throws PortalException {
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)ddmStructureId);
        return this._ddmFormValuesToFieldsConverter.convert(ddmStructure, ddmFormValues);
    }

    public Fields getFields(long ddmStructureId, long ddmTemplateId, ServiceContext serviceContext) throws PortalException {
        return this.getFields(ddmStructureId, ddmTemplateId, "", serviceContext);
    }

    public Fields getFields(long ddmStructureId, long ddmTemplateId, String fieldNamespace, ServiceContext serviceContext) throws PortalException {
        Fields fields = new Fields();
        DDMStructure ddmStructure = this._getDDMStructure(ddmStructureId, ddmTemplateId);
        Set fieldNames = ddmStructure.getFieldNames();
        boolean translating = true;
        String defaultLanguageId = (String)((Object)serviceContext.getAttribute("defaultLanguageId"));
        String toLanguageId = (String)((Object)serviceContext.getAttribute("toLanguageId"));
        if (Validator.isNull((String)toLanguageId) || Objects.equals(defaultLanguageId, toLanguageId)) {
            translating = false;
        }
        for (String fieldName : fieldNames) {
            List<Serializable> fieldValues;
            boolean localizable = GetterUtil.getBoolean((String)ddmStructure.getFieldProperty(fieldName, "localizable"), (boolean)true);
            if (!localizable && translating && !fieldName.startsWith("_") || ListUtil.isEmpty(fieldValues = this._getFieldValues(ddmStructure, fieldName, fieldNamespace, serviceContext))) continue;
            Field field = this.createField(ddmStructure, fieldName, fieldValues, serviceContext);
            fields.put(field);
        }
        return fields;
    }

    public Fields getFields(long ddmStructureId, ServiceContext serviceContext) throws PortalException {
        String serializedDDMFormValues = GetterUtil.getString((Object)serviceContext.getAttribute("ddmFormValues"));
        if (Validator.isNotNull((String)serializedDDMFormValues)) {
            return this.getFields(ddmStructureId, serializedDDMFormValues);
        }
        return this.getFields(ddmStructureId, 0L, serviceContext);
    }

    public Fields getFields(long ddmStructureId, String fieldNamespace, ServiceContext serviceContext) throws PortalException {
        String serializedDDMFormValues = GetterUtil.getString((Object)serviceContext.getAttribute(fieldNamespace + "ddmFormValues"));
        if (Validator.isNotNull((String)serializedDDMFormValues)) {
            return this.getFields(ddmStructureId, serializedDDMFormValues);
        }
        return this.getFields(ddmStructureId, 0L, fieldNamespace, serviceContext);
    }

    public Serializable getIndexedFieldValue(Serializable fieldValue, String type) throws Exception {
        if (fieldValue instanceof Date) {
            Date valueDate = (Date)fieldValue;
            DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyyMMddHHmmss");
            fieldValue = dateFormat.format(valueDate);
        } else if (type.equals("select")) {
            String valueString = (String)fieldValue;
            JSONArray jsonArray = this._jsonFactory.createJSONArray(valueString);
            String[] stringArray = ArrayUtil.toStringArray((JSONArray)jsonArray);
            fieldValue = stringArray.length > 1 ? stringArray : stringArray[0];
        }
        return fieldValue;
    }

    public OrderByComparator<DDMStructure> getStructureOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        StructureIdComparator orderByComparator = null;
        if (orderByCol.equals("id")) {
            orderByComparator = StructureIdComparator.getInstance((boolean)orderByAsc);
        } else if (orderByCol.equals("modified-date")) {
            orderByComparator = new StructureModifiedDateComparator(orderByAsc);
        }
        return orderByComparator;
    }

    public OrderByComparator<DDMTemplate> getTemplateOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        TemplateIdComparator orderByComparator = null;
        if (orderByCol.equals("id")) {
            orderByComparator = TemplateIdComparator.getInstance((boolean)orderByAsc);
        } else if (orderByCol.equals("modified-date")) {
            orderByComparator = new TemplateModifiedDateComparator(orderByAsc);
        }
        return orderByComparator;
    }

    public Fields mergeFields(Fields newFields, Fields existingFields) {
        String[] newFieldsDisplayValues = this.splitFieldsDisplayValue(newFields.get("_fieldsDisplay"));
        String[] existingFieldsDisplayValues = this.splitFieldsDisplayValue(existingFields.get("_fieldsDisplay"));
        Iterator iterator = newFields.iterator(true);
        while (iterator.hasNext()) {
            Field newField = (Field)iterator.next();
            Field existingField = existingFields.get(newField.getName());
            if (existingField == null) {
                existingFields.put(newField);
                continue;
            }
            if (newField.isPrivate()) {
                String[] existingFieldValues = this.splitFieldsDisplayValue(existingField);
                String[] newFieldValues = this.splitFieldsDisplayValue(newField);
                if (newFieldValues.length <= existingFieldValues.length) continue;
                existingFields.put(newField);
                continue;
            }
            existingField.setDefaultLocale(newField.getDefaultLocale());
            Map<Locale, List<Serializable>> mergedFieldValuesMap = this._getMergedFieldValuesMap(newField, newFieldsDisplayValues, existingField, existingFieldsDisplayValues);
            existingField.setValuesMap(mergedFieldValuesMap);
        }
        return existingFields;
    }

    public DDMForm updateDDMFormDefaultLocale(DDMForm ddmForm, Locale newDefaultLocale) {
        DDMForm ddmFormCopy = new DDMForm(ddmForm);
        Locale defaultLocale = ddmForm.getDefaultLocale();
        if (defaultLocale.equals(newDefaultLocale)) {
            return ddmFormCopy;
        }
        ddmFormCopy.addAvailableLocale(newDefaultLocale);
        ddmFormCopy.setDefaultLocale(newDefaultLocale);
        this._updateDDMFormFieldsDefaultLocale(ddmFormCopy.getDDMFormFields(), newDefaultLocale);
        return ddmFormCopy;
    }

    protected Field createField(DDMStructure ddmStructure, String fieldName, List<Serializable> fieldValues, ServiceContext serviceContext) {
        Field field = new Field();
        field.setDDMStructureId(ddmStructure.getStructureId());
        String languageId = GetterUtil.getString((Object)serviceContext.getAttribute("languageId"), (String)serviceContext.getLanguageId());
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        String defaultLanguageId = GetterUtil.getString((Object)serviceContext.getAttribute("defaultLanguageId"));
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)defaultLanguageId);
        if (fieldName.startsWith("_")) {
            locale = LocaleUtil.getSiteDefault();
            defaultLocale = LocaleUtil.getSiteDefault();
        }
        field.setDefaultLocale(defaultLocale);
        field.setName(fieldName);
        field.setValues(locale, fieldValues);
        return field;
    }

    protected JSONArray getDDMFormFieldsJSONArray(DDMForm ddmForm, String script) {
        JSONArray ddmFormFieldsJSONArray;
        block5: {
            ddmFormFieldsJSONArray = null;
            if (ddmForm != null) {
                ddmFormFieldsJSONArray = this.getDDMFormFieldsJSONArray(ddmForm.getDDMFormFields(), ddmForm.getAvailableLocales(), ddmForm.getDefaultLocale());
            } else if (Validator.isNotNull((String)script)) {
                try {
                    DDMForm scriptDDMForm = this.getDDMForm(script);
                    ddmFormFieldsJSONArray = this.getDDMFormFieldsJSONArray(scriptDDMForm.getDDMFormFields(), scriptDDMForm.getAvailableLocales(), scriptDDMForm.getDefaultLocale());
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block5;
                    _log.warn((Throwable)portalException);
                }
            }
        }
        return ddmFormFieldsJSONArray;
    }

    protected JSONArray getDDMFormFieldsJSONArray(List<DDMFormField> ddmFormFields, Set<Locale> availableLocales, Locale defaultLocale) {
        JSONArray ddmFormFieldsJSONArray = this._jsonFactory.createJSONArray();
        for (DDMFormField ddmFormField : ddmFormFields) {
            JSONObject jsonObject = JSONUtil.put((String)"dataType", (Object)ddmFormField.getDataType()).put("id", ddmFormField.getName()).put("indexType", ddmFormField.getIndexType()).put("localizable", ddmFormField.isLocalizable()).put("multiple", ddmFormField.isMultiple()).put("name", ddmFormField.getName()).put("readOnly", ddmFormField.isReadOnly()).put("repeatable", ddmFormField.isRepeatable()).put("required", ddmFormField.isRequired()).put("showLabel", ddmFormField.isShowLabel()).put("type", ddmFormField.getType());
            this._addDDMFormFieldLocalizedProperties(jsonObject, ddmFormField, defaultLocale, defaultLocale);
            this._addDDMFormFieldOptions(jsonObject, ddmFormField, availableLocales, defaultLocale);
            JSONObject localizationMapJSONObject = this._jsonFactory.createJSONObject();
            for (Locale availableLocale : availableLocales) {
                JSONObject localeMapJSONObject = this._jsonFactory.createJSONObject();
                this._addDDMFormFieldLocalizedProperties(localeMapJSONObject, ddmFormField, availableLocale, defaultLocale);
                localizationMapJSONObject.put(LocaleUtil.toLanguageId((Locale)availableLocale), localeMapJSONObject);
            }
            jsonObject.put("fields", this.getDDMFormFieldsJSONArray(ddmFormField.getNestedDDMFormFields(), availableLocales, defaultLocale)).put("localizationMap", localizationMapJSONObject);
            if (Objects.equals(ddmFormField.getType(), "ddm-image")) {
                jsonObject.put("requiredDescription", ddmFormField.getProperty("requiredDescription"));
            }
            ddmFormFieldsJSONArray.put(jsonObject);
        }
        return ddmFormFieldsJSONArray;
    }

    protected Fields getFields(long ddmStructureId, String serializedDDMFormValues) throws PortalException {
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)ddmStructureId);
        DDMFormValues ddmFormValues = this.getDDMFormValues(ddmStructure.getFullHierarchyDDMForm(), serializedDDMFormValues);
        return this._ddmFormValuesToFieldsConverter.convert(ddmStructure, ddmFormValues);
    }

    protected String[] splitFieldsDisplayValue(Field fieldsDisplayField) {
        String value = (String)((Object)fieldsDisplayField.getValue());
        return StringUtil.split((String)value);
    }

    private void _addDDMFormFieldLocalizedProperties(JSONObject jsonObject, DDMFormField ddmFormField, Locale locale, Locale defaultLocale) {
        this._addDDMFormFieldLocalizedProperty(jsonObject, "label", ddmFormField.getLabel(), locale, defaultLocale, ddmFormField.getType());
        this._addDDMFormFieldLocalizedProperty(jsonObject, "predefinedValue", ddmFormField.getPredefinedValue(), locale, defaultLocale, ddmFormField.getType());
        this._addDDMFormFieldLocalizedProperty(jsonObject, "tip", ddmFormField.getTip(), locale, defaultLocale, ddmFormField.getType());
    }

    private void _addDDMFormFieldLocalizedProperty(JSONObject jsonObject, String propertyName, LocalizedValue localizedValue, Locale locale, Locale defaultLocale, String type) {
        String propertyValue = localizedValue.getString(locale);
        if (Validator.isNull((String)propertyValue)) {
            propertyValue = localizedValue.getString(defaultLocale);
        }
        if (type.equals("select") && propertyName.equals("predefinedValue")) {
            block4: {
                try {
                    jsonObject.put(propertyName, this._jsonFactory.createJSONArray(propertyValue));
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Throwable)exception);
                }
            }
            return;
        }
        jsonObject.put(propertyName, propertyValue);
    }

    private void _addDDMFormFieldOptions(JSONObject jsonObject, DDMFormField ddmFormField, Set<Locale> availableLocales, Locale defaultLocale) {
        String type = ddmFormField.getType();
        if (!type.equals("radio") && !type.equals("select")) {
            return;
        }
        String fieldName = ddmFormField.getName();
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
        for (String optionValue : ddmFormFieldOptions.getOptionsValues()) {
            String name = fieldName.concat(StringUtil.randomString());
            JSONObject optionJSONObject = JSONUtil.put((String)"id", (Object)name).put("name", name).put("type", "option").put("value", optionValue);
            this._addDDMFormFieldLocalizedProperty(optionJSONObject, "label", ddmFormFieldOptions.getOptionLabels(optionValue), defaultLocale, defaultLocale, "option");
            JSONObject localizationMapJSONObject = this._jsonFactory.createJSONObject();
            for (Locale availableLocale : availableLocales) {
                JSONObject localeMapJSONObject = this._jsonFactory.createJSONObject();
                this._addDDMFormFieldLocalizedProperty(localeMapJSONObject, "label", ddmFormFieldOptions.getOptionLabels(optionValue), availableLocale, defaultLocale, "option");
                localizationMapJSONObject.put(LocaleUtil.toLanguageId((Locale)availableLocale), localeMapJSONObject);
            }
            optionJSONObject.put("localizationMap", localizationMapJSONObject);
            jsonArray.put(optionJSONObject);
        }
        jsonObject.put("options", jsonArray);
    }

    private int _countFieldRepetition(String[] fieldsDisplayValues, String fieldName) {
        int count = 0;
        for (String fieldsDisplayValue : fieldsDisplayValues) {
            String prefix = StringUtil.extractFirst((String)fieldsDisplayValue, (String)"_INSTANCE_");
            if (!prefix.equals(fieldName)) continue;
            ++count;
        }
        return count;
    }

    private DDMStructure _getDDMStructure(long ddmStructureId, long ddmTemplateId) throws PortalException {
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)ddmStructureId);
        DDMTemplate ddmTemplate = DDMTemplateLocalServiceUtil.fetchDDMTemplate((long)ddmTemplateId);
        if (ddmTemplate != null) {
            ddmStructure = (DDMStructure)ddmStructure.clone();
            ddmStructure.setDefinition(ddmTemplate.getScript());
        }
        return ddmStructure;
    }

    private DDMFormLayoutRow _getDefaultDDMFormLayoutRow(DDMFormField ddmFormField) {
        DDMFormLayoutRow ddmFormLayoutRow = new DDMFormLayoutRow();
        ddmFormLayoutRow.addDDMFormLayoutColumn(new DDMFormLayoutColumn(12, new String[]{ddmFormField.getName()}));
        return ddmFormLayoutRow;
    }

    private LocalizedValue _getDefaultDDMFormPageTitle(Locale defaultLocale) {
        LocalizedValue title = new LocalizedValue(defaultLocale);
        title.addString(defaultLocale, "");
        return title;
    }

    private int _getExistingFieldValueIndex(String[] newFieldsDisplayValues, String[] existingFieldsDisplayValues, String fieldName, int index) {
        String instanceId = this._getFieldIntanceId(newFieldsDisplayValues, fieldName, index);
        return this._getFieldValueIndex(existingFieldsDisplayValues, fieldName, instanceId);
    }

    private String _getFieldIntanceId(String[] fieldsDisplayValues, String fieldName, int index) {
        String prefix = fieldName.concat("_INSTANCE_");
        for (String fieldsDisplayValue : fieldsDisplayValues) {
            if (!fieldsDisplayValue.startsWith(prefix) || --index >= 0) continue;
            return StringUtil.extractLast((String)fieldsDisplayValue, (String)"_INSTANCE_");
        }
        return null;
    }

    private List<String> _getFieldNames(String fieldNamespace, String fieldName, ServiceContext serviceContext) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        String[] fieldsDisplayValues = StringUtil.split((String)((String)((Object)serviceContext.getAttribute(fieldNamespace + "_fieldsDisplay"))));
        List privateFieldNames = ListUtil.fromArray((Object[])new String[]{"_fieldsDisplay"});
        if (fieldsDisplayValues.length == 0 || privateFieldNames.contains(fieldName)) {
            fieldNames.add(fieldNamespace + fieldName);
        } else {
            for (String namespacedFieldName : fieldsDisplayValues) {
                String fieldNameValue = StringUtil.extractFirst((String)namespacedFieldName, (String)"_INSTANCE_");
                if (!fieldNameValue.equals(fieldName)) continue;
                fieldNames.add(fieldNamespace + namespacedFieldName);
            }
        }
        return fieldNames;
    }

    private int _getFieldValueIndex(String[] fieldsDisplayValues, String fieldName, String instanceId) {
        if (Validator.isNull((String)instanceId)) {
            return -1;
        }
        int offset = 0;
        String prefix = fieldName.concat("_INSTANCE_");
        for (String fieldsDisplayValue : fieldsDisplayValues) {
            if (!fieldsDisplayValue.startsWith(prefix)) continue;
            String fieldIstanceId = StringUtil.extractLast((String)fieldsDisplayValue, (String)"_INSTANCE_");
            if (fieldIstanceId.equals(instanceId)) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    private List<Serializable> _getFieldValues(DDMStructure ddmStructure, String fieldName, String fieldNamespace, ServiceContext serviceContext) throws PortalException {
        DDMFormField ddmFormField = ddmStructure.getDDMFormField(fieldName);
        String fieldDataType = ddmFormField.getDataType();
        String fieldType = ddmFormField.getType();
        LocalizedValue predefinedValue = ddmFormField.getPredefinedValue();
        List<String> fieldNames = this._getFieldNames(fieldNamespace, fieldName, serviceContext);
        ArrayList<Serializable> fieldValues = new ArrayList<Serializable>(fieldNames.size());
        for (String fieldNameValue : fieldNames) {
            String predefinedValueString;
            String imageFieldValue;
            HttpServletRequest httpServletRequest;
            Object fieldValue = serviceContext.getAttribute(fieldNameValue);
            if (Validator.isNull((Object)fieldValue)) {
                fieldValue = predefinedValue.getString(serviceContext.getLocale());
            }
            if (fieldType.equals("checkbox") && Validator.isNull((Object)fieldValue)) {
                fieldValue = "false";
            } else if (fieldDataType.equals("date")) {
                Date fieldValueDate = null;
                if (Validator.isNull((Object)fieldValue)) {
                    int fieldValueMonth = GetterUtil.getInteger((Object)serviceContext.getAttribute(fieldNameValue + "Month"));
                    int fieldValueDay = GetterUtil.getInteger((Object)serviceContext.getAttribute(fieldNameValue + "Day"));
                    int fieldValueYear = GetterUtil.getInteger((Object)serviceContext.getAttribute(fieldNameValue + "Year"));
                    fieldValueDate = this._portal.getDate(fieldValueMonth, fieldValueDay, fieldValueYear, TimeZoneUtil.getTimeZone((String)"UTC"), null);
                } else {
                    try {
                        fieldValueDate = DateUtil.parseDate((String)String.valueOf(fieldValue), (Locale)serviceContext.getLocale());
                    }
                    catch (ParseException parseException) {
                        _log.error((Object)("Unable to parse date " + String.valueOf(fieldValue)), (Throwable)parseException);
                    }
                }
                if (fieldValueDate != null) {
                    fieldValue = String.valueOf(fieldValueDate.getTime());
                }
            } else if (fieldDataType.equals("image") && Validator.isNull((Object)fieldValue) && (httpServletRequest = serviceContext.getRequest()) instanceof UploadRequest && Validator.isNotNull((String)(imageFieldValue = this._getImageFieldValue((UploadRequest)httpServletRequest, fieldNameValue)))) {
                fieldValue = imageFieldValue;
            }
            if (Validator.isNull((Object)fieldValue)) {
                return null;
            }
            if ("select".equals(fieldType) && !fieldValue.equals(predefinedValueString = predefinedValue.getString(serviceContext.getLocale())) && fieldValue instanceof String) {
                fieldValue = new String[]{String.valueOf(fieldValue)};
                fieldValue = this._jsonFactory.serialize(fieldValue);
            }
            Serializable fieldValueSerializable = FieldConstants.getSerializable((String)fieldDataType, (String)GetterUtil.getString((Object)fieldValue));
            fieldValues.add(fieldValueSerializable);
        }
        return fieldValues;
    }

    private List<Serializable> _getFieldValues(Field field, Locale locale) {
        Map fieldValuesMap = field.getValuesMap();
        return (List)fieldValuesMap.get(locale);
    }

    private byte[] _getImageBytes(UploadRequest uploadRequest, String fieldNameValue) throws Exception {
        byte[] bytes = FileUtil.getBytes((File)uploadRequest.getFile(fieldNameValue + "File"));
        if (ArrayUtil.isNotEmpty((byte[])bytes)) {
            return bytes;
        }
        String url = uploadRequest.getParameter(fieldNameValue + "URL");
        long imageId = GetterUtil.getLong((String)HttpComponentsUtil.getParameter((String)url, (String)"img_id", (boolean)false));
        Image image = this._imageLocalService.fetchImage(imageId);
        if (image == null) {
            return null;
        }
        return image.getTextObj();
    }

    private String _getImageFieldValue(UploadRequest uploadRequest, String fieldNameValue) {
        block3: {
            try {
                byte[] bytes = this._getImageBytes(uploadRequest, fieldNameValue);
                if (ArrayUtil.isNotEmpty((byte[])bytes)) {
                    return JSONUtil.put((String)"alt", (Object)uploadRequest.getParameter(fieldNameValue + "Alt")).put("data", UnicodeFormatter.bytesToHex((byte[])bytes)).toString();
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Throwable)exception);
            }
        }
        return "";
    }

    private Set<Locale> _getMergedAvailableLocales(Set<Locale> newFieldAvailableLocales, Set<Locale> existingFieldAvailableLocales) {
        HashSet<Locale> mergedAvailableLocales = new HashSet<Locale>();
        mergedAvailableLocales.addAll(newFieldAvailableLocales);
        mergedAvailableLocales.addAll(existingFieldAvailableLocales);
        return mergedAvailableLocales;
    }

    private List<Serializable> _getMergedFieldValues(String fieldName, List<Serializable> newFieldValues, String[] newFieldsDisplayValues, List<Serializable> existingFieldValues, String[] existingFieldsDisplayValues, List<Serializable> defaultFieldValues) {
        if (existingFieldValues == null) {
            return newFieldValues;
        }
        ArrayList<Serializable> mergedLocaleValues = new ArrayList<Serializable>();
        int repetition = this._countFieldRepetition(newFieldsDisplayValues, fieldName);
        for (int i = 0; i < repetition; ++i) {
            int existingFieldValueIndex = this._getExistingFieldValueIndex(newFieldsDisplayValues, existingFieldsDisplayValues, fieldName, i);
            if (existingFieldValueIndex == -1) {
                mergedLocaleValues.add(i, defaultFieldValues.get(i));
                continue;
            }
            if (newFieldValues != null) {
                mergedLocaleValues.add(i, newFieldValues.get(i));
                continue;
            }
            Serializable existingValue = existingFieldValues.get(existingFieldValueIndex);
            mergedLocaleValues.add(i, existingValue);
        }
        return mergedLocaleValues;
    }

    private Map<Locale, List<Serializable>> _getMergedFieldValuesMap(Field newField, String[] newFieldsDisplayValues, Field existingField, String[] existingFieldsDisplayValues) {
        Set<Locale> availableLocales = this._getMergedAvailableLocales(newField.getAvailableLocales(), existingField.getAvailableLocales());
        for (Locale locale : availableLocales) {
            List<Serializable> newFieldValues = this._getFieldValues(newField, locale);
            List<Serializable> existingFieldValues = this._getFieldValues(existingField, locale);
            List<Serializable> defaultFieldValues = this._getFieldValues(newField, newField.getDefaultLocale());
            List<Serializable> mergedLocaleValues = this._getMergedFieldValues(newField.getName(), newFieldValues, newFieldsDisplayValues, existingFieldValues, existingFieldsDisplayValues, defaultFieldValues);
            existingField.setValues(locale, mergedLocaleValues);
        }
        return existingField.getValuesMap();
    }

    private void _updateDDMFormFieldDefaultLocale(DDMFormField ddmFormField, Locale newDefaultLocale) {
        this._updateDDMFormFieldOptionsDefaultLocale(ddmFormField.getDDMFormFieldOptions(), newDefaultLocale);
        this._updateLocalizedValueDefaultLocale(ddmFormField.getLabel(), newDefaultLocale);
        this._updateLocalizedValueDefaultLocale(ddmFormField.getPredefinedValue(), newDefaultLocale);
        this._updateLocalizedValueDefaultLocale(ddmFormField.getStyle(), newDefaultLocale);
        this._updateLocalizedValueDefaultLocale(ddmFormField.getTip(), newDefaultLocale);
    }

    private void _updateDDMFormFieldOptionsDefaultLocale(DDMFormFieldOptions ddmFormFieldOptions, Locale newDefaultLocale) {
        Map options = ddmFormFieldOptions.getOptions();
        for (LocalizedValue localizedValue : options.values()) {
            this._updateLocalizedValueDefaultLocale(localizedValue, newDefaultLocale);
        }
        ddmFormFieldOptions.setDefaultLocale(newDefaultLocale);
    }

    private void _updateDDMFormFieldsDefaultLocale(List<DDMFormField> ddmFormFields, Locale newDefaultLocale) {
        for (DDMFormField ddmFormField : ddmFormFields) {
            this._updateDDMFormFieldDefaultLocale(ddmFormField, newDefaultLocale);
            this._updateDDMFormFieldsDefaultLocale(ddmFormField.getNestedDDMFormFields(), newDefaultLocale);
        }
    }

    private void _updateLocalizedValueDefaultLocale(LocalizedValue localizedValue, Locale newDefaultLocale) {
        Set availableLocales = localizedValue.getAvailableLocales();
        if (!availableLocales.contains(newDefaultLocale)) {
            String defaultValueString = localizedValue.getString(localizedValue.getDefaultLocale());
            localizedValue.addString(newDefaultLocale, defaultValueString);
        }
        localizedValue.setDefaultLocale(newDefaultLocale);
    }
}

