/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.renderer.internal.servlet;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidationExpression;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class DDMFormTemplateContextProcessor {
    private final DDMForm _ddmForm = new DDMForm();
    private long _ddmFormInstanceId;
    private final DDMFormLayout _ddmFormLayout = new DDMFormLayout();
    private final DDMFormValues _ddmFormValues;
    private long _groupId;
    private final JSONObject _jsonObject;
    private final Locale _locale;

    public DDMFormTemplateContextProcessor(JSONObject jsonObject, String languageId) {
        this._jsonObject = jsonObject;
        this._ddmFormValues = new DDMFormValues(this._ddmForm);
        this._locale = LocaleUtil.fromLanguageId((String)languageId);
        this._initModels();
        this.process();
    }

    public DDMForm getDDMForm() {
        return this._ddmForm;
    }

    public long getDDMFormInstanceId() {
        return this._ddmFormInstanceId;
    }

    public DDMFormLayout getDDMFormLayout() {
        return this._ddmFormLayout;
    }

    public DDMFormValues getDDMFormValues() {
        return this._ddmFormValues;
    }

    public long getGroupId() {
        return this._groupId;
    }

    protected DDMFormField getDDMFormField(JSONObject jsonObject) {
        String name = jsonObject.getString("fieldName");
        String type = jsonObject.getString("type");
        DDMFormField ddmFormField = new DDMFormField(name, type);
        this._setDDMFormFieldConfirmationErrorMessage(jsonObject.getString("confirmationErrorMessage"), ddmFormField);
        this._setDDMFormFieldConfirmationLabel(jsonObject.getString("confirmationLabel"), ddmFormField);
        this._setDDMFormFieldCustomProperties(jsonObject, ddmFormField);
        this._setDDMFormFieldDataType(jsonObject.getString("dataType"), ddmFormField);
        this._setDDMFormFieldFieldName(jsonObject.getString("fieldName"), ddmFormField);
        this._setDDMFormFieldFieldReference(jsonObject.getString("fieldReference"), ddmFormField);
        this._setDDMFormFieldInputMaskFormat(jsonObject.getString("inputMaskFormat"), ddmFormField);
        this._setDDMFormFieldLabel(jsonObject.getString("label"), ddmFormField);
        this._setDDMFormFieldLayout(ddmFormField, jsonObject.getString("layout"));
        this._setDDMFormFieldLocalizable(jsonObject.getBoolean("localizable", false), ddmFormField);
        this._setDDMFormFieldMultiple(jsonObject.getBoolean("multiple"), ddmFormField);
        this._setDDMFormFieldNumericInputMask(jsonObject.getString("numericInputMask"), ddmFormField);
        this._setDDMFormFieldOptions(jsonObject.getString("optionsDefaultLanguageId"), jsonObject.getJSONArray("options"), ddmFormField);
        this._setDDMFormFieldPlaceholder(jsonObject.getString("placeholder"), ddmFormField);
        this._setDDMFormFieldPredefinedValue(jsonObject.getString("predefinedValue"), ddmFormField);
        this._setDDMFormFieldProperty(ddmFormField, "buttonLabel", jsonObject.getString("buttonLabel"));
        this._setDDMFormFieldProperty(ddmFormField, "title", jsonObject.getString("title"));
        this._setDDMFormFieldPropertyDDMStructureId(jsonObject, ddmFormField);
        this._setDDMFormFieldPropertyDDMStructureLayoutId(jsonObject, ddmFormField);
        this._setDDMFormFieldPropertyMessage(ddmFormField, jsonObject.getString("message"));
        this._setDDMFormFieldPropertyOptions(jsonObject, ddmFormField, "columns");
        this._setDDMFormFieldPropertyRows(jsonObject, ddmFormField);
        this._setDDMFormFieldPropertyUpgradedStructure(jsonObject, ddmFormField);
        this._setDDMFormFieldReadOnly(jsonObject.getBoolean("readOnly", false), ddmFormField);
        this._setDDMFormFieldRepeatable(jsonObject.getBoolean("repeatable", false), ddmFormField);
        this._setDDMFormFieldRequired(jsonObject.getBoolean("required", false), ddmFormField);
        this._setDDMFormFieldRequiredErrorMessage(this._getLocalizedValue(jsonObject.getString("requiredErrorMessage")), ddmFormField);
        this._setDDMFormFieldText(jsonObject.getString("text"), ddmFormField);
        this._setDDMFormFieldTooltip(jsonObject.getString("tooltip"), ddmFormField);
        this._setDDMFormFieldValid(jsonObject.getBoolean("valid", true), ddmFormField);
        this._setDDMFormFieldValidation(jsonObject.getJSONObject("validation"), ddmFormField);
        this._setDDMFormFieldVisibilityExpression(jsonObject.getString("visibilityExpression"), ddmFormField);
        this._setDDMFormFieldVisibleFields(ddmFormField, jsonObject.getString("visibleFields"));
        this._setDDMFormFieldNestedFields(jsonObject.getJSONArray("nestedFields"), ddmFormField);
        return ddmFormField;
    }

    protected DDMFormFieldOptions getDDMFormFieldOptions(String optionsDefaultLanguageId, JSONArray jsonArray) {
        DDMFormFieldOptions ddmFormFieldOptions = new DDMFormFieldOptions(LocaleUtil.fromLanguageId((String)optionsDefaultLanguageId));
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String value = jsonObject.getString("value");
            JSONObject labelMapJSONObject = jsonObject.getJSONObject("labelMap");
            if (labelMapJSONObject != null) {
                Map labelMap = JSONUtil.toStringMap((JSONObject)labelMapJSONObject);
                for (Map.Entry entry : labelMap.entrySet()) {
                    ddmFormFieldOptions.addOptionLabel(value, LocaleUtil.fromLanguageId((String)((String)entry.getKey())), (String)entry.getValue());
                }
            } else {
                ddmFormFieldOptions.addOptionLabel(value, this._locale, jsonObject.getString("label"));
            }
            ddmFormFieldOptions.addOptionReference(value, jsonObject.getString("reference"));
        }
        return ddmFormFieldOptions;
    }

    protected DDMFormFieldValue getDDMFormFieldValue(JSONObject jsonObject) {
        DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue(jsonObject.getString("instanceId"));
        ddmFormFieldValue.setConfirmationValue(jsonObject.get("confirmationValue"));
        ddmFormFieldValue.setFieldReference(jsonObject.getString("fieldReference"));
        ddmFormFieldValue.setName(jsonObject.getString("fieldName"));
        this._setDDMFormFieldValueValue(jsonObject.getString("value"), jsonObject.getBoolean("localizable", false), ddmFormFieldValue);
        this._setDDMFormFieldValueNestedFieldValues(jsonObject.getJSONArray("nestedFields"), ddmFormFieldValue);
        return ddmFormFieldValue;
    }

    protected void process() {
        this._ddmFormLayout.setNextPage(Integer.valueOf(this._jsonObject.getInt("nextPage")));
        this._ddmFormLayout.setPreviousPage(Integer.valueOf(this._jsonObject.getInt("previousPage")));
        this._traversePages(this._jsonObject.getJSONArray("pages"));
    }

    protected void setDDMFormInstanceId() {
        this._ddmFormInstanceId = this._jsonObject.getLong("formId", 0L);
    }

    protected void setGroupId() {
        this._groupId = this._jsonObject.getLong("groupId", 0L);
    }

    private void _addDDMFormDDMFormField(JSONObject jsonObject) {
        String fieldName;
        Map ddmFormFields = this._ddmForm.getDDMFormFieldsMap(true);
        if (ddmFormFields.containsKey(fieldName = jsonObject.getString("fieldName"))) {
            return;
        }
        this._ddmForm.addDDMFormField(this.getDDMFormField(jsonObject));
    }

    private void _addDDMFormValuesDDMFormFieldValue(JSONObject jsonObject) {
        this._ddmFormValues.addDDMFormFieldValue(this.getDDMFormFieldValue(jsonObject));
    }

    private DDMFormRule _getDDMFormRule(JSONObject jsonObject) {
        List<String> actions = this._getDDMFormRuleActions(jsonObject.getJSONArray("actions"));
        return new DDMFormRule(actions, jsonObject.getString("condition"));
    }

    private List<String> _getDDMFormRuleActions(JSONArray jsonArray) {
        ArrayList<String> actions = new ArrayList<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            actions.add(jsonArray.getString(i));
        }
        return actions;
    }

    private List<DDMFormRule> _getDDMFormRules(JSONArray jsonArray) {
        ArrayList<DDMFormRule> ddmFormRules = new ArrayList<DDMFormRule>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            ddmFormRules.add(this._getDDMFormRule(jsonArray.getJSONObject(i)));
        }
        return ddmFormRules;
    }

    private LocalizedValue _getLocalizedValue(String value) {
        LocalizedValue localizedValue = new LocalizedValue(this._locale);
        localizedValue.addString(this._locale, value);
        return localizedValue;
    }

    private void _initModels() {
        this._setDDMFormDefaultLocale();
        this.setDDMFormInstanceId();
        this._setDDMFormRules();
        this._setDDMFormValuesAvailableLocales();
        this._setDDMFormValuesDefaultLocale();
        this.setGroupId();
        this._setObjectFieldsJSONArray();
    }

    private void _setDDMFormDefaultLocale() {
        this._ddmForm.setDefaultLocale(this._locale);
    }

    private void _setDDMFormFieldConfirmationErrorMessage(String confirmationErrorMessage, DDMFormField ddmFormField) {
        ddmFormField.setProperty("confirmationErrorMessage", (Object)this._getLocalizedValue(GetterUtil.getString((String)confirmationErrorMessage)));
    }

    private void _setDDMFormFieldConfirmationLabel(String confirmationLabel, DDMFormField ddmFormField) {
        ddmFormField.setProperty("confirmationLabel", (Object)this._getLocalizedValue(GetterUtil.getString((String)confirmationLabel)));
    }

    private void _setDDMFormFieldCustomProperties(JSONObject jsonObject, DDMFormField ddmFormField) {
        Iterator iterator = jsonObject.keys();
        Map properties = ddmFormField.getProperties();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (properties.containsKey(key) || key.equals("dataSourceType")) continue;
            ddmFormField.setProperty(key, jsonObject.get(key));
        }
    }

    private void _setDDMFormFieldDataType(String dataType, DDMFormField ddmFormField) {
        ddmFormField.setDataType(GetterUtil.getString((String)dataType));
    }

    private void _setDDMFormFieldFieldName(String fieldName, DDMFormField ddmFormField) {
        ddmFormField.setName(GetterUtil.getString((String)fieldName));
    }

    private void _setDDMFormFieldFieldReference(String fieldReference, DDMFormField ddmFormField) {
        ddmFormField.setFieldReference(GetterUtil.getString((String)fieldReference));
    }

    private void _setDDMFormFieldInputMaskFormat(String inputMaskFormat, DDMFormField ddmFormField) {
        ddmFormField.setProperty("inputMaskFormat", (Object)this._getLocalizedValue(GetterUtil.getString((String)inputMaskFormat)));
    }

    private void _setDDMFormFieldLabel(String label, DDMFormField ddmFormField) {
        ddmFormField.setLabel(this._getLocalizedValue(GetterUtil.getString((String)label)));
    }

    private void _setDDMFormFieldLayout(DDMFormField ddmFormField, String layout) {
        ddmFormField.setProperty("layout", (Object)this._getLocalizedValue(GetterUtil.getString((String)layout)));
    }

    private void _setDDMFormFieldLocalizable(boolean localizable, DDMFormField ddmFormField) {
        ddmFormField.setLocalizable(localizable);
    }

    private void _setDDMFormFieldMultiple(boolean multiple, DDMFormField ddmFormField) {
        ddmFormField.setMultiple(multiple);
    }

    private void _setDDMFormFieldNestedFields(JSONArray jsonArray, DDMFormField ddmFormField) {
        if (jsonArray == null) {
            return;
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            DDMFormField nestedDDMFormField = this.getDDMFormField(jsonArray.getJSONObject(i));
            ddmFormField.addNestedDDMFormField(nestedDDMFormField);
        }
    }

    private void _setDDMFormFieldNumericInputMask(String numericInputMask, DDMFormField ddmFormField) {
        ddmFormField.setProperty("numericInputMask", (Object)this._getLocalizedValue(GetterUtil.getString((String)numericInputMask)));
    }

    private void _setDDMFormFieldOptions(String optionsDefaultLanguageId, JSONArray jsonArray, DDMFormField ddmFormField) {
        if (jsonArray == null) {
            return;
        }
        ddmFormField.setDDMFormFieldOptions(this.getDDMFormFieldOptions(optionsDefaultLanguageId, jsonArray));
    }

    private void _setDDMFormFieldPlaceholder(String placeholder, DDMFormField ddmFormField) {
        ddmFormField.setProperty("placeholder", (Object)this._getLocalizedValue(GetterUtil.getString((String)placeholder)));
    }

    private void _setDDMFormFieldPredefinedValue(String predefinedValue, DDMFormField ddmFormField) {
        ddmFormField.setProperty("predefinedValue", (Object)this._getLocalizedValue(GetterUtil.getString((String)predefinedValue)));
    }

    private void _setDDMFormFieldProperty(DDMFormField ddmFormField, String propertyName, String propertyValue) {
        if (!Objects.equals(ddmFormField.getType(), "redirect_button")) {
            return;
        }
        ddmFormField.setProperty(propertyName, (Object)new Object[]{this._getLocalizedValue(propertyValue)});
    }

    private void _setDDMFormFieldPropertyDDMStructureId(JSONObject jsonObject, DDMFormField ddmFormField) {
        if (!Objects.equals(ddmFormField.getType(), "fieldset")) {
            return;
        }
        ddmFormField.setProperty("ddmStructureId", (Object)jsonObject.getLong("ddmStructureId"));
    }

    private void _setDDMFormFieldPropertyDDMStructureLayoutId(JSONObject jsonObject, DDMFormField ddmFormField) {
        if (!Objects.equals(ddmFormField.getType(), "fieldset")) {
            return;
        }
        ddmFormField.setProperty("ddmStructureLayoutId", (Object)jsonObject.getLong("ddmStructureLayoutId"));
    }

    private void _setDDMFormFieldPropertyFieldSetRows(JSONObject jsonObject, DDMFormField ddmFormField) {
        JSONArray jsonArray = jsonObject.getJSONArray("rows");
        if (jsonArray == null) {
            return;
        }
        ddmFormField.setProperty("rows", (Object)jsonArray.toString());
    }

    private void _setDDMFormFieldPropertyMessage(DDMFormField ddmFormField, String message) {
        if (!Objects.equals(ddmFormField.getType(), "redirect_button")) {
            return;
        }
        ddmFormField.setProperty("message", (Object)message);
    }

    private void _setDDMFormFieldPropertyOptions(JSONObject jsonObject, DDMFormField ddmFormField, String property) {
        JSONArray jsonArray = jsonObject.getJSONArray(property);
        if (jsonArray == null) {
            return;
        }
        ddmFormField.setProperty(property, (Object)this.getDDMFormFieldOptions(null, jsonArray));
    }

    private void _setDDMFormFieldPropertyRows(JSONObject jsonObject, DDMFormField ddmFormField) {
        String type = jsonObject.getString("type");
        if (type.equals("grid")) {
            this._setDDMFormFieldPropertyOptions(jsonObject, ddmFormField, "rows");
        } else if (type.equals("fieldset")) {
            this._setDDMFormFieldPropertyFieldSetRows(jsonObject, ddmFormField);
        }
    }

    private void _setDDMFormFieldPropertyUpgradedStructure(JSONObject jsonObject, DDMFormField ddmFormField) {
        if (!Objects.equals(ddmFormField.getType(), "fieldset")) {
            return;
        }
        ddmFormField.setProperty("upgradedStructure", (Object)jsonObject.getBoolean("upgradedStructure"));
    }

    private void _setDDMFormFieldReadOnly(boolean readOnly, DDMFormField ddmFormField) {
        ddmFormField.setReadOnly(readOnly);
    }

    private void _setDDMFormFieldRepeatable(boolean repeatable, DDMFormField ddmFormField) {
        ddmFormField.setRepeatable(repeatable);
    }

    private void _setDDMFormFieldRequired(boolean required, DDMFormField ddmFormField) {
        ddmFormField.setRequired(required);
    }

    private void _setDDMFormFieldRequiredErrorMessage(LocalizedValue requiredErrorMessage, DDMFormField ddmFormField) {
        ddmFormField.setRequiredErrorMessage(requiredErrorMessage);
    }

    private void _setDDMFormFieldText(String text, DDMFormField ddmFormField) {
        ddmFormField.setProperty("text", (Object)this._getLocalizedValue(GetterUtil.getString((String)text)));
    }

    private void _setDDMFormFieldTooltip(String tooltip, DDMFormField ddmFormField) {
        ddmFormField.setProperty("tooltip", (Object)this._getLocalizedValue(GetterUtil.getString((String)tooltip)));
    }

    private void _setDDMFormFieldValid(boolean valid, DDMFormField ddmFormField) {
        ddmFormField.setProperty("valid", (Object)valid);
    }

    private void _setDDMFormFieldValidation(final JSONObject jsonObject, DDMFormField ddmFormField) {
        if (jsonObject == null || !jsonObject.has("expression")) {
            return;
        }
        DDMFormFieldValidation ddmFormFieldValidation = new DDMFormFieldValidation();
        ddmFormFieldValidation.setErrorMessageLocalizedValue(this._getLocalizedValue(jsonObject.getString("errorMessage")));
        final JSONObject expressionJSONObject = jsonObject.getJSONObject("expression");
        if (expressionJSONObject != null) {
            ddmFormFieldValidation.setDDMFormFieldValidationExpression(new DDMFormFieldValidationExpression(){
                {
                    this.setName(expressionJSONObject.getString("name"));
                    this.setValue(expressionJSONObject.getString("value"));
                }
            });
        } else {
            ddmFormFieldValidation.setDDMFormFieldValidationExpression(new DDMFormFieldValidationExpression(){
                {
                    this.setValue(jsonObject.getString("expression"));
                }
            });
        }
        ddmFormFieldValidation.setParameterLocalizedValue(this._getLocalizedValue(jsonObject.getString("parameter")));
        ddmFormField.setDDMFormFieldValidation(ddmFormFieldValidation);
    }

    private void _setDDMFormFieldValueNestedFieldValues(JSONArray jsonArray, DDMFormFieldValue ddmFormFieldValue) {
        if (jsonArray == null) {
            return;
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            DDMFormFieldValue nestedDDMFormFieldValue = this.getDDMFormFieldValue(jsonArray.getJSONObject(i));
            ddmFormFieldValue.addNestedDDMFormFieldValue(nestedDDMFormFieldValue);
        }
    }

    private void _setDDMFormFieldValueValue(String value, boolean localizable, DDMFormFieldValue ddmFormFieldValue) {
        if (localizable) {
            ddmFormFieldValue.setValue((Value)this._getLocalizedValue(value));
        } else {
            ddmFormFieldValue.setValue((Value)new UnlocalizedValue(value));
        }
    }

    private void _setDDMFormFieldVisibilityExpression(String visibilityExpression, DDMFormField ddmFormField) {
        ddmFormField.setVisibilityExpression(GetterUtil.getString((String)visibilityExpression));
    }

    private void _setDDMFormFieldVisibleFields(DDMFormField ddmFormField, String visibleFields) {
        ddmFormField.setProperty("visibleFields", (Object)this._getLocalizedValue(GetterUtil.getString((String)visibleFields)));
    }

    private void _setDDMFormRules() {
        this._ddmForm.setDDMFormRules(this._getDDMFormRules(this._jsonObject.getJSONArray("rules")));
    }

    private void _setDDMFormValuesAvailableLocales() {
        this._ddmFormValues.addAvailableLocale(this._locale);
    }

    private void _setDDMFormValuesDefaultLocale() {
        this._ddmFormValues.setDefaultLocale(this._locale);
    }

    private void _setObjectFieldsJSONArray() {
        this._ddmForm.setObjectFieldsJSONArray(this._jsonObject.getJSONArray("objectFields"));
    }

    private void _traverseColumns(JSONArray jsonArray, DDMFormLayoutRow ddmFormLayoutRow) {
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            DDMFormLayoutColumn ddmFormLayoutColumn = new DDMFormLayoutColumn(jsonObject.getInt("size"), new String[0]);
            this._traverseFields(jsonObject.getJSONArray("fields"), ddmFormLayoutColumn);
            ddmFormLayoutRow.addDDMFormLayoutColumn(ddmFormLayoutColumn);
        }
    }

    private void _traverseFields(JSONArray jsonArray, DDMFormLayoutColumn ddmFormLayoutColumn) {
        LinkedHashSet<String> ddmFormFieldNames = new LinkedHashSet<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            this._addDDMFormDDMFormField(jsonObject);
            this._addDDMFormValuesDDMFormFieldValue(jsonObject);
            ddmFormFieldNames.add(jsonObject.getString("fieldName"));
        }
        ddmFormLayoutColumn.setDDMFormFieldNames(ListUtil.fromCollection(ddmFormFieldNames));
    }

    private void _traversePages(JSONArray jsonArray) {
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            DDMFormLayoutPage ddmFormLayoutPage = new DDMFormLayoutPage();
            ddmFormLayoutPage.setDescription(this._getLocalizedValue(jsonObject.getString("description")));
            ddmFormLayoutPage.setTitle(this._getLocalizedValue(jsonObject.getString("title")));
            this._traverseRows(jsonObject.getJSONArray("rows"), ddmFormLayoutPage);
            this._ddmFormLayout.addDDMFormLayoutPage(ddmFormLayoutPage);
        }
    }

    private void _traverseRows(JSONArray jsonArray, DDMFormLayoutPage ddmFormLayoutPage) {
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            DDMFormLayoutRow ddmFormLayoutRow = new DDMFormLayoutRow();
            this._traverseColumns(jsonObject.getJSONArray("columns"), ddmFormLayoutRow);
            ddmFormLayoutPage.addDDMFormLayoutRow(ddmFormLayoutRow);
        }
    }
}

