/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.renderer.internal;

import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluator;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesRegistry;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormTemplateContextFactory;
import com.liferay.dynamic.data.mapping.form.renderer.internal.DDMFormPagesTemplateContextFactory;
import com.liferay.dynamic.data.mapping.form.renderer.internal.helper.DDMFormTemplateContextFactoryHelper;
import com.liferay.dynamic.data.mapping.form.validation.DDMValidation;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.service.DDMStructureLayoutLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.dynamic.data.mapping.util.SettingsDDMFormFieldsUtil;
import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceComparator;
import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.AggregateResourceBundle;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HtmlParser;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={DDMFormTemplateContextFactory.class})
public class DDMFormTemplateContextFactoryImpl
implements DDMFormTemplateContextFactory {
    @Reference
    private DDM _ddm;
    @Reference(target="(osgi.http.whiteboard.servlet.name=com.liferay.dynamic.data.mapping.form.renderer.internal.servlet.DDMFormContextProviderServlet)")
    private Servlet _ddmFormContextProviderServlet;
    @Reference
    private DDMFormEvaluator _ddmFormEvaluator;
    @Reference
    private DDMFormFieldTypeServicesRegistry _ddmFormFieldTypeServicesRegistry;
    private final DDMFormTemplateContextFactoryHelper _ddmFormTemplateContextFactoryHelper = new DDMFormTemplateContextFactoryHelper();
    @Reference
    private DDMStructureLayoutLocalService _ddmStructureLayoutLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private HtmlParser _htmlParser;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;
    private ServiceTrackerMap<String, List<DDMValidation>> _serviceTrackerMap;

    public Map<String, Object> create(DDMForm ddmForm, DDMFormLayout ddmFormLayout, DDMFormRenderingContext ddmFormRenderingContext) throws PortalException {
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        for (DDMFormField ddmFormLayoutDDMFormField : ddmFormLayout.getDDMFormFields()) {
            DDMFormField ddmFormField = (DDMFormField)ddmFormFieldsMap.get(ddmFormLayoutDDMFormField.getName());
            if (!ddmFormField.isRequired()) {
                ddmFormField.setRequired(ddmFormLayoutDDMFormField.isRequired());
            }
            Map settingsDDMFormFieldsMap = SettingsDDMFormFieldsUtil.getSettingsDDMFormFields((DDMFormFieldTypeServicesRegistry)this._ddmFormFieldTypeServicesRegistry, (String)ddmFormLayoutDDMFormField.getType());
            for (DDMFormField visualPropertyDDMFormField : ListUtil.filter(new ArrayList(settingsDDMFormFieldsMap.values()), visualPropertyDDMFormField1 -> visualPropertyDDMFormField1.isVisualProperty() && !StringUtil.equals((String)visualPropertyDDMFormField1.getName(), (String)"required"))) {
                LocalizedValue localizedValue;
                Object value = ddmFormLayoutDDMFormField.getProperty(visualPropertyDDMFormField.getName());
                if (value == null || Objects.equals(visualPropertyDDMFormField.getName(), "label") && GetterUtil.getBoolean((Object)ddmFormField.getProperty("labelAtStructureLevel")) || visualPropertyDDMFormField.isLocalizable() && MapUtil.isEmpty((Map)(localizedValue = (LocalizedValue)value).getValues())) continue;
                ddmFormField.setProperty(visualPropertyDDMFormField.getName(), value);
            }
        }
        return this._create(ddmForm, ddmFormLayout, ddmFormRenderingContext);
    }

    public Map<String, Object> create(DDMForm ddmForm, DDMFormRenderingContext ddmFormRenderingContext) throws PortalException {
        return this._create(ddmForm, this._ddm.getDefaultDDMFormLayout(ddmForm), ddmFormRenderingContext);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, DDMValidation.class, null, (ServiceReferenceMapper)new PropertyServiceReferenceMapper("ddm.validation.data.type"), Collections.reverseOrder(new PropertyServiceReferenceComparator("ddm.validation.ranking")));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    protected ResourceBundle getResourceBundle(Locale locale) {
        ArrayList<ResourceBundle> resourceBundles = new ArrayList<ResourceBundle>();
        resourceBundles.add(this._portal.getResourceBundle(locale));
        this._collectResourceBundles(this.getClass(), resourceBundles, locale);
        return new AggregateResourceBundle(resourceBundles.toArray(new ResourceBundle[0]));
    }

    protected String getTemplateNamespace(DDMFormLayout ddmFormLayout) {
        String paginationMode = ddmFormLayout.getPaginationMode();
        if (Objects.equals(paginationMode, "settings")) {
            return "ddm.settings_form";
        }
        if (Objects.equals(paginationMode, "single-page")) {
            return "ddm.simple_form";
        }
        if (Objects.equals(paginationMode, "tabbed")) {
            return "ddm.tabbed_form";
        }
        if (Objects.equals(paginationMode, "wizard")) {
            return "ddm.wizard_form";
        }
        return "ddm.paginated_form";
    }

    private void _collectResourceBundles(Class<?> clazz, List<ResourceBundle> resourceBundles, Locale locale) {
        for (Class<?> interfaceClass : clazz.getInterfaces()) {
            this._collectResourceBundles(interfaceClass, resourceBundles, locale);
        }
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, (ClassLoader)clazz.getClassLoader());
        if (resourceBundle != null) {
            resourceBundles.add(resourceBundle);
        }
    }

    private Map<String, Object> _create(DDMForm ddmForm, DDMFormLayout ddmFormLayout, DDMFormRenderingContext ddmFormRenderingContext) throws PortalException {
        HashMap<String, Object> templateContext = new HashMap<String, Object>();
        String containerId = ddmFormRenderingContext.getContainerId();
        if (Validator.isNull((String)containerId)) {
            containerId = StringUtil.randomId();
        }
        templateContext.put("activePage", ParamUtil.getInteger((HttpServletRequest)ddmFormRenderingContext.getHttpServletRequest(), (String)"activePage"));
        this._setDDMFormFieldsEvaluableProperty(ddmForm, ddmFormLayout);
        Locale locale = ddmFormRenderingContext.getLocale();
        if (locale == null) {
            locale = LocaleThreadLocal.getSiteDefaultLocale();
        }
        ResourceBundle resourceBundle = this.getResourceBundle(locale);
        String cancelLabel = GetterUtil.getString((String)ddmFormRenderingContext.getCancelLabel(), (String)this._language.get(resourceBundle, "cancel"));
        templateContext.put("cancelLabel", cancelLabel);
        templateContext.put("containerId", containerId);
        String contentType = GetterUtil.getString((String)((String)ddmFormRenderingContext.getProperty("contentType")));
        if (Validator.isNotNull((String)contentType)) {
            templateContext.put("contentType", contentType);
        }
        templateContext.put("currentPage", ParamUtil.getString((HttpServletRequest)ddmFormRenderingContext.getHttpServletRequest(), (String)"currentPage", (String)"1"));
        templateContext.put("ddmStructureLayoutId", ddmFormRenderingContext.getDDMStructureLayoutId());
        String defaultLanguageId = GetterUtil.getString((String)((String)ddmFormRenderingContext.getProperty("defaultLanguageId")));
        if (Validator.isNotNull((String)defaultLanguageId)) {
            templateContext.put("defaultLanguageId", defaultLanguageId);
        } else {
            templateContext.put("defaultLanguageId", this._language.getLanguageId(ddmForm.getDefaultLocale()));
        }
        templateContext.put("defaultSiteLanguageId", this._language.getLanguageId(LocaleUtil.getSiteDefault()));
        templateContext.put("editingLanguageId", this._language.getLanguageId(locale));
        templateContext.put("evaluatorURL", this._getDDMFormContextProviderServletURL());
        templateContext.put("groupId", ddmFormRenderingContext.getGroupId());
        templateContext.put("pages", this._getPages(ddmForm, ddmFormLayout, ddmFormRenderingContext));
        templateContext.put("paginationMode", ddmFormLayout.getPaginationMode());
        templateContext.put("persistDefaultValues", GetterUtil.getBoolean((Object)((Boolean)ddmFormRenderingContext.getProperty("persistDefaultValues")), (boolean)true));
        templateContext.put("portletNamespace", ddmFormRenderingContext.getPortletNamespace());
        templateContext.put("readOnly", ddmFormRenderingContext.isReadOnly());
        String redirectURL = ddmFormRenderingContext.getRedirectURL();
        templateContext.put("redirectURL", redirectURL);
        List ddmFormRules = ddmFormLayout.getDDMFormRules();
        if (ListUtil.isEmpty((List)ddmFormRules)) {
            ddmFormRules = ddmForm.getDDMFormRules();
        }
        templateContext.put("rules", this._toObjectList(ddmFormRules));
        boolean showCancelButton = ddmFormRenderingContext.isShowCancelButton();
        if (ddmFormRenderingContext.isReadOnly() || Validator.isNull((String)redirectURL)) {
            showCancelButton = false;
        }
        templateContext.put("showCancelButton", showCancelButton);
        templateContext.put("showPartialResultsToRespondents", GetterUtil.getBoolean((Object)((Boolean)ddmFormRenderingContext.getProperty("showPartialResultsToRespondents"))));
        templateContext.put("showRequiredFieldsWarning", ddmFormRenderingContext.isShowRequiredFieldsWarning());
        boolean showSubmitButton = ddmFormRenderingContext.isShowSubmitButton();
        if (ddmFormRenderingContext.isReadOnly()) {
            showSubmitButton = false;
        }
        templateContext.put("showSubmitButton", showSubmitButton);
        templateContext.put("strings", this._getLanguageStringsMap(resourceBundle));
        String submitLabel = GetterUtil.getString((String)ddmFormRenderingContext.getSubmitLabel(), (String)this._language.get(resourceBundle, "submit-form"));
        templateContext.put("submitLabel", submitLabel);
        templateContext.put("submittable", ddmFormRenderingContext.isSubmittable());
        templateContext.put("templateNamespace", this.getTemplateNamespace(ddmFormLayout));
        templateContext.put("validations", this._getValidations(locale));
        templateContext.put("viewMode", ddmFormRenderingContext.isViewMode());
        return templateContext;
    }

    private String _getDDMFormContextProviderServletURL() {
        String servletContextPath = this._getServletContextPath();
        return servletContextPath.concat("/dynamic-data-mapping-form-context-provider/");
    }

    private Map<String, String> _getLanguageStringsMap(ResourceBundle resourceBundle) {
        return HashMapBuilder.put((Object)"next", (Object)this._language.get(resourceBundle, "next")).put((Object)"previous", (Object)this._language.get(resourceBundle, "previous")).build();
    }

    private List<Object> _getPages(DDMForm ddmForm, DDMFormLayout ddmFormLayout, DDMFormRenderingContext ddmFormRenderingContext) {
        DDMFormPagesTemplateContextFactory ddmFormPagesTemplateContextFactory = new DDMFormPagesTemplateContextFactory(ddmForm, ddmFormLayout, ddmFormRenderingContext, this._ddmStructureLayoutLocalService, this._ddmStructureLocalService, this._groupLocalService, this._htmlParser, this._jsonFactory);
        ddmFormPagesTemplateContextFactory.setDDMFormEvaluator(this._ddmFormEvaluator);
        ddmFormPagesTemplateContextFactory.setDDMFormFieldTypeServicesRegistry(this._ddmFormFieldTypeServicesRegistry);
        return ddmFormPagesTemplateContextFactory.create();
    }

    private String _getServletContextPath() {
        String proxyPath = this._portal.getPathProxy();
        ServletConfig servletConfig = this._ddmFormContextProviderServlet.getServletConfig();
        ServletContext servletContext = servletConfig.getServletContext();
        return proxyPath.concat(servletContext.getContextPath());
    }

    private HashMap<String, Object> _getValidations(Locale locale) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : this._serviceTrackerMap.keySet()) {
            map.put(key, TransformUtil.transformToArray((Collection)((Collection)this._serviceTrackerMap.getService((Object)key)), ddmValidation -> HashMapBuilder.put((Object)"label", (Object)ddmValidation.getLabel(locale)).put((Object)"name", (Object)ddmValidation.getName()).put((Object)"parameterMessage", (Object)ddmValidation.getParameterMessage(locale)).put((Object)"template", (Object)ddmValidation.getTemplate()).build(), Object.class));
        }
        return map;
    }

    private void _setDDMFormFieldsEvaluableProperty(DDMForm ddmForm, DDMFormLayout ddmFormLayout) {
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        for (String evaluableDDMFormFieldName : this._ddmFormTemplateContextFactoryHelper.getEvaluableDDMFormFieldNames(ddmForm, ddmFormLayout)) {
            DDMFormField ddmFormField = (DDMFormField)ddmFormFieldsMap.get(evaluableDDMFormFieldName);
            ddmFormField.setProperty("evaluable", (Object)true);
        }
    }

    private Map<String, Object> _toMap(DDMFormRule ddmFormRule) {
        return HashMapBuilder.put((Object)"actions", (Object)ddmFormRule.getActions()).put((Object)"condition", (Object)ddmFormRule.getCondition()).put((Object)"enable", (Object)ddmFormRule.isEnabled()).build();
    }

    private List<Object> _toObjectList(List<DDMFormRule> ddmFormRules) {
        if (ddmFormRules == null) {
            return Collections.emptyList();
        }
        return TransformUtil.transform(ddmFormRules, this::_toMap);
    }
}

