Liferay.Loader.define("dynamic-data-mapping-form-renderer@5.0.74/js/util/repeatable.es", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.getRepeatedIndex = exports.generateNestedFieldName = exports.parseNestedFieldName = exports.generateName = exports.parseName = exports.generateInstanceId = void 0;

    /**
     * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
     * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
     */
    var FIELD_NAME_REGEX = /(_\w+_)ddm\$\$(.+)\$(\w+)\$(\d+)\$\$(\w+)/;
    var NESTED_FIELD_NAME_REGEX = /(_\w+_)ddm\$\$(.+)\$(\w+)\$(\d+)#(.+)\$(\w+)\$(\d+)\$\$(\w+)/;

    var generateInstanceId = function generateInstanceId() {
      return Math.random().toString(36).substr(2, 8);
    };

    exports.generateInstanceId = generateInstanceId;

    var parseName = function parseName(name) {
      var parsed = {};
      var result = FIELD_NAME_REGEX.exec(name);

      if (result) {
        parsed = {
          editingLanguageId: result[5],
          fieldName: result[2],
          instanceId: result[3],
          portletNamespace: result[1],
          repeatedIndex: Number(result[4])
        };
      }

      return parsed;
    };

    exports.parseName = parseName;

    var generateName = function generateName(name) {
      var props = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var parsedName = parseName(name);
      var _props$editingLanguag = props.editingLanguageId,
          editingLanguageId = _props$editingLanguag === void 0 ? parsedName.editingLanguageId : _props$editingLanguag,
          _props$fieldName = props.fieldName,
          fieldName = _props$fieldName === void 0 ? parsedName.fieldName : _props$fieldName,
          _props$instanceId = props.instanceId,
          instanceId = _props$instanceId === void 0 ? parsedName.instanceId : _props$instanceId,
          _props$portletNamespa = props.portletNamespace,
          portletNamespace = _props$portletNamespa === void 0 ? parsedName.portletNamespace : _props$portletNamespa,
          _props$repeatedIndex = props.repeatedIndex,
          repeatedIndex = _props$repeatedIndex === void 0 ? parsedName.repeatedIndex : _props$repeatedIndex;
      return "".concat(portletNamespace, "ddm$$").concat(fieldName, "$").concat(instanceId, "$").concat(repeatedIndex, "$$").concat(editingLanguageId);
    };

    exports.generateName = generateName;

    var parseNestedFieldName = function parseNestedFieldName(name) {
      var parsed = {};
      var result = NESTED_FIELD_NAME_REGEX.exec(name);

      if (result) {
        parsed = {
          fieldName: result[5],
          instanceId: result[6],
          locale: result[8],
          parentFieldName: result[2],
          parentInstanceId: result[3],
          parentRepeatedIndex: Number(result[4]),
          portletNamespace: result[1],
          repeatedIndex: Number(result[7])
        };
      }

      return parsed;
    };

    exports.parseNestedFieldName = parseNestedFieldName;

    var generateNestedFieldName = function generateNestedFieldName(name, parentFieldName) {
      var parsedParentFieldName = parseName(parentFieldName);
      var parsedName = parseNestedFieldName(name);

      if (!parsedName.fieldName) {
        parsedName = parseName(name);
      }

      var _parsedName = parsedName,
          fieldName = _parsedName.fieldName,
          instanceId = _parsedName.instanceId,
          portletNamespace = _parsedName.portletNamespace,
          repeatedIndex = _parsedName.repeatedIndex;
      return [portletNamespace, 'ddm$$', parsedParentFieldName.fieldName, '$', parsedParentFieldName.instanceId, '$', parsedParentFieldName.repeatedIndex, '#', fieldName, '$', instanceId, '$', repeatedIndex, '$$', parsedName.locale || parsedName.editingLanguageId].join('');
    };

    exports.generateNestedFieldName = generateNestedFieldName;

    var getRepeatedIndex = function getRepeatedIndex(name) {
      var parsedName;

      if (NESTED_FIELD_NAME_REGEX.test(name)) {
        parsedName = parseNestedFieldName(name);
      } else {
        parsedName = parseName(name);
      }

      return parsedName.repeatedIndex;
    };

    exports.getRepeatedIndex = getRepeatedIndex;
    //# sourceMappingURL=repeatable.es.js.map
  }
});
//# sourceMappingURL=repeatable.es.js.map