/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.renderer.internal;

import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluator;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluatorEvaluateRequest;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluatorEvaluateResponse;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.form.renderer.internal.DDMFormFieldTemplateContextFactory;
import com.liferay.dynamic.data.mapping.form.renderer.internal.DefaultDDMFormValuesFactory;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class DDMFormPagesTemplateContextFactory {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormPagesTemplateContextFactory.class);
    private final DDMForm _ddmForm;
    private DDMFormEvaluator _ddmFormEvaluator;
    private DDMFormEvaluatorEvaluateResponse _ddmFormEvaluatorEvaluateResponse;
    private final Map<String, DDMFormField> _ddmFormFieldsMap;
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    private final Map<String, List<DDMFormFieldValue>> _ddmFormFieldValuesMap;
    private final DDMFormLayout _ddmFormLayout;
    private final DDMFormRenderingContext _ddmFormRenderingContext;
    private final DDMFormValues _ddmFormValues;
    private final Locale _locale;
    private boolean _pageEnabled;

    public DDMFormPagesTemplateContextFactory(DDMForm ddmForm, DDMFormLayout ddmFormLayout, DDMFormRenderingContext ddmFormRenderingContext) {
        this._ddmForm = ddmForm;
        this._ddmFormLayout = ddmFormLayout;
        this._ddmFormRenderingContext = ddmFormRenderingContext;
        DDMFormValues ddmFormValues = ddmFormRenderingContext.getDDMFormValues();
        if (ddmFormValues == null || ListUtil.isEmpty((List)ddmFormValues.getDDMFormFieldValues())) {
            DefaultDDMFormValuesFactory defaultDDMFormValuesFactory = new DefaultDDMFormValuesFactory(ddmForm, ddmFormRenderingContext.getLocale());
            ddmFormValues = defaultDDMFormValuesFactory.create();
        } else {
            this.removeStaleDDMFormFieldValues(ddmForm.getDDMFormFieldsMap(true), ddmFormValues.getDDMFormFieldValues());
        }
        this._ddmFormValues = ddmFormValues;
        this._ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        this._ddmFormFieldValuesMap = ddmFormValues.getDDMFormFieldValuesMap();
        this._locale = ddmFormRenderingContext.getLocale();
    }

    public List<Object> create() {
        this._evaluate();
        return this.createPagesTemplateContext(this._ddmFormLayout.getDDMFormLayoutPages());
    }

    public void setDDMFormEvaluator(DDMFormEvaluator ddmFormEvaluator) {
        this._ddmFormEvaluator = ddmFormEvaluator;
    }

    public void setDDMFormFieldTypeServicesTracker(DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker) {
        this._ddmFormFieldTypeServicesTracker = ddmFormFieldTypeServicesTracker;
    }

    protected boolean containsRequiredField(List<String> ddmFormFieldNames) {
        for (String ddmFormFieldName : ddmFormFieldNames) {
            DDMFormField ddmFormField = this._ddmFormFieldsMap.get(ddmFormFieldName);
            if (!ddmFormField.isRequired()) continue;
            return true;
        }
        return false;
    }

    protected List<Object> createColumnsTemplateContext(List<DDMFormLayoutColumn> ddmFormLayoutColumns) {
        ArrayList<Object> columnsTemplateContext = new ArrayList<Object>();
        for (DDMFormLayoutColumn ddmFormLayoutColumn : ddmFormLayoutColumns) {
            columnsTemplateContext.add(this.createColumnTemplateContext(ddmFormLayoutColumn));
        }
        return columnsTemplateContext;
    }

    protected Map<String, Object> createColumnTemplateContext(DDMFormLayoutColumn ddmFormLayoutColumn) {
        return HashMapBuilder.put((Object)"fields", this.createFieldsTemplateContext(ddmFormLayoutColumn.getDDMFormFieldNames())).put((Object)"size", (Object)ddmFormLayoutColumn.getSize()).build();
    }

    protected List<Object> createFieldsTemplateContext(List<String> ddmFormFieldNames) {
        ArrayList<Object> fieldsTemplateContext = new ArrayList<Object>();
        for (String ddmFormFieldName : ddmFormFieldNames) {
            List<Object> fieldTemplateContexts = this.createFieldTemplateContext(ddmFormFieldName);
            if (!ListUtil.isNotEmpty(fieldTemplateContexts)) continue;
            fieldsTemplateContext.addAll(fieldTemplateContexts);
        }
        return fieldsTemplateContext;
    }

    protected List<Object> createFieldTemplateContext(String ddmFormFieldName) {
        DDMFormFieldTemplateContextFactory ddmFormFieldTemplateContextFactory = new DDMFormFieldTemplateContextFactory(this._ddmFormFieldsMap, this._ddmFormEvaluatorEvaluateResponse.getDDMFormFieldsPropertyChanges(), this._ddmFormFieldValuesMap.get(ddmFormFieldName), this._ddmFormRenderingContext, this._pageEnabled);
        ddmFormFieldTemplateContextFactory.setDDMFormFieldTypeServicesTracker(this._ddmFormFieldTypeServicesTracker);
        return ddmFormFieldTemplateContextFactory.create();
    }

    protected List<Object> createPagesTemplateContext(List<DDMFormLayoutPage> ddmFormLayoutPages) {
        ArrayList<Object> pagesTemplateContext = new ArrayList<Object>();
        int i = 0;
        for (DDMFormLayoutPage ddmFormLayoutPage : ddmFormLayoutPages) {
            pagesTemplateContext.add(this.createPageTemplateContext(ddmFormLayoutPage, i++));
        }
        return pagesTemplateContext;
    }

    protected Map<String, Object> createPageTemplateContext(DDMFormLayoutPage ddmFormLayoutPage, int pageIndex) {
        LocalizedValue description = ddmFormLayoutPage.getDescription();
        this._pageEnabled = this.isPageEnabled(pageIndex);
        LocalizedValue title = ddmFormLayoutPage.getTitle();
        boolean showRequiredFieldsWarning = this.isShowRequiredFieldsWarning(ddmFormLayoutPage.getDDMFormLayoutRows());
        return HashMapBuilder.put((Object)"description", (Object)description.getString(this._locale)).put((Object)"enabled", (Object)this._pageEnabled).put((Object)"localizedDescription", this.getLocalizedValueMap(description, this._ddmFormRenderingContext)).put((Object)"localizedTitle", this.getLocalizedValueMap(title, this._ddmFormRenderingContext)).put((Object)"rows", this.createRowsTemplateContext(ddmFormLayoutPage.getDDMFormLayoutRows())).put((Object)"showRequiredFieldsWarning", (Object)showRequiredFieldsWarning).put((Object)"title", (Object)title.getString(this._locale)).build();
    }

    protected List<Object> createRowsTemplateContext(List<DDMFormLayoutRow> ddmFormLayoutRows) {
        ArrayList<Object> rowsTemplateContext = new ArrayList<Object>();
        for (DDMFormLayoutRow ddmFormLayoutRow : ddmFormLayoutRows) {
            rowsTemplateContext.add(this.createRowTemplateContext(ddmFormLayoutRow));
        }
        return rowsTemplateContext;
    }

    protected Map<String, Object> createRowTemplateContext(DDMFormLayoutRow ddmFormLayoutRow) {
        return HashMapBuilder.put((Object)"columns", this.createColumnsTemplateContext(ddmFormLayoutRow.getDDMFormLayoutColumns())).build();
    }

    protected Map<String, String> getLocalizedValueMap(LocalizedValue localizedValue, DDMFormRenderingContext ddmFormRenderingContext) {
        HashMap<String, String> map = new HashMap<String, String>();
        Map values = localizedValue.getValues();
        for (Map.Entry entry : values.entrySet()) {
            String languageId = LocaleUtil.toLanguageId((Locale)((Locale)entry.getKey()));
            String keyValue = this.getValue(ddmFormRenderingContext, (String)entry.getValue());
            map.put(languageId, keyValue);
        }
        return map;
    }

    protected String getValue(DDMFormRenderingContext ddmFormRenderingContext, String value) {
        if (ddmFormRenderingContext.isViewMode()) {
            return HtmlUtil.extractText((String)value);
        }
        return value;
    }

    protected boolean isPageEnabled(int pageIndex) {
        Set disabledPagesIndexes = this._ddmFormEvaluatorEvaluateResponse.getDisabledPagesIndexes();
        return !disabledPagesIndexes.contains(pageIndex);
    }

    protected boolean isShowRequiredFieldsWarning(List<DDMFormLayoutRow> ddmFormLayoutRows) {
        if (!this._ddmFormRenderingContext.isShowRequiredFieldsWarning()) {
            return false;
        }
        for (DDMFormLayoutRow ddmFormLayoutRow : ddmFormLayoutRows) {
            for (DDMFormLayoutColumn ddmFormLayoutColumn : ddmFormLayoutRow.getDDMFormLayoutColumns()) {
                if (!this.containsRequiredField(ddmFormLayoutColumn.getDDMFormFieldNames())) continue;
                return true;
            }
        }
        return false;
    }

    protected void removeStaleDDMFormFieldValues(Map<String, DDMFormField> ddmFormFieldsMap, List<DDMFormFieldValue> ddmFormFieldValues) {
        Iterator<DDMFormFieldValue> iterator = ddmFormFieldValues.iterator();
        while (iterator.hasNext()) {
            DDMFormFieldValue ddmFormFieldValue = iterator.next();
            if (!ddmFormFieldsMap.containsKey(ddmFormFieldValue.getName())) {
                iterator.remove();
            }
            this.removeStaleDDMFormFieldValues(ddmFormFieldsMap, ddmFormFieldValue.getNestedDDMFormFieldValues());
        }
    }

    private void _evaluate() {
        try {
            DDMFormEvaluatorEvaluateRequest.Builder formEvaluatorEvaluateRequestBuilder = DDMFormEvaluatorEvaluateRequest.Builder.newBuilder((DDMForm)this._ddmForm, (DDMFormValues)this._ddmFormValues, (Locale)this._locale);
            HttpServletRequest httpServletRequest = this._ddmFormRenderingContext.getHttpServletRequest();
            formEvaluatorEvaluateRequestBuilder.withCompanyId(PortalUtil.getCompanyId((HttpServletRequest)httpServletRequest));
            formEvaluatorEvaluateRequestBuilder.withEditingFieldValue(Validator.isNotNull((String)httpServletRequest.getParameter("trigger")));
            formEvaluatorEvaluateRequestBuilder.withGroupId(this._ddmFormRenderingContext.getGroupId());
            formEvaluatorEvaluateRequestBuilder.withUserId(PortalUtil.getUserId((HttpServletRequest)httpServletRequest));
            formEvaluatorEvaluateRequestBuilder.withViewMode(this._isViewMode());
            this._ddmFormEvaluatorEvaluateResponse = this._ddmFormEvaluator.evaluate(formEvaluatorEvaluateRequestBuilder.build());
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to evaluate the form", (Throwable)exception);
            throw new IllegalStateException("Unexpected error occurred during form evaluation", exception);
        }
    }

    private boolean _isViewMode() {
        Boolean viewMode = (Boolean)this._ddmFormRenderingContext.getProperty("viewMode");
        if (viewMode != null) {
            return viewMode;
        }
        String portletNamespace = this._ddmFormRenderingContext.getPortletNamespace();
        return portletNamespace != null && !StringUtil.equals((String)portletNamespace, (String)PortalUtil.getPortletNamespace((String)"com_liferay_dynamic_data_mapping_form_web_portlet_DDMFormAdminPortlet"));
    }
}

