Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.93/js/util/pageSupport.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer/js/util/visitors.es', './strings.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.pageOptions = pageOptions;
  exports.maxPageIndex = maxPageIndex;

  var _visitors = require("dynamic-data-mapping-form-renderer/js/util/visitors.es");

  var _strings = require("./strings.es");

  /**
   * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
   * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
   */
  function pageOptions(pages) {
    var maxPageIndex = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    var pageOptions = [];

    for (var pageIndex = maxPageIndex + 2; pageIndex <= pages.length; pageIndex++) {
      var pageTitle = "".concat(pageIndex, " ").concat((0, _strings.sub)(Liferay.Language.get('untitled-page-x-of-x'), [pageIndex, pages.length]));

      if (pages[pageIndex - 1].title) {
        pageTitle = "".concat(pageIndex, " ").concat(pages[pageIndex - 1].title);
      }

      pageOptions.push({
        label: pageTitle,
        name: pageIndex.toString(),
        value: pageIndex.toString()
      });
    }

    return pageOptions;
  }

  function maxPageIndex(conditions, pages) {
    var pageIndexes = [];
    var visitor = new _visitors.PagesVisitor(pages);

    if (conditions.length && conditions[0].operands[0].value) {
      conditions.forEach(function (condition) {
        visitor.mapFields(function (field, fieldIndex, columnIndex, rowIndex, pageIndex) {
          if (field.fieldName === condition.operands[0].value) {
            pageIndexes.push(pageIndex);
          }
        });
      });
    }

    var maxPageIndex = Math.max.apply(Math, pageIndexes);
    return isFinite(maxPageIndex) ? maxPageIndex : 0;
  }
  //# sourceMappingURL=pageSupport.es.js.map
});
//# sourceMappingURL=pageSupport.es.js.map