/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.builder.internal.converter;

import com.liferay.dynamic.data.mapping.expression.DDMExpression;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionException;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.dynamic.data.mapping.expression.model.Expression;
import com.liferay.dynamic.data.mapping.expression.model.ExpressionVisitor;
import com.liferay.dynamic.data.mapping.form.builder.internal.converter.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.form.builder.internal.converter.model.DDMFormRuleAction;
import com.liferay.dynamic.data.mapping.form.builder.internal.converter.model.DDMFormRuleCondition;
import com.liferay.dynamic.data.mapping.form.builder.internal.converter.serializer.DDMFormRuleSerializerContext;
import com.liferay.dynamic.data.mapping.form.builder.internal.converter.visitor.ActionExpressionVisitor;
import com.liferay.dynamic.data.mapping.form.builder.internal.converter.visitor.ConditionExpressionVisitor;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMFormRuleConverter.class})
public class DDMFormRuleConverter {
    @Reference
    protected DDMExpressionFactory ddmExpressionFactory;
    private static final String _COMPARISON_EXPRESSION_FORMAT = "%s %s %s";
    private static final String _FUNCTION_CALL_UNARY_EXPRESSION_FORMAT = "%s(%s)";
    private static final String _NOT_EXPRESSION_FORMAT = "not(%s)";
    private static final Map<String, String> _operatorFunctionNameMap = new HashMap<String, String>(){
        {
            this.put("belongs-to", "belongsTo");
            this.put("contains", "contains");
            this.put("equals-to", "equals");
            this.put("is-empty", "isEmpty");
            this.put("not-contains", "contains");
            this.put("not-equals-to", "equals");
            this.put("not-is-empty", "isEmpty");
        }
    };
    private static final Map<String, String> _operatorMap = new HashMap<String, String>(){
        {
            this.put("greater-than", ">");
            this.put("greater-than-equals", ">=");
            this.put("less-than", "<");
            this.put("less-than-equals", "<=");
        }
    };

    public List<com.liferay.dynamic.data.mapping.model.DDMFormRule> convert(List<DDMFormRule> ddmFormRules, DDMFormRuleSerializerContext ddmFormRuleSerializerContext) {
        Stream stream = ddmFormRules.stream();
        Stream<com.liferay.dynamic.data.mapping.model.DDMFormRule> convertedFormRulesStream = stream.map(formRule -> this.convertRule((DDMFormRule)formRule, ddmFormRuleSerializerContext));
        return convertedFormRulesStream.collect(Collectors.toList());
    }

    public List<DDMFormRule> convert(List<com.liferay.dynamic.data.mapping.model.DDMFormRule> ddmFormRules) {
        ArrayList<DDMFormRule> convertedDDMFormRules = new ArrayList<DDMFormRule>();
        for (com.liferay.dynamic.data.mapping.model.DDMFormRule ddmFormRule : ddmFormRules) {
            convertedDDMFormRules.add(this.convertRule(ddmFormRule));
        }
        return convertedDDMFormRules;
    }

    protected DDMFormRuleAction convertAction(String actionExpressionString) {
        Expression actionExpression = this.createExpression(actionExpressionString);
        ActionExpressionVisitor actionExpressionVisitor = new ActionExpressionVisitor();
        return (DDMFormRuleAction)actionExpression.accept((ExpressionVisitor)actionExpressionVisitor);
    }

    protected String convertCondition(DDMFormRuleCondition ddmFormRuleCondition) {
        String operator = ddmFormRuleCondition.getOperator();
        String functionName = _operatorFunctionNameMap.get(operator);
        List<DDMFormRuleCondition.Operand> operands = ddmFormRuleCondition.getOperands();
        if (functionName == null) {
            return String.format(_COMPARISON_EXPRESSION_FORMAT, this.convertOperand(operands.get(0)), _operatorMap.get(operator), this.convertOperand(operands.get(1)));
        }
        String condition = this.createCondition(functionName, operands);
        if (operator.startsWith("not")) {
            return String.format(_NOT_EXPRESSION_FORMAT, condition);
        }
        return condition;
    }

    protected String convertConditions(String logicalOperator, List<DDMFormRuleCondition> ddmFormRuleConditions) {
        if (ddmFormRuleConditions.size() == 1) {
            return this.convertCondition(ddmFormRuleConditions.get(0));
        }
        StringBundler sb = new StringBundler(ddmFormRuleConditions.size() * 4);
        for (DDMFormRuleCondition ddmFormRuleCondition : ddmFormRuleConditions) {
            sb.append(this.convertCondition(ddmFormRuleCondition));
            sb.append(" ");
            sb.append(logicalOperator);
            sb.append(" ");
        }
        sb.setIndex(sb.index() - 3);
        return sb.toString();
    }

    protected String convertOperand(DDMFormRuleCondition.Operand operand) {
        if (Objects.equals(operand.getType(), "field")) {
            return String.format(_FUNCTION_CALL_UNARY_EXPRESSION_FORMAT, "getValue", StringUtil.quote((String)operand.getValue()));
        }
        String value = operand.getValue();
        if (this.isNumericConstant(operand.getType())) {
            return value;
        }
        String[] values = StringUtil.split((String)value);
        UnaryOperator quoteOperation = StringUtil::quote;
        UnaryOperator trimOperation = StringUtil::trim;
        return Stream.of(values).map(trimOperation.andThen(quoteOperation)).collect(Collectors.joining(", "));
    }

    protected String convertOperands(List<DDMFormRuleCondition.Operand> operands) {
        StringBundler sb = new StringBundler(operands.size());
        for (DDMFormRuleCondition.Operand operand : operands) {
            sb.append(this.convertOperand(operand));
            sb.append(", ");
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    protected com.liferay.dynamic.data.mapping.model.DDMFormRule convertRule(DDMFormRule ddmFormRule, DDMFormRuleSerializerContext ddmFormRuleSerializerContext) {
        String condition = this.convertConditions(ddmFormRule.getLogicalOperator(), ddmFormRule.getDDMFormRuleConditions());
        ArrayList<String> actions = new ArrayList<String>();
        for (DDMFormRuleAction ddmFormRuleAction : ddmFormRule.getDDMFormRuleActions()) {
            actions.add(ddmFormRuleAction.serialize(ddmFormRuleSerializerContext));
        }
        return new com.liferay.dynamic.data.mapping.model.DDMFormRule(condition, actions);
    }

    protected DDMFormRule convertRule(com.liferay.dynamic.data.mapping.model.DDMFormRule ddmFormRule) {
        DDMFormRule convertedDDMFormRule = new DDMFormRule();
        this.setDDMFormRuleConditions(convertedDDMFormRule, ddmFormRule.getCondition());
        this.setDDMFormRuleActions(convertedDDMFormRule, ddmFormRule.getActions());
        return convertedDDMFormRule;
    }

    protected String createCondition(String functionName, List<DDMFormRuleCondition.Operand> operands) {
        if (Objects.equals(functionName, "belongsTo")) {
            operands.remove(0);
        }
        return String.format(_FUNCTION_CALL_UNARY_EXPRESSION_FORMAT, functionName, this.convertOperands(operands));
    }

    protected Expression createExpression(String expressionString) {
        try {
            DDMExpression ddmExpression = this.ddmExpressionFactory.createBooleanDDMExpression(expressionString);
            return ddmExpression.getModel();
        }
        catch (DDMExpressionException ddmee) {
            throw new IllegalStateException(String.format("Unable to parse expression \"%s\"", expressionString), ddmee);
        }
    }

    protected boolean isNumericConstant(String operandType) {
        return operandType.equals("integer") || operandType.equals("double");
    }

    protected void setDDMFormRuleActions(DDMFormRule ddmFormRule, List<String> actions) {
        ArrayList<DDMFormRuleAction> ddmFormRuleActions = new ArrayList<DDMFormRuleAction>();
        for (String action : actions) {
            ddmFormRuleActions.add(this.convertAction(action));
        }
        ddmFormRule.setDDMFormRuleActions(ddmFormRuleActions);
    }

    protected void setDDMFormRuleConditions(DDMFormRule ddmFormRule, String conditionExpressionString) {
        Expression conditionExpression = this.createExpression(conditionExpressionString);
        ConditionExpressionVisitor conditionExpressionVisitor = new ConditionExpressionVisitor();
        conditionExpression.accept((ExpressionVisitor)conditionExpressionVisitor);
        ddmFormRule.setDDMFormRuleConditions(conditionExpressionVisitor.getConditions());
        ddmFormRule.setLogicalOperator(conditionExpressionVisitor.getLogicalOperator());
    }
}

