/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.expression.internal;

import com.liferay.dynamic.data.mapping.expression.DDMExpressionFunction;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFunctionFactory;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFunctionRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={DDMExpressionFunctionRegistry.class})
public class DDMExpressionFunctionRegistryImpl
implements DDMExpressionFunctionRegistry {
    private ServiceTrackerMap<String, DDMExpressionFunctionFactory> _serviceTrackerMap;

    public Map<String, DDMExpressionFunction> getCustomDDMExpressionFunctions() {
        HashMap<String, DDMExpressionFunction> customDDMExpressionFunctions = new HashMap<String, DDMExpressionFunction>();
        for (DDMExpressionFunctionFactory ddmExpressionFunctionFactory : this._serviceTrackerMap.values()) {
            DDMExpressionFunction ddmExpressionFunction = ddmExpressionFunctionFactory.create();
            if (!ddmExpressionFunction.isCustomDDMExpressionFunction()) continue;
            customDDMExpressionFunctions.put(ddmExpressionFunction.getName(), ddmExpressionFunction);
        }
        return customDDMExpressionFunctions;
    }

    public Map<String, DDMExpressionFunctionFactory> getDDMExpressionFunctionFactories(Set<String> functionNames) {
        HashMap<String, DDMExpressionFunctionFactory> ddmExpressionFunctionFactories = new HashMap<String, DDMExpressionFunctionFactory>();
        for (String functionName : functionNames) {
            DDMExpressionFunctionFactory ddmExpressionFunctionFactory = (DDMExpressionFunctionFactory)this._serviceTrackerMap.getService((Object)functionName);
            if (ddmExpressionFunctionFactory == null) continue;
            ddmExpressionFunctionFactories.put(functionName, ddmExpressionFunctionFactory);
        }
        return ddmExpressionFunctionFactories;
    }

    @Deprecated
    public Map<String, DDMExpressionFunction> getDDMExpressionFunctions(Set<String> functionNames) {
        return Collections.emptyMap();
    }

    @Deprecated
    public void ungetDDMExpressionFunctions(Map<String, DDMExpressionFunction> ddmExpressionFunctionsMap) {
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, DDMExpressionFunctionFactory.class, (String)"name");
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

