/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.internal.exporter;

import com.liferay.dynamic.data.lists.exporter.DDLExporter;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSetVersion;
import com.liferay.dynamic.data.lists.service.DDLRecordSetVersionService;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldValueRenderer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.render.DDMFormFieldValueRendererRegistry;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class BaseDDLExporter
implements DDLExporter {
    private Locale _locale;

    public byte[] export(long recordSetId) throws Exception {
        return this.doExport(recordSetId, -1, -1, -1, null);
    }

    public byte[] export(long recordSetId, int status) throws Exception {
        return this.doExport(recordSetId, status, -1, -1, null);
    }

    public byte[] export(long recordSetId, int status, int start, int end) throws Exception {
        return this.doExport(recordSetId, status, start, end, null);
    }

    public byte[] export(long recordSetId, int status, int start, int end, OrderByComparator<DDLRecord> orderByComparator) throws Exception {
        return this.doExport(recordSetId, status, start, end, orderByComparator);
    }

    public Locale getLocale() {
        if (this._locale == null) {
            this._locale = LocaleUtil.getSiteDefault();
        }
        return this._locale;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    protected abstract byte[] doExport(long var1, int var3, int var4, int var5, OrderByComparator<DDLRecord> var6) throws Exception;

    protected String formatDate(Date date, DateTimeFormatter dateTimeFormatter) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        return dateTimeFormatter.format(localDateTime);
    }

    protected DateTimeFormatter getDateTimeFormatter() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT);
        return dateTimeFormatter.withLocale(this.getLocale());
    }

    protected abstract DDLRecordSetVersionService getDDLRecordSetVersionService();

    protected DDMFormFieldRenderedValue getDDMFormFieldRenderedValue(int scope, DDMFormField ddmFormField, Map<String, List<DDMFormFieldValue>> ddmFormFieldValueMap) {
        List<DDMFormFieldValue> ddmForFieldValues = ddmFormFieldValueMap.get(ddmFormField.getName());
        String valueString = "";
        DDMFormFieldValue ddmFormFieldValue = ddmForFieldValues.get(0);
        if (scope == 2) {
            DDMFormFieldValueRenderer ddmFormFieldValueRenderer = this.getDDMFormFieldTypeServicesTracker().getDDMFormFieldValueRenderer(ddmFormFieldValue.getType());
            valueString = ddmFormFieldValueRenderer.render(ddmFormFieldValue, this.getLocale());
        } else {
            DDMFormFieldValueRendererRegistry ddmFormFieldValueRendererRegistry = this.getDDMFormFieldValueRendererRegistry();
            com.liferay.dynamic.data.mapping.render.DDMFormFieldValueRenderer ddmFormFieldValueRenderer = ddmFormFieldValueRendererRegistry.getDDMFormFieldValueRenderer(ddmFormFieldValue.getType());
            String ddmFormFieldType = ddmFormFieldValueRenderer.getSupportedDDMFormFieldType();
            if (Objects.equals("ddm-text-html", ddmFormFieldType)) {
                Value value = ddmFormFieldValue.getValue();
                valueString = HtmlUtil.escape((String)value.getString(this.getLocale()));
            } else {
                valueString = ddmFormFieldValueRenderer.render(ddmForFieldValues, this.getLocale());
            }
        }
        valueString = HtmlUtil.render((String)valueString);
        return new DDMFormFieldRenderedValue(ddmFormField.getName(), ddmFormField.getLabel(), valueString);
    }

    protected abstract DDMFormFieldTypeServicesTracker getDDMFormFieldTypeServicesTracker();

    protected abstract DDMFormFieldValueRendererRegistry getDDMFormFieldValueRendererRegistry();

    protected Map<String, DDMFormField> getDistinctFields(long recordSetId) throws Exception {
        List<DDMStructureVersion> ddmStructureVersions = this.getStructureVersions(recordSetId);
        LinkedHashMap<String, DDMFormField> ddmFormFields = new LinkedHashMap<String, DDMFormField>();
        for (DDMStructureVersion ddmStructureVersion : ddmStructureVersions) {
            DDMForm ddmForm = ddmStructureVersion.getDDMForm();
            ddmFormFields.putAll(ddmForm.getDDMFormFieldsMap(true));
        }
        return ddmFormFields;
    }

    protected Map<String, DDMFormFieldRenderedValue> getRenderedValues(int scope, Collection<DDMFormField> ddmFormFields, DDMFormValues ddmFormValues) throws Exception {
        Map ddmFormFieldValueMap = ddmFormValues.getDDMFormFieldValuesMap();
        Stream<DDMFormField> ddmFormFieldStream = ddmFormFields.stream();
        ddmFormFieldStream = ddmFormFieldStream.filter(ddmFormField -> ddmFormFieldValueMap.containsKey(ddmFormField.getName()));
        Stream<DDMFormFieldRenderedValue> valueStream = ddmFormFieldStream.map(ddmFormField -> this.getDDMFormFieldRenderedValue(scope, (DDMFormField)ddmFormField, ddmFormFieldValueMap));
        return valueStream.collect(Collectors.toMap(DDMFormFieldRenderedValue::getFieldName, value -> value));
    }

    protected String getStatusMessage(int status) {
        String statusLabel = WorkflowConstants.getStatusLabel((int)status);
        return LanguageUtil.get((Locale)this._locale, (String)statusLabel);
    }

    protected List<DDMStructureVersion> getStructureVersions(long recordSetId) throws Exception {
        DDLRecordSetVersionService recordSetVersionService = this.getDDLRecordSetVersionService();
        List recordSetVersions = recordSetVersionService.getRecordSetVersions(recordSetId, -1, -1, null);
        ArrayList<DDMStructureVersion> ddmStructureVersions = new ArrayList<DDMStructureVersion>();
        for (DDLRecordSetVersion recordSetVersion : recordSetVersions) {
            ddmStructureVersions.add(recordSetVersion.getDDMStructureVersion());
        }
        return ddmStructureVersions;
    }

    protected static class DDMFormFieldRenderedValue {
        private final String _fieldName;
        private final LocalizedValue _label;
        private final String _value;

        protected DDMFormFieldRenderedValue(String fieldName, LocalizedValue label, String value) {
            this._fieldName = fieldName;
            this._label = label;
            this._value = value;
        }

        protected String getFieldName() {
            return this._fieldName;
        }

        protected LocalizedValue getLabel() {
            return this._label;
        }

        protected String getValue() {
            return this._value;
        }
    }
}

