/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.sync.internal.model.listener;

import com.liferay.document.library.sync.model.DLSyncEvent;
import com.liferay.document.library.sync.service.DLSyncEventLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class CompanyModelListener
extends BaseModelListener<Company> {
    @Reference
    private DLSyncEventLocalService _dlSyncEventLocalService;

    public void onAfterRemove(Company company) throws ModelListenerException {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            this._deleteDLSyncEvent(company);
            return null;
        });
    }

    private void _deleteDLSyncEvent(Company company) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._dlSyncEventLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"companyId", (Object)company.getCompanyId())));
        actionableDynamicQuery.setPerformActionMethod(dlSyncEvent -> this._dlSyncEventLocalService.deleteDLSyncEvent((DLSyncEvent)dlSyncEvent));
        actionableDynamicQuery.performActions();
    }
}

