/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.document.library.sync.model.impl;

import com.liferay.document.library.sync.model.DLSyncEvent;
import com.liferay.document.library.sync.model.DLSyncEventModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the DLSyncEvent service. Represents a row in the &quot;DLSyncEvent&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>DLSyncEventModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link DLSyncEventImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DLSyncEventImpl
 * @generated
 */
public class DLSyncEventModelImpl
	extends BaseModelImpl<DLSyncEvent> implements DLSyncEventModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a dl sync event model instance should use the <code>DLSyncEvent</code> interface instead.
	 */
	public static final String TABLE_NAME = "DLSyncEvent";

	public static final Object[][] TABLE_COLUMNS = {
		{"syncEventId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"modifiedTime", Types.BIGINT}, {"event", Types.VARCHAR},
		{"type_", Types.VARCHAR}, {"typePK", Types.BIGINT}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("syncEventId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("modifiedTime", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("event", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("type_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("typePK", Types.BIGINT);
	}

	public static final String TABLE_SQL_CREATE =
		"create table DLSyncEvent (syncEventId LONG not null primary key,companyId LONG,modifiedTime LONG,event VARCHAR(75) null,type_ VARCHAR(75) null,typePK LONG)";

	public static final String TABLE_SQL_DROP = "drop table DLSyncEvent";

	public static final String ORDER_BY_JPQL =
		" ORDER BY dlSyncEvent.modifiedTime ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY DLSyncEvent.modifiedTime ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long MODIFIEDTIME_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long TYPEPK_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public DLSyncEventModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _syncEventId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setSyncEventId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _syncEventId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return DLSyncEvent.class;
	}

	@Override
	public String getModelClassName() {
		return DLSyncEvent.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<DLSyncEvent, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<DLSyncEvent, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DLSyncEvent, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((DLSyncEvent)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<DLSyncEvent, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<DLSyncEvent, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(DLSyncEvent)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<DLSyncEvent, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<DLSyncEvent, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<DLSyncEvent, Object>>
		_attributeGetterFunctions;

	static {
		Map<String, Function<DLSyncEvent, Object>> attributeGetterFunctions =
			new LinkedHashMap<String, Function<DLSyncEvent, Object>>();

		attributeGetterFunctions.put(
			"syncEventId", DLSyncEvent::getSyncEventId);
		attributeGetterFunctions.put("companyId", DLSyncEvent::getCompanyId);
		attributeGetterFunctions.put(
			"modifiedTime", DLSyncEvent::getModifiedTime);
		attributeGetterFunctions.put("event", DLSyncEvent::getEvent);
		attributeGetterFunctions.put("type", DLSyncEvent::getType);
		attributeGetterFunctions.put("typePK", DLSyncEvent::getTypePK);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
	}

	private static final Map<String, BiConsumer<DLSyncEvent, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, BiConsumer<DLSyncEvent, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<DLSyncEvent, ?>>();

		attributeSetterBiConsumers.put(
			"syncEventId",
			(BiConsumer<DLSyncEvent, Long>)DLSyncEvent::setSyncEventId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<DLSyncEvent, Long>)DLSyncEvent::setCompanyId);
		attributeSetterBiConsumers.put(
			"modifiedTime",
			(BiConsumer<DLSyncEvent, Long>)DLSyncEvent::setModifiedTime);
		attributeSetterBiConsumers.put(
			"event", (BiConsumer<DLSyncEvent, String>)DLSyncEvent::setEvent);
		attributeSetterBiConsumers.put(
			"type", (BiConsumer<DLSyncEvent, String>)DLSyncEvent::setType);
		attributeSetterBiConsumers.put(
			"typePK", (BiConsumer<DLSyncEvent, Long>)DLSyncEvent::setTypePK);

		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@Override
	public long getSyncEventId() {
		return _syncEventId;
	}

	@Override
	public void setSyncEventId(long syncEventId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_syncEventId = syncEventId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@Override
	public long getModifiedTime() {
		return _modifiedTime;
	}

	@Override
	public void setModifiedTime(long modifiedTime) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedTime = modifiedTime;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalModifiedTime() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("modifiedTime"));
	}

	@Override
	public String getEvent() {
		if (_event == null) {
			return "";
		}
		else {
			return _event;
		}
	}

	@Override
	public void setEvent(String event) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_event = event;
	}

	@Override
	public String getType() {
		if (_type == null) {
			return "";
		}
		else {
			return _type;
		}
	}

	@Override
	public void setType(String type) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_type = type;
	}

	@Override
	public long getTypePK() {
		return _typePK;
	}

	@Override
	public void setTypePK(long typePK) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_typePK = typePK;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalTypePK() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("typePK"));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), DLSyncEvent.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public DLSyncEvent toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, DLSyncEvent>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		DLSyncEventImpl dlSyncEventImpl = new DLSyncEventImpl();

		dlSyncEventImpl.setSyncEventId(getSyncEventId());
		dlSyncEventImpl.setCompanyId(getCompanyId());
		dlSyncEventImpl.setModifiedTime(getModifiedTime());
		dlSyncEventImpl.setEvent(getEvent());
		dlSyncEventImpl.setType(getType());
		dlSyncEventImpl.setTypePK(getTypePK());

		dlSyncEventImpl.resetOriginalValues();

		return dlSyncEventImpl;
	}

	@Override
	public int compareTo(DLSyncEvent dlSyncEvent) {
		int value = 0;

		if (getModifiedTime() < dlSyncEvent.getModifiedTime()) {
			value = -1;
		}
		else if (getModifiedTime() > dlSyncEvent.getModifiedTime()) {
			value = 1;
		}
		else {
			value = 0;
		}

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof DLSyncEvent)) {
			return false;
		}

		DLSyncEvent dlSyncEvent = (DLSyncEvent)object;

		long primaryKey = dlSyncEvent.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<DLSyncEvent> toCacheModel() {
		DLSyncEventCacheModel dlSyncEventCacheModel =
			new DLSyncEventCacheModel();

		dlSyncEventCacheModel.syncEventId = getSyncEventId();

		dlSyncEventCacheModel.companyId = getCompanyId();

		dlSyncEventCacheModel.modifiedTime = getModifiedTime();

		dlSyncEventCacheModel.event = getEvent();

		String event = dlSyncEventCacheModel.event;

		if ((event != null) && (event.length() == 0)) {
			dlSyncEventCacheModel.event = null;
		}

		dlSyncEventCacheModel.type = getType();

		String type = dlSyncEventCacheModel.type;

		if ((type != null) && (type.length() == 0)) {
			dlSyncEventCacheModel.type = null;
		}

		dlSyncEventCacheModel.typePK = getTypePK();

		return dlSyncEventCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<DLSyncEvent, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<DLSyncEvent, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DLSyncEvent, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((DLSyncEvent)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<DLSyncEvent, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<DLSyncEvent, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DLSyncEvent, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((DLSyncEvent)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, DLSyncEvent>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					DLSyncEvent.class, ModelWrapper.class);

	}

	private long _syncEventId;
	private long _companyId;
	private long _modifiedTime;
	private String _event;
	private String _type;
	private long _typePK;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<DLSyncEvent, Object> function = _attributeGetterFunctions.get(
			columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((DLSyncEvent)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("syncEventId", _syncEventId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("modifiedTime", _modifiedTime);
		_columnOriginalValues.put("event", _event);
		_columnOriginalValues.put("type_", _type);
		_columnOriginalValues.put("typePK", _typePK);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("type_", "type");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("syncEventId", 1L);

		columnBitmasks.put("companyId", 2L);

		columnBitmasks.put("modifiedTime", 4L);

		columnBitmasks.put("event", 8L);

		columnBitmasks.put("type_", 16L);

		columnBitmasks.put("typePK", 32L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private DLSyncEvent _escapedModel;

}