/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.upgrade.helper;

import com.liferay.document.library.configuration.DLConfiguration;
import com.liferay.document.library.configuration.DLFileEntryConfiguration;
import com.liferay.document.library.internal.configuration.DLSizeLimitConfiguration;
import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.PrefsProps;
import com.liferay.portal.kernel.util.Validator;
import java.util.Dictionary;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DLConfigurationUpgradeHelper.class})
public class DLConfigurationUpgradeHelper {
    public static final String CLASS_NAME_DL_FILE_ENTRY_CONFIGURATION = "com.liferay.document.library.configuration.DLFileEntryConfiguration";
    public static final String CLASS_NAME_PDF_PREVIEW_CONFIGURATION = "com.liferay.document.library.preview.pdf.internal.configuration.PDFPreviewConfiguration";
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private PrefsProps _prefsProps;

    public void deleteConfigurations(String className) throws Exception {
        Configuration[] configurations = this._configurationAdmin.listConfigurations(String.format("(%s=%s*)", "service.pid", className));
        if (configurations == null) {
            return;
        }
        for (Configuration configuration : configurations) {
            configuration.delete();
        }
    }

    public long getDLFileEntryConfigurationPreviewableProcessorMaxSize() throws Exception {
        Configuration dlFileEntryConfiguration = this.getSystemConfiguration(CLASS_NAME_DL_FILE_ENTRY_CONFIGURATION);
        if (dlFileEntryConfiguration != null) {
            return this._getAttributeValue(dlFileEntryConfiguration, "previewableProcessorMaxSize", 0x1400000L);
        }
        return 0x1400000L;
    }

    public Configuration getSystemConfiguration(String className) throws Exception {
        Configuration[] configurations = this._configurationAdmin.listConfigurations(String.format("(%s=%s)", "service.pid", className));
        if (configurations == null) {
            return null;
        }
        return configurations[0];
    }

    public boolean hasDLFileEntryConfigurationChanges() throws Exception {
        Long previewableProcessorMaxSize;
        Dictionary dictionary;
        Configuration dlFileEntryConfiguration = this.getSystemConfiguration(CLASS_NAME_DL_FILE_ENTRY_CONFIGURATION);
        return dlFileEntryConfiguration == null || (dictionary = dlFileEntryConfiguration.getProperties()) == null || (previewableProcessorMaxSize = (Long)dictionary.get("previewableProcessorMaxSize")) == null || previewableProcessorMaxSize == 0x1400000L;
    }

    public boolean hasDLSizeLimitConfigurationChanges() throws Exception {
        Long fileMaxSize;
        Dictionary dictionary;
        Configuration dlSizeLimitConfiguration = this.getSystemConfiguration(DLSizeLimitConfiguration.class.getName());
        return dlSizeLimitConfiguration == null || (dictionary = dlSizeLimitConfiguration.getProperties()) == null || (fileMaxSize = (Long)dictionary.get("fileMaxSize")) == null || fileMaxSize == 0L;
    }

    public boolean hasLegacyProps() throws Exception {
        return !Validator.isNull((String)this._prefsProps.getString("dl.file.extensions", null)) || !Validator.isNull((String)this._prefsProps.getString("dl.file.max.size", null)) || !Validator.isNull((String)this._prefsProps.getString("dl.file.entry.previewable.processor.max.size", null));
    }

    public void updateDLFileEntryConfigurationSystemConfiguration(long previewableProcessorMaxSize) throws Exception {
        Configuration dlFileEntryConfiguration = this.getSystemConfiguration(CLASS_NAME_DL_FILE_ENTRY_CONFIGURATION);
        Configuration pdfPreviewConfiguration = this.getSystemConfiguration(CLASS_NAME_PDF_PREVIEW_CONFIGURATION);
        if (dlFileEntryConfiguration != null || pdfPreviewConfiguration != null) {
            this._configurationProvider.saveSystemConfiguration(DLFileEntryConfiguration.class, this._createDLFileEntryConfigurationDictionary(this._getAttributeValue(pdfPreviewConfiguration, "maxNumberOfPages", 3), previewableProcessorMaxSize));
        }
    }

    public void updateDLSizeLimitConfiguration() throws Exception {
        long fileMaxSize = this._updateDLConfigurationFileMaxSize();
        if (fileMaxSize > 0L) {
            this._updateDLSizeLimitConfigurationFileMaxSize(fileMaxSize);
        }
    }

    public void updateScopedConfigurations(long systemPreviewableProcessorMaxSize) throws Exception {
        Configuration[] configurations;
        for (Configuration configuration : configurations = this._getScopedConfigurations(CLASS_NAME_PDF_PREVIEW_CONFIGURATION)) {
            long companyId = this._getAttributeValue(configuration, ExtendedObjectClassDefinition.Scope.COMPANY.getPropertyKey(), 0L);
            HashMapDictionary<String, Object> dictionary = this._createDLFileEntryConfigurationDictionary(this._getAttributeValue(configuration, "maxNumberOfPages", 3), Math.max(0x1400000L, systemPreviewableProcessorMaxSize));
            long groupId = this._getAttributeValue(configuration, ExtendedObjectClassDefinition.Scope.GROUP.getPropertyKey(), 0L);
            if (companyId != 0L && groupId == 0L) {
                this._configurationProvider.saveCompanyConfiguration(DLFileEntryConfiguration.class, companyId, dictionary);
                continue;
            }
            if (groupId == 0L) continue;
            this._configurationProvider.saveGroupConfiguration(DLFileEntryConfiguration.class, companyId, groupId, dictionary);
        }
    }

    private HashMapDictionary<String, Object> _createDLFileEntryConfigurationDictionary(int maxNumberOfPages, long previewableProcessorMaxSize) {
        return HashMapDictionaryBuilder.put((Object)"maxNumberOfPages", (Object)maxNumberOfPages).put((Object)"previewableProcessorMaxSize", (Object)previewableProcessorMaxSize).build();
    }

    private <T> T _getAttributeValue(Configuration configuration, String attributeName, T defaultValue) {
        if (configuration == null) {
            return defaultValue;
        }
        Dictionary dictionary = configuration.getProperties();
        if (dictionary == null) {
            return defaultValue;
        }
        Object value = dictionary.get(attributeName);
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    private Configuration[] _getScopedConfigurations(String className) throws Exception {
        Configuration[] configurations = this._configurationAdmin.listConfigurations(String.format("(%s=%s.scoped)", "service.factoryPid", className));
        if (configurations == null) {
            return new Configuration[0];
        }
        return configurations;
    }

    private long _updateDLConfigurationFileMaxSize() throws Exception {
        Configuration configuration = this.getSystemConfiguration(DLConfiguration.class.getName());
        if (configuration == null) {
            return 0L;
        }
        Dictionary dictionary = configuration.getProperties();
        if (dictionary == null) {
            return 0L;
        }
        Long fileMaxSize = (Long)dictionary.get("fileMaxSize");
        if (fileMaxSize == null) {
            return 0L;
        }
        dictionary.remove("fileMaxSize");
        configuration.update(dictionary);
        return fileMaxSize;
    }

    private void _updateDLSizeLimitConfigurationFileMaxSize(long fileMaxSize) throws Exception {
        Configuration configuration = this._configurationAdmin.getConfiguration(DLSizeLimitConfiguration.class.getName(), "?");
        configuration.update((Dictionary)HashMapDictionaryBuilder.put((Object)"fileMaxSize", (Object)fileMaxSize).build());
    }
}

