/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.configuration;

import com.liferay.document.library.configuration.DLSizeLimitConfigurationProvider;
import com.liferay.document.library.internal.configuration.DLSizeLimitConfiguration;
import com.liferay.document.library.internal.configuration.helper.DLSizeLimitConfigurationHelper;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.HashMapDictionary;
import java.util.Dictionary;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DLSizeLimitConfigurationProvider.class})
public class DLSizeLimitConfigurationProviderImpl
implements DLSizeLimitConfigurationProvider {
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private DLSizeLimitConfigurationHelper _dlSizeLimitConfigurationHelper;
    @Reference
    private GroupLocalService _groupLocalService;

    public long getCompanyFileMaxSize(long companyId) {
        return this._dlSizeLimitConfigurationHelper.getCompanyFileMaxSize(companyId);
    }

    public long getCompanyMaxSizeToCopy(long companyId) {
        return this._dlSizeLimitConfigurationHelper.getCompanyMaxSizeToCopy(companyId);
    }

    public Map<String, Long> getCompanyMimeTypeSizeLimit(long companyId) {
        return this._dlSizeLimitConfigurationHelper.getCompanyMimeTypeSizeLimit(companyId);
    }

    public long getGroupFileMaxSize(long groupId) {
        return this._dlSizeLimitConfigurationHelper.getGroupFileMaxSize(groupId);
    }

    public long getGroupMaxSizeToCopy(long groupId) {
        return this._dlSizeLimitConfigurationHelper.getGroupMaxSizeToCopy(groupId);
    }

    public Map<String, Long> getGroupMimeTypeSizeLimit(long groupId) {
        return this._dlSizeLimitConfigurationHelper.getGroupMimeTypeSizeLimit(groupId);
    }

    public long getSystemFileMaxSize() {
        return this._dlSizeLimitConfigurationHelper.getSystemFileMaxSize();
    }

    public long getSystemMaxSizeToCopy() {
        return this._dlSizeLimitConfigurationHelper.getSystemMaxSizeToCopy();
    }

    public Map<String, Long> getSystemMimeTypeSizeLimit() {
        return this._dlSizeLimitConfigurationHelper.getSystemMimeTypeSizeLimit();
    }

    public void updateCompanySizeLimit(long companyId, long fileMaxSize, long maxSizeToCopy, Map<String, Long> mimeTypeSizeLimit) throws Exception {
        HashMapDictionary properties = new HashMapDictionary();
        this._updateMimeTypeSizeLimitProperty((Dictionary<String, Object>)properties, mimeTypeSizeLimit);
        properties.put("fileMaxSize", fileMaxSize);
        properties.put("maxSizeToCopy", maxSizeToCopy);
        this._configurationProvider.saveCompanyConfiguration(DLSizeLimitConfiguration.class, companyId, (Dictionary)properties);
    }

    public void updateGroupSizeLimit(long groupId, long fileMaxSize, long maxSizeToCopy, Map<String, Long> mimeTypeSizeLimit) throws Exception {
        Group group = this._groupLocalService.fetchGroup(groupId);
        HashMapDictionary properties = new HashMapDictionary();
        this._updateMimeTypeSizeLimitProperty((Dictionary<String, Object>)properties, mimeTypeSizeLimit);
        properties.put("fileMaxSize", fileMaxSize);
        properties.put("maxSizeToCopy", maxSizeToCopy);
        this._configurationProvider.saveGroupConfiguration(DLSizeLimitConfiguration.class, group.getCompanyId(), groupId, (Dictionary)properties);
    }

    public void updateSystemSizeLimit(long fileMaxSize, long maxSizeToCopy, Map<String, Long> mimeTypeSizeLimit) throws Exception {
        HashMapDictionary properties = new HashMapDictionary();
        this._updateMimeTypeSizeLimitProperty((Dictionary<String, Object>)properties, mimeTypeSizeLimit);
        properties.put("fileMaxSize", fileMaxSize);
        properties.put("maxSizeToCopy", maxSizeToCopy);
        this._configurationProvider.saveSystemConfiguration(DLSizeLimitConfiguration.class, (Dictionary)properties);
    }

    private void _updateMimeTypeSizeLimitProperty(Dictionary<String, Object> properties, Map<String, Long> mimeTypeSizeLimit) {
        if (mimeTypeSizeLimit.isEmpty()) {
            properties.put("mimeTypeSizeLimit", new String[0]);
        } else {
            String[] mimeTypeSizeLimitArray = new String[mimeTypeSizeLimit.size()];
            int i = 0;
            for (Map.Entry<String, Long> entry : mimeTypeSizeLimit.entrySet()) {
                mimeTypeSizeLimitArray[i] = entry.getKey() + ":" + String.valueOf(entry.getValue());
                ++i;
            }
            properties.put("mimeTypeSizeLimit", mimeTypeSizeLimitArray);
        }
    }
}

