/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.configuration;

import com.liferay.document.library.configuration.DLFileEntryConfiguration;
import com.liferay.document.library.configuration.DLFileEntryConfigurationProvider;
import com.liferay.document.library.exception.DLFileEntryConfigurationException;
import com.liferay.document.library.internal.configuration.helper.DLFileEntryConfigurationHelper;
import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DLFileEntryConfigurationProvider.class})
public class DLFileEntryConfigurationProviderImpl
implements DLFileEntryConfigurationProvider {
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private DLFileEntryConfigurationHelper _dlFileEntryConfigurationHelper;
    @Reference
    private GroupLocalService _groupLocalService;

    public int getCompanyMaxNumberOfPages(long companyId) {
        return this._getMinimumMaxNumberOfPages(this._dlFileEntryConfigurationHelper.getCompanyMaxNumberOfPages(companyId), this._dlFileEntryConfigurationHelper.getSystemMaxNumberOfPages());
    }

    public long getCompanyPreviewableProcessorMaxSize(long companyId) {
        return this._getMinimumPreviewableProcessorMaxSize(this._dlFileEntryConfigurationHelper.getCompanyPreviewableProcessorMaxSize(companyId), this._dlFileEntryConfigurationHelper.getSystemPreviewableProcessorMaxSize());
    }

    public int getGroupMaxNumberOfPages(long groupId) {
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return this._dlFileEntryConfigurationHelper.getSystemMaxNumberOfPages();
        }
        return this._getMinimumMaxNumberOfPages(this._dlFileEntryConfigurationHelper.getGroupMaxNumberOfPages(groupId), this._dlFileEntryConfigurationHelper.getCompanyMaxNumberOfPages(group.getCompanyId()), this._dlFileEntryConfigurationHelper.getSystemMaxNumberOfPages());
    }

    public long getGroupPreviewableProcessorMaxSize(long groupId) {
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return this._dlFileEntryConfigurationHelper.getSystemPreviewableProcessorMaxSize();
        }
        return this._getMinimumPreviewableProcessorMaxSize(this._dlFileEntryConfigurationHelper.getGroupPreviewableProcessorMaxSize(groupId), this._dlFileEntryConfigurationHelper.getCompanyPreviewableProcessorMaxSize(group.getCompanyId()), this._dlFileEntryConfigurationHelper.getSystemPreviewableProcessorMaxSize());
    }

    public Map<Long, Long> getGroupPreviewableProcessorMaxSizeMap() {
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        for (long groupId : this._dlFileEntryConfigurationHelper.getGroupIds()) {
            long previewableProcessorMaxSize = this.getGroupPreviewableProcessorMaxSize(groupId);
            Group group = this._groupLocalService.fetchGroup(groupId);
            if (group == null || previewableProcessorMaxSize == this.getCompanyPreviewableProcessorMaxSize(group.getCompanyId())) continue;
            map.put(groupId, previewableProcessorMaxSize);
        }
        return map;
    }

    public int getMaxNumberOfPages(ExtendedObjectClassDefinition.Scope scope, long scopePK) {
        return this._getScopeConfigurationAttribute(scope, scopePK, this::getCompanyMaxNumberOfPages, this::getGroupMaxNumberOfPages, this::getSystemMaxNumberOfPages);
    }

    public int getMaxNumberOfPagesLimit(ExtendedObjectClassDefinition.Scope scope, long scopePK) {
        return this._getScopeConfigurationAttribute(scope, scopePK, companyId -> this.getSystemMaxNumberOfPages(), this::_getGroupMaxNumberOfPagesLimit, () -> 0);
    }

    public long getPreviewableProcessorMaxSize(ExtendedObjectClassDefinition.Scope scope, long scopePK) {
        return this._getScopeConfigurationAttribute(scope, scopePK, this::getCompanyPreviewableProcessorMaxSize, this::getGroupPreviewableProcessorMaxSize, this::getSystemPreviewableProcessorMaxSize);
    }

    public long getPreviewableProcessorMaxSizeLimit(ExtendedObjectClassDefinition.Scope scope, long scopePK) {
        return this._getScopeConfigurationAttribute(scope, scopePK, companyId -> this.getSystemPreviewableProcessorMaxSize(), this::_getGroupPreviewableProcessorMaxSizeLimit, () -> -1L);
    }

    public int getSystemMaxNumberOfPages() {
        return this._dlFileEntryConfigurationHelper.getSystemMaxNumberOfPages();
    }

    public long getSystemPreviewableProcessorMaxSize() {
        return this._dlFileEntryConfigurationHelper.getSystemPreviewableProcessorMaxSize();
    }

    public void update(long previewableProcessorMaxSize, int maxNumberOfPages, ExtendedObjectClassDefinition.Scope scope, long scopePK) throws Exception {
        if (scope == ExtendedObjectClassDefinition.Scope.COMPANY) {
            this._updateCompanyValues(scopePK, maxNumberOfPages, previewableProcessorMaxSize);
        } else if (scope == ExtendedObjectClassDefinition.Scope.GROUP) {
            this._updateGroupValues(scopePK, maxNumberOfPages, previewableProcessorMaxSize);
        } else if (scope == ExtendedObjectClassDefinition.Scope.SYSTEM) {
            this._configurationProvider.saveSystemConfiguration(DLFileEntryConfiguration.class, this._createDictionary(maxNumberOfPages, previewableProcessorMaxSize));
        } else {
            throw new IllegalArgumentException("Unsupported scope: " + String.valueOf(scope));
        }
    }

    private HashMapDictionary<String, Object> _createDictionary(int maxNumberOfPages, long previewableProcessorMaxSize) {
        return HashMapDictionaryBuilder.put((Object)"maxNumberOfPages", (Object)maxNumberOfPages).put((Object)"previewableProcessorMaxSize", (Object)previewableProcessorMaxSize).build();
    }

    private int _getGroupMaxNumberOfPagesLimit(long groupId) {
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return this.getSystemMaxNumberOfPages();
        }
        return this.getCompanyMaxNumberOfPages(group.getCompanyId());
    }

    private long _getGroupPreviewableProcessorMaxSizeLimit(long groupId) {
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return this.getSystemPreviewableProcessorMaxSize();
        }
        return this.getCompanyPreviewableProcessorMaxSize(group.getCompanyId());
    }

    private long _getMinimum(long unlimitedValue, long ... values) {
        long minimum = Long.MAX_VALUE;
        for (long value : values) {
            if (value == unlimitedValue || value >= minimum) continue;
            minimum = value;
        }
        if (minimum == Long.MAX_VALUE) {
            return unlimitedValue;
        }
        return minimum;
    }

    private int _getMinimumMaxNumberOfPages(long ... values) {
        return (int)this._getMinimum(0L, values);
    }

    private long _getMinimumPreviewableProcessorMaxSize(long ... values) {
        return this._getMinimum(-1L, values);
    }

    private <T> T _getScopeConfigurationAttribute(ExtendedObjectClassDefinition.Scope scope, long scopePK, Function<Long, T> companyFunction, Function<Long, T> groupFunction, Supplier<T> systemFunction) {
        if (scope == ExtendedObjectClassDefinition.Scope.COMPANY) {
            return companyFunction.apply(scopePK);
        }
        if (scope == ExtendedObjectClassDefinition.Scope.GROUP) {
            return groupFunction.apply(scopePK);
        }
        if (scope == ExtendedObjectClassDefinition.Scope.SYSTEM) {
            return systemFunction.get();
        }
        throw new IllegalArgumentException("Unsupported scope: " + String.valueOf(scope));
    }

    private boolean _isLimitExceeded(long limit, long value, long unlimitedValue) {
        return limit != unlimitedValue && (value == unlimitedValue || limit < value);
    }

    private void _updateCompanyValues(long companyId, int maxNumberOfPages, long previewableProcessorMaxSize) throws Exception {
        this._validateMaxNumberOfPages(maxNumberOfPages, this.getSystemMaxNumberOfPages());
        this._validatePreviewableProcessorMaxSize(previewableProcessorMaxSize, this.getSystemPreviewableProcessorMaxSize());
        this._configurationProvider.saveCompanyConfiguration(DLFileEntryConfiguration.class, companyId, this._createDictionary(maxNumberOfPages, previewableProcessorMaxSize));
    }

    private void _updateGroupValues(long groupId, int maxNumberOfPages, long previewableProcessorMaxSize) throws Exception {
        this._validateMaxNumberOfPages(maxNumberOfPages, this.getSystemMaxNumberOfPages());
        this._validatePreviewableProcessorMaxSize(previewableProcessorMaxSize, this.getSystemPreviewableProcessorMaxSize());
        Group group = this._groupLocalService.getGroup(groupId);
        this._validateMaxNumberOfPages(maxNumberOfPages, this.getCompanyMaxNumberOfPages(group.getCompanyId()));
        this._validatePreviewableProcessorMaxSize(previewableProcessorMaxSize, this.getCompanyPreviewableProcessorMaxSize(group.getCompanyId()));
        this._configurationProvider.saveGroupConfiguration(DLFileEntryConfiguration.class, group.getCompanyId(), groupId, this._createDictionary(maxNumberOfPages, previewableProcessorMaxSize));
    }

    private void _validateMaxNumberOfPages(int maxNumberOfPages, int maxNumberOfPagesLimit) throws Exception {
        if (this._isLimitExceeded(maxNumberOfPagesLimit, maxNumberOfPages, 0L)) {
            throw new DLFileEntryConfigurationException.InvalidMaxNumberOfPagesException();
        }
    }

    private void _validatePreviewableProcessorMaxSize(long previewableProcessorMaxSize, long previewableProcessorMaxSizeLimit) throws Exception {
        if (this._isLimitExceeded(previewableProcessorMaxSizeLimit, previewableProcessorMaxSize, -1L)) {
            throw new DLFileEntryConfigurationException.InvalidPreviewableProcessorMaxSizeException();
        }
    }
}

