/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.change.tracking.spi.resolver;

import com.liferay.change.tracking.spi.resolver.ConstraintResolver;
import com.liferay.change.tracking.spi.resolver.context.ConstraintResolverContext;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import com.liferay.document.library.kernel.store.DLStoreRequest;
import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.document.library.kernel.util.comparator.DLFileVersionVersionComparator;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.change.tracking.sql.CTSQLModeThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.language.LanguageResources;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.UUID;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ConstraintResolver.class})
public class DLFileVersionConstraintResolver
implements ConstraintResolver<DLFileVersion> {
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private DLFileVersionLocalService _dlFileVersionLocalService;

    public String getConflictDescriptionKey() {
        return "duplicate-document-version";
    }

    public Class<DLFileVersion> getModelClass() {
        return DLFileVersion.class;
    }

    public String getResolutionDescriptionKey() {
        return "the-document-version-was-updated-to-latest";
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return LanguageResources.getResourceBundle((Locale)locale);
    }

    public String[] getUniqueIndexColumnNames() {
        return new String[]{"fileEntryId", "version"};
    }

    public void resolveConflict(ConstraintResolverContext<DLFileVersion> constraintResolverContext) throws PortalException {
        DLFileVersion dlFileVersion = (DLFileVersion)constraintResolverContext.getSourceCTModel();
        DLFileVersion latestDLFileVersion = (DLFileVersion)constraintResolverContext.getInTarget(() -> this._dlFileVersionLocalService.getLatestFileVersion(dlFileVersion.getFileEntryId(), true));
        if (Validator.isNull((String)latestDLFileVersion.getVersion())) {
            return;
        }
        List dlFileVersions = null;
        try (SafeCloseable safeCloseable1 = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)dlFileVersion.getCtCollectionId());
             SafeCloseable safeCloseable2 = CTSQLModeThreadLocal.setCTSQLModeWithSafeCloseable((CTSQLModeThreadLocal.CTSQLMode)CTSQLModeThreadLocal.CTSQLMode.CT_ONLY);){
            dlFileVersions = this._dlFileVersionLocalService.getFileVersions(dlFileVersion.getFileEntryId(), -1);
        }
        dlFileVersions.sort(DLFileVersionVersionComparator.getInstance((boolean)true));
        ArrayList<DLFileVersion> newDLFileVersions = new ArrayList<DLFileVersion>();
        HashMap<String, String> versionMap = new HashMap<String, String>();
        String newFileVersion = null;
        String previousFileVersion = null;
        for (DLFileVersion currentDLFileVersion : dlFileVersions) {
            int[] previousVersionParts;
            int versionIncrease;
            if (!constraintResolverContext.isSourceCTModel((CTModel)currentDLFileVersion)) continue;
            int[] ctVersionParts = StringUtil.split((String)currentDLFileVersion.getVersion(), (String)".", (int)0);
            int[] latestVersionParts = StringUtil.split((String)latestDLFileVersion.getVersion(), (String)".", (int)0);
            if (latestVersionParts.length != ctVersionParts.length) {
                return;
            }
            newFileVersion = previousFileVersion == null ? latestVersionParts[0] + "." + (latestVersionParts[1] + 1) : ((versionIncrease = Math.abs(ctVersionParts[0] - (previousVersionParts = StringUtil.split(previousFileVersion, (String)".", (int)0))[0])) > 0 ? latestVersionParts[0] + 1 + ".0" : latestVersionParts[0] + "." + (latestVersionParts[1] + 1));
            previousFileVersion = currentDLFileVersion.getVersion();
            String oldStoreFileName = currentDLFileVersion.getStoreFileName();
            currentDLFileVersion.setVersion(newFileVersion);
            currentDLFileVersion.setStoreUUID(String.valueOf(UUID.randomUUID()));
            newDLFileVersions.add(currentDLFileVersion);
            versionMap.put(currentDLFileVersion.getStoreFileName(), oldStoreFileName);
            latestDLFileVersion = currentDLFileVersion;
        }
        if (newFileVersion == null) {
            return;
        }
        DLFileEntry dlFileEntry = this._dlFileEntryLocalService.getFileEntry(dlFileVersion.getFileEntryId());
        for (int i = newDLFileVersions.size() - 1; i >= 0; --i) {
            DLFileVersion currentDLFileVersion = (DLFileVersion)newDLFileVersions.get(i);
            DLFileVersion updatedDLFileVersion = this._dlFileVersionLocalService.getFileVersion(currentDLFileVersion.getFileVersionId());
            updatedDLFileVersion.setVersion(currentDLFileVersion.getVersion());
            updatedDLFileVersion.setStoreUUID(currentDLFileVersion.getStoreUUID());
            String newStoreFileName = updatedDLFileVersion.getStoreFileName();
            String oldStoreFileName = (String)versionMap.get(newStoreFileName);
            try (InputStream inputStream = DLStoreUtil.getFileAsStream((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)oldStoreFileName);){
                this._dlFileVersionLocalService.updateDLFileVersion(updatedDLFileVersion);
                DLStoreUtil.addFile((DLStoreRequest)DLStoreRequest.builder((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getRepositoryId(), (String)dlFileEntry.getName()).versionLabel(newStoreFileName).build(), (InputStream)inputStream);
            }
            catch (IOException ioException) {
                throw new UncheckedIOException(ioException);
            }
            DLStoreUtil.deleteFile((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getRepositoryId(), (String)dlFileEntry.getName(), (String)oldStoreFileName);
        }
        dlFileEntry.setVersion(newFileVersion);
        this._dlFileEntryLocalService.updateDLFileEntry(dlFileEntry);
    }
}

