/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.security.permission.resource;

import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.model.DLFolderModel;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.exportimport.kernel.staging.permission.StagingPermission;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.BaseModelResourcePermissionWrapper;
import com.liferay.portal.kernel.security.permission.resource.DynamicInheritancePermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.StagedModelPermissionLogic;
import com.liferay.portal.kernel.util.PropsValues;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.document.library.kernel.model.DLFolder"}, service={ModelResourcePermission.class})
public class DLFolderModelResourcePermissionWrapper
extends BaseModelResourcePermissionWrapper<DLFolder> {
    @Reference
    private DLFolderLocalService _dlFolderLocalService;
    @Reference(target="(resource.name=com.liferay.document.library)")
    private PortletResourcePermission _portletResourcePermission;
    @Reference
    private StagingPermission _stagingPermission;

    protected ModelResourcePermission<DLFolder> doGetModelResourcePermission() {
        return ModelResourcePermissionFactory.create(DLFolder.class, DLFolderModel::getFolderId, arg_0 -> ((DLFolderLocalService)this._dlFolderLocalService).getDLFolder(arg_0), (PortletResourcePermission)this._portletResourcePermission, (modelResourcePermission, consumer) -> {
            consumer.accept(new StagedModelPermissionLogic(this._stagingPermission, "com_liferay_document_library_web_portlet_DLPortlet", DLFolderModel::getFolderId));
            if (PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) {
                consumer.accept(new DynamicInheritancePermissionLogic(modelResourcePermission, this._getFetchParentFunction(), false));
            }
        }, actionId -> {
            if (actionId.equals("ADD_FOLDER")) {
                return "ADD_SUBFOLDER";
            }
            return actionId;
        });
    }

    private UnsafeFunction<DLFolder, DLFolder, PortalException> _getFetchParentFunction() {
        return folder -> {
            long folderId = folder.getParentFolderId();
            if (0L == folderId) {
                return null;
            }
            if (folder.isInTrash()) {
                return this._dlFolderLocalService.fetchFolder(folderId);
            }
            return this._dlFolderLocalService.getFolder(folderId);
        };
    }
}

