/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.upgrade.v1_0_0;

import com.liferay.document.library.kernel.store.Store;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class DocumentLibraryUpgradeProcess
extends UpgradeProcess {
    private final Store _store;

    public DocumentLibraryUpgradeProcess(Store store) {
        this._store = store;
    }

    protected void doUpgrade() throws Exception {
        this._deleteChecksumDirectory();
        this._deleteTempDirectory();
    }

    private void _deleteChecksumDirectory() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement = this.connection.prepareStatement("select distinct companyId from DLFileEntry");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long companyId = resultSet.getLong("companyId");
                this._store.deleteDirectory(companyId, 0L, "checksum");
            }
        }
    }

    private void _deleteTempDirectory() {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this._store.deleteDirectory(0L, 0L, "liferay_temp/");
        }
    }
}

