/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.search.spi.model.query.contributor;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService;
import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.search.BaseRelatedEntryIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.RelatedEntryIndexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.asset.AssetSubtypeIdentifier;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import com.liferay.portal.search.spi.model.registrar.ModelSearchSettings;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.document.library.kernel.model.DLFileEntry"}, service={ModelPreFilterContributor.class})
public class DLFileEntryModelPreFilterContributor
implements ModelPreFilterContributor {
    @Reference
    protected DDMIndexer ddmIndexer;
    protected RelatedEntryIndexer relatedEntryIndexer = new BaseRelatedEntryIndexer();
    @Reference(target="(model.pre.filter.contributor.id=WorkflowStatus)")
    protected ModelPreFilterContributor workflowStatusModelPreFilterContributor;
    private static final Log _log = LogFactoryUtil.getLog(DLFileEntryModelPreFilterContributor.class);
    @Reference
    private DLFileEntryTypeLocalService _dlFileEntryTypeLocalService;
    @Reference
    private GroupLocalService _groupLocalService;

    public void contribute(BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings, SearchContext searchContext) {
        this._addAttachmentFilter(booleanFilter, searchContext);
        this._addClassTypeIdsFilter(booleanFilter, searchContext);
        this._addDDMFieldFilter(booleanFilter, searchContext);
        this._addMimeTypesFilter(booleanFilter, searchContext);
        this._addSubtypeFilter(booleanFilter, searchContext);
        this.addHiddenFilter(booleanFilter, searchContext);
        this.addWorkflowStatusFilter(booleanFilter, modelSearchSettings, searchContext);
    }

    protected void addHiddenFilter(BooleanFilter booleanFilter, SearchContext searchContext) {
        if ((ArrayUtil.isEmpty((long[])searchContext.getFolderIds()) || ArrayUtil.contains((long[])searchContext.getFolderIds(), (long)0L)) && !searchContext.isIncludeAttachments()) {
            booleanFilter.addRequiredTerm("hidden", false);
        }
    }

    protected void addWorkflowStatusFilter(BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings, SearchContext searchContext) {
        this.workflowStatusModelPreFilterContributor.contribute(booleanFilter, modelSearchSettings, searchContext);
    }

    private void _addAttachmentFilter(BooleanFilter booleanFilter, SearchContext searchContext) {
        if (!searchContext.isIncludeAttachments()) {
            return;
        }
        try {
            this.relatedEntryIndexer.addRelatedClassNames(booleanFilter, searchContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    private void _addClassTypeIdsFilter(BooleanFilter booleanFilter, SearchContext searchContext) {
        long[] classTypeIds = searchContext.getClassTypeIds();
        if (ArrayUtil.isEmpty((long[])classTypeIds)) {
            return;
        }
        TermsFilter termsFilter = new TermsFilter("classTypeId");
        termsFilter.addValues(ArrayUtil.toStringArray((long[])classTypeIds));
        booleanFilter.add((Filter)termsFilter, BooleanClauseOccur.MUST);
    }

    private void _addDDMFieldFilter(BooleanFilter booleanFilter, SearchContext searchContext) {
        try {
            String ddmStructureFieldName = (String)((Object)searchContext.getAttribute("ddmStructureFieldName"));
            Serializable ddmStructureFieldValue = searchContext.getAttribute("ddmStructureFieldValue");
            if (Validator.isNotNull((String)ddmStructureFieldName) && Validator.isNotNull((Object)ddmStructureFieldValue)) {
                QueryFilter queryFilter = this.ddmIndexer.createFieldValueQueryFilter(ddmStructureFieldName, ddmStructureFieldValue, searchContext.getLocale());
                booleanFilter.add((Filter)queryFilter, BooleanClauseOccur.MUST);
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    private void _addMimeTypesFilter(BooleanFilter booleanFilter, SearchContext searchContext) {
        Object[] mimeTypes = (String[])searchContext.getAttribute("mimeTypes");
        if (ArrayUtil.isNotEmpty((Object[])mimeTypes)) {
            BooleanFilter mimeTypesBooleanFilter = new BooleanFilter();
            for (Object mimeType : mimeTypes) {
                mimeTypesBooleanFilter.addTerm("mimeType", StringUtil.replace((String)mimeType, (char)'/', (char)'_'));
            }
            booleanFilter.add((Filter)mimeTypesBooleanFilter, BooleanClauseOccur.MUST);
        }
    }

    private void _addSubtypeFilter(BooleanFilter booleanFilter, SearchContext searchContext) {
        Map assetSubtypeIdentifiersMap = (Map)((Object)searchContext.getAttribute("assetSubtypeIdentifiersMap"));
        if (assetSubtypeIdentifiersMap == null || !assetSubtypeIdentifiersMap.containsKey(DLFileEntry.class.getName())) {
            return;
        }
        BooleanFilter subtypeBooleanFilter = new BooleanFilter();
        List assetSubtypeIdentifiers = (List)assetSubtypeIdentifiersMap.get(DLFileEntry.class.getName());
        for (AssetSubtypeIdentifier assetSubtypeIdentifier : assetSubtypeIdentifiers) {
            try {
                String groupExternalReferenceCode = assetSubtypeIdentifier.getGroupExternalReferenceCode();
                if (groupExternalReferenceCode.equals("")) {
                    subtypeBooleanFilter.addTerm("fileEntryTypeId", 0);
                    continue;
                }
                Group group = this._groupLocalService.getGroupByExternalReferenceCode(groupExternalReferenceCode, searchContext.getCompanyId());
                DLFileEntryType dlFileEntryType = this._dlFileEntryTypeLocalService.getDLFileEntryTypeByExternalReferenceCode(assetSubtypeIdentifier.getSubtypeExternalReferenceCode(), group.getGroupId());
                subtypeBooleanFilter.addTerm("fileEntryTypeId", dlFileEntryType.getFileEntryTypeId());
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)"Unable to add subtype filter", (Throwable)exception);
            }
        }
        if (subtypeBooleanFilter.hasClauses()) {
            booleanFilter.add((Filter)subtypeBooleanFilter, BooleanClauseOccur.MUST);
        }
    }
}

