/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.change.tracking.conflict;

import com.liferay.change.tracking.conflict.CTEntryConflictHelper;
import com.liferay.change.tracking.model.CTEntry;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.store.DLStore;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CTEntryConflictHelper.class})
public class DLFileEntryCTEntryConflictHelper
implements CTEntryConflictHelper {
    private static final Log _log = LogFactoryUtil.getLog(DLFileEntryCTEntryConflictHelper.class);
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private DLStore _dlStore;
    @Reference
    private Language _language;

    public String getMissingRequirementTypeName(CTEntry ctEntry, long targetCTCollectionId) {
        DLFileEntry dlFileEntry = this._dlFileEntryLocalService.fetchDLFileEntry(ctEntry.getModelClassPK());
        if (dlFileEntry == null || dlFileEntry.getSize() == 0L) {
            return null;
        }
        try {
            DLFileVersion dlFileVersion = dlFileEntry.getFileVersion();
            boolean hasFile = this._dlStore.hasFile(dlFileEntry.getCompanyId(), dlFileEntry.getDataRepositoryId(), dlFileEntry.getName(), dlFileVersion.getStoreFileName());
            if (!hasFile) {
                return "file";
            }
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return "file";
        }
        return null;
    }

    public Class<? extends CTModel<?>> getModelClass() {
        return DLFileEntry.class;
    }
}

