/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.util;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;

public class DDMFormUtil {
    public static DDMForm buildDDMForm(Set<String> fieldNames, Locale locale) {
        DDMForm ddmForm = new DDMForm();
        ddmForm.setAvailableLocales(Collections.singleton(locale));
        ddmForm.setDefaultLocale(locale);
        ArrayList<DDMFormField> ddmFormFields = new ArrayList<DDMFormField>();
        for (String name : fieldNames) {
            DDMFormField ddmFormField = new DDMFormField(name, "text");
            ddmFormField.setDataType("string");
            ddmFormField.setIndexType("text");
            ddmFormField.setLocalizable(false);
            ddmFormField.setMultiple(false);
            ddmFormField.setReadOnly(false);
            ddmFormField.setRepeatable(false);
            ddmFormField.setRequired(false);
            ddmFormField.setShowLabel(true);
            LocalizedValue label = ddmFormField.getLabel();
            label.addString(locale, "metadata.".concat(StringUtil.replaceFirst((String)name, (char)'_', (char)'.')));
            label.setDefaultLocale(locale);
            LocalizedValue predefinedValue = ddmFormField.getPredefinedValue();
            predefinedValue.addString(locale, "");
            predefinedValue.setDefaultLocale(locale);
            LocalizedValue style = ddmFormField.getStyle();
            style.setDefaultLocale(locale);
            LocalizedValue tip = ddmFormField.getTip();
            tip.setDefaultLocale(locale);
            DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
            ddmFormFieldOptions.setDefaultLocale(locale);
            ddmFormFields.add(ddmFormField);
        }
        ddmForm.setDDMFormFields(ddmFormFields);
        return ddmForm;
    }
}

