/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.service;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.service.DLAppServiceWrapper;
import com.liferay.document.library.kernel.service.DLFileEntryMetadataLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryService;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService;
import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import com.liferay.document.library.util.DLFileEntryTypeUtil;
import com.liferay.dynamic.data.mapping.kernel.DDMFormValues;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.storage.DDMStorageEngineManager;
import com.liferay.dynamic.data.mapping.util.DDMBeanTranslator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceWrapper;
import java.io.Serializable;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ServiceWrapper.class})
public class FileEntryTypeDLAppServiceWrapper
extends DLAppServiceWrapper {
    @Reference
    private DDMBeanTranslator _ddmBeanTranslator;
    @Reference
    private DDMStorageEngineManager _ddmStorageEngineManager;
    @Reference
    private DLFileEntryMetadataLocalService _dlFileEntryMetadataLocalService;
    @Reference
    private DLFileEntryService _dlFileEntryService;
    @Reference
    private DLFileEntryTypeLocalService _dlFileEntryTypeLocalService;
    @Reference
    private DLFileVersionLocalService _dlFileVersionLocalService;

    public FileEntry copyFileEntry(long fileEntryId, long destinationFolderId, long destinationRepositoryId, long fileEntryTypeId, long[] groupIds, ServiceContext serviceContext) throws PortalException {
        this._populateServiceContext(serviceContext, fileEntryId);
        return super.copyFileEntry(fileEntryId, destinationFolderId, destinationRepositoryId, fileEntryTypeId, groupIds, serviceContext);
    }

    public FileEntry moveFileEntry(long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        this._populateServiceContext(serviceContext, fileEntryId);
        return super.moveFileEntry(fileEntryId, newFolderId, serviceContext);
    }

    private void _populateServiceContext(ServiceContext serviceContext, long fileEntryId) throws PortalException {
        DLFileEntry dlFileEntry = this._dlFileEntryService.getFileEntry(fileEntryId);
        long fileEntryTypeId = dlFileEntry.getFileEntryTypeId();
        if (fileEntryTypeId == 0L) {
            return;
        }
        DLFileEntryType dlFileEntryType = this._dlFileEntryTypeLocalService.getFileEntryType(fileEntryTypeId);
        serviceContext.setAttribute("fileEntryTypeId", (Serializable)Long.valueOf(fileEntryTypeId));
        DLFileVersion dlFileVersion = this._dlFileVersionLocalService.getLatestFileVersion(dlFileEntry.getFileEntryId(), !dlFileEntry.isCheckedOut());
        List ddmStructures = DLFileEntryTypeUtil.getDDMStructures((DLFileEntryType)dlFileEntryType);
        for (DDMStructure ddmStructure : ddmStructures) {
            DLFileEntryMetadata dlFileEntryMetadata = this._dlFileEntryMetadataLocalService.fetchFileEntryMetadata(ddmStructure.getStructureId(), dlFileVersion.getFileVersionId());
            if (dlFileEntryMetadata == null) continue;
            serviceContext.setAttribute(DDMFormValues.class.getName() + "#" + ddmStructure.getStructureId(), (Serializable)this._ddmBeanTranslator.translate(this._ddmStorageEngineManager.getDDMFormValues(dlFileEntryMetadata.getDDMStorageId())));
        }
    }
}

