/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.messaging;

import com.liferay.document.library.kernel.processor.RawMetadataProcessorUtil;
import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.MapUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"destination.name=liferay/document_library_raw_metadata_processor"}, service={MessageListener.class})
public class RawMetadataProcessorMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(RawMetadataProcessorMessageListener.class);
    @Reference
    private DestinationFactory _destinationFactory;
    private ServiceRegistration<Destination> _serviceRegistration;

    @Activate
    protected void activate(BundleContext bundleContext) {
        Destination destination = this._destinationFactory.createDestination(new DestinationConfiguration("serial", "liferay/document_library_raw_metadata_processor"));
        this._serviceRegistration = bundleContext.registerService(Destination.class, (Object)destination, MapUtil.singletonDictionary((Object)"destination.name", (Object)destination.getName()));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }

    protected void doReceive(Message message) throws Exception {
        block3: {
            if (StartupHelperUtil.isUpgrading()) {
                return;
            }
            FileVersion fileVersion = (FileVersion)message.getPayload();
            try {
                RawMetadataProcessorUtil.saveMetadata((FileVersion)fileVersion);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)("Unable to save metadata for file version " + fileVersion.getFileVersionId()), (Throwable)exception);
            }
        }
    }
}

