/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.verify;

import com.liferay.document.library.internal.util.DDMFormUtil;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.processor.RawMetadataProcessor;
import com.liferay.document.library.kernel.service.DLAppHelperLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryMetadataLocalService;
import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.metadata.RawMetadataProcessorUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portal.verify.VerifyProcess;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={VerifyProcess.class})
public class DLServiceVerifyProcess
extends VerifyProcess {
    private static final String _MS_OFFICE_2010_TEXT_XML_UTF8 = "text/xml; charset=\"utf-8\"";
    private static final Log _log = LogFactoryUtil.getLog(DLServiceVerifyProcess.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private DLAppHelperLocalService _dlAppHelperLocalService;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private DLFileEntryMetadataLocalService _dlFileEntryMetadataLocalService;
    @Reference
    private DLFileVersionLocalService _dlFileVersionLocalService;
    @Reference
    private DLFolderLocalService _dlFolderLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference(target="(ddm.form.serializer.type=json)")
    private DDMFormSerializer _jsonDDMFormSerializer;
    @Reference
    private Portal _portal;
    @Reference(target="(&(release.bundle.symbolic.name=com.liferay.document.library.service)(&(release.schema.version>=3.0.0)(!(release.schema.version>=4.0.0))))")
    private Release _release;
    @Reference
    private Staging _staging;

    protected void doVerify() throws Exception {
        this._checkDLFileEntryMetadata();
        this._checkDDMStructureDefinition();
        this._checkMimeTypes();
        this._updateClassNameId();
        this._updateFileEntryAssets();
        this._updateFolderAssets();
        if (FeatureFlagManagerUtil.isEnabled((String)"LPS-157670")) {
            this.updateStagedPortletNames();
        }
    }

    protected void updateStagedPortletNames() throws PortalException {
        ActionableDynamicQuery groupActionableDynamicQuery = this._groupLocalService.getActionableDynamicQuery();
        groupActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property siteProperty = PropertyFactoryUtil.forName((String)"site");
            dynamicQuery.add(siteProperty.eq((Object)Boolean.TRUE));
        });
        groupActionableDynamicQuery.setPerformActionMethod(group -> {
            UnicodeProperties typeSettingsUnicodeProperties = group.getTypeSettingsProperties();
            if (typeSettingsUnicodeProperties == null) {
                return;
            }
            String propertyKey = this._staging.getStagedPortletId("com_liferay_document_library_web_portlet_DLPortlet");
            String propertyValue = typeSettingsUnicodeProperties.getProperty(propertyKey);
            if (Validator.isNull((String)propertyValue)) {
                return;
            }
            typeSettingsUnicodeProperties.remove((Object)propertyKey);
            propertyKey = this._staging.getStagedPortletId("com_liferay_document_library_web_portlet_DLAdminPortlet");
            typeSettingsUnicodeProperties.put(propertyKey, propertyValue);
            group.setTypeSettingsProperties(typeSettingsUnicodeProperties);
            this._groupLocalService.updateGroup(group);
        });
        groupActionableDynamicQuery.performActions();
    }

    private void _checkDDMStructureDefinition() throws Exception {
        this._companyLocalService.forEachCompanyId(companyId -> {
            DDMForm ddmForm;
            String definition;
            Group group = this._groupLocalService.getCompanyGroup(companyId.longValue());
            String name = "TIKARAWMETADATA";
            DDMStructure ddmStructure = this._ddmStructureLocalService.fetchStructure(group.getGroupId(), this._portal.getClassNameId(RawMetadataProcessor.class), name);
            if (ddmStructure != null && !(definition = this._serializeJSONDDMForm(ddmForm = DDMFormUtil.buildDDMForm(RawMetadataProcessorUtil.getFieldNames(), this._portal.getSiteDefaultLocale(group.getGroupId())))).equals(ddmStructure.getDefinition())) {
                ddmStructure.setDDMForm(ddmForm);
                this._ddmStructureLocalService.updateDDMStructure(ddmStructure);
            }
        });
    }

    private void _checkDLFileEntryMetadata() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List mismatchedCompanyIdDLFileEntryMetadatas = this._dlFileEntryMetadataLocalService.getMismatchedCompanyIdFileEntryMetadatas();
            if (_log.isDebugEnabled()) {
                int size = mismatchedCompanyIdDLFileEntryMetadatas.size();
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Deleting ", size, " file entry metadatas with mismatched company IDs"}));
            }
            for (DLFileEntryMetadata dlFileEntryMetadata : mismatchedCompanyIdDLFileEntryMetadatas) {
                this._deleteUnusedDLFileEntryMetadata(dlFileEntryMetadata);
            }
            List noStructuresDLFileEntryMetadatas = this._dlFileEntryMetadataLocalService.getNoStructuresFileEntryMetadatas();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Deleting " + noStructuresDLFileEntryMetadatas.size() + " file entry metadatas with no structures"));
            }
            for (DLFileEntryMetadata dlFileEntryMetadata : noStructuresDLFileEntryMetadatas) {
                this._deleteUnusedDLFileEntryMetadata(dlFileEntryMetadata);
            }
        }
    }

    private void _checkFileVersionMimeTypes(String[] originalMimeTypes) throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = this._dlFileVersionLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Criterion criterion = RestrictionsFactoryUtil.eq((String)"mimeType", (Object)originalMimeTypes[0]);
            for (int i = 1; i < originalMimeTypes.length; ++i) {
                criterion = RestrictionsFactoryUtil.or((Criterion)criterion, (Criterion)RestrictionsFactoryUtil.eq((String)"mimeType", (Object)originalMimeTypes[i]));
            }
            dynamicQuery.add(criterion);
        });
        actionableDynamicQuery.setPerformActionMethod(dlFileVersion -> {
            block15: {
                String title = DLUtil.getTitleWithExtension((String)dlFileVersion.getTitle(), (String)dlFileVersion.getExtension());
                try (InputStream inputStream = this._dlFileEntryLocalService.getFileAsStream(dlFileVersion.getFileEntryId(), dlFileVersion.getVersion(), false);){
                    String mimeType = MimeTypesUtil.getContentType((InputStream)inputStream, (String)title);
                    if (mimeType.equals(dlFileVersion.getMimeType())) {
                        return;
                    }
                    dlFileVersion.setMimeType(mimeType);
                    dlFileVersion = this._dlFileVersionLocalService.updateDLFileVersion(dlFileVersion);
                    try {
                        DLFileEntry dlFileEntry = dlFileVersion.getFileEntry();
                        if (Objects.equals(dlFileEntry.getVersion(), dlFileVersion.getVersion())) {
                            dlFileEntry.setMimeType(mimeType);
                            this._dlFileEntryLocalService.updateDLFileEntry(dlFileEntry);
                        }
                    }
                    catch (PortalException portalException) {
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)("Unable to get file entry " + dlFileVersion.getFileEntryId()), (Throwable)portalException);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block15;
                    DLFileEntry dlFileEntry = this._dlFileEntryLocalService.fetchDLFileEntry(dlFileVersion.getFileEntryId());
                    if (dlFileEntry == null) {
                        _log.warn((Object)("Unable to find file entry associated with file version " + dlFileVersion.getFileVersionId()), (Throwable)exception);
                    }
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to find file version ", dlFileVersion.getVersion(), " for file entry ", dlFileEntry.getName()}), (Throwable)exception);
                }
            }
        });
        if (_log.isDebugEnabled()) {
            long count = actionableDynamicQuery.performCount();
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Processing ", count, " file versions with mime types: ", StringUtil.merge((Object[])originalMimeTypes, (String)",")}));
        }
        actionableDynamicQuery.performActions();
    }

    private void _checkMimeTypes() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this._checkFileVersionMimeTypes(new String[]{"application/octet-stream", _MS_OFFICE_2010_TEXT_XML_UTF8});
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Fixed file entries with invalid mime types");
            }
        }
    }

    private void _deleteUnusedDLFileEntryMetadata(DLFileEntryMetadata dlFileEntryMetadata) throws Exception {
        this._dlFileEntryMetadataLocalService.deleteFileEntryMetadata(dlFileEntryMetadata);
    }

    private String _serializeJSONDDMForm(DDMForm ddmForm) {
        DDMFormSerializerSerializeRequest.Builder builder = DDMFormSerializerSerializeRequest.Builder.newBuilder((DDMForm)ddmForm);
        DDMFormSerializerSerializeResponse ddmFormSerializerSerializeResponse = this._jsonDDMFormSerializer.serialize(builder.build());
        return ddmFormSerializerSerializeResponse.getContent();
    }

    private void _updateClassNameId() {
        block7: {
            try (LoggingTimer loggingTimer = new LoggingTimer();){
                this.runSQL("update DLFileEntry set classNameId = 0 where classNameId is null");
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block7;
                _log.warn((Object)"Unable to fix file entries where class name ID is null", (Throwable)exception);
            }
        }
    }

    private void _updateFileEntryAssets() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List dlFileEntries = this._dlFileEntryLocalService.getNoAssetFileEntries();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Processing " + dlFileEntries.size() + " file entries with no asset"));
            }
            for (DLFileEntry dlFileEntry : dlFileEntries) {
                LiferayFileEntry fileEntry = new LiferayFileEntry(dlFileEntry);
                LiferayFileVersion fileVersion = new LiferayFileVersion(dlFileEntry.getFileVersion());
                try {
                    this._dlAppHelperLocalService.updateAsset(dlFileEntry.getUserId(), (FileEntry)fileEntry, (FileVersion)fileVersion, new ServiceContext());
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to update asset for file entry ", dlFileEntry.getFileEntryId(), ": ", exception.getMessage()}));
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Assets verified for file entries");
            }
        }
    }

    private void _updateFolderAssets() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List dlFolders = this._dlFolderLocalService.getNoAssetFolders();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Processing " + dlFolders.size() + " folders with no asset"));
            }
            for (DLFolder dlFolder : dlFolders) {
                LiferayFolder folder = new LiferayFolder(dlFolder);
                try {
                    this._dlAppHelperLocalService.updateAsset(dlFolder.getUserId(), (Folder)folder, null, null, null);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to update asset for folder ", dlFolder.getFolderId(), ": ", exception.getMessage()}));
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Assets verified for folders");
            }
        }
    }
}

