/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.bulk.selection;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.bulk.selection.BaseMultipleEntryBulkSelection;
import com.liferay.bulk.selection.BulkSelection;
import com.liferay.bulk.selection.BulkSelectionFactory;
import com.liferay.document.library.internal.bulk.selection.FileEntryAssetEntryBulkSelection;
import com.liferay.document.library.internal.bulk.selection.FileEntryBulkSelectionFactory;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.util.DLAssetHelper;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import java.util.Map;

public class MultipleFileEntryBulkSelection
extends BaseMultipleEntryBulkSelection<FileEntry> {
    private static final Log _log = LogFactoryUtil.getLog(MultipleFileEntryBulkSelection.class);
    private final AssetEntryLocalService _assetEntryLocalService;
    private final DLAppService _dlAppService;
    private final DLAssetHelper _dlAssetHelper;

    public MultipleFileEntryBulkSelection(long[] fileEntryIds, Map<String, String[]> parameterMap, DLAppService dlAppService, AssetEntryLocalService assetEntryLocalService, DLAssetHelper dlAssetHelper) {
        super(fileEntryIds, parameterMap);
        this._dlAppService = dlAppService;
        this._assetEntryLocalService = assetEntryLocalService;
        this._dlAssetHelper = dlAssetHelper;
    }

    public Class<? extends BulkSelectionFactory> getBulkSelectionFactoryClass() {
        return FileEntryBulkSelectionFactory.class;
    }

    public BulkSelection<AssetEntry> toAssetEntryBulkSelection() {
        return new FileEntryAssetEntryBulkSelection((BulkSelection<FileEntry>)this, this._assetEntryLocalService, this._dlAssetHelper);
    }

    protected FileEntry fetchEntry(long fileEntryId) {
        try {
            return this._dlAppService.getFileEntry(fileEntryId);
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)noSuchFileEntryException);
            }
            return null;
        }
        catch (PortalException portalException) {
            return (FileEntry)ReflectionUtil.throwException((Throwable)portalException);
        }
    }
}

