/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.configuration.admin.service;

import com.liferay.document.library.internal.configuration.DLFileOrderConfiguration;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.document.library.internal.configuration.DLFileOrderConfiguration"}, property={"service.pid=com.liferay.document.library.internal.configuration.DLFileOrderConfiguration.scoped"}, service={ManagedServiceFactory.class})
public class DLFileOrderManagedServiceFactory
implements ManagedServiceFactory {
    private final Map<Long, DLFileOrderConfiguration> _companyDLFileOrderConfigurations = new ConcurrentHashMap<Long, DLFileOrderConfiguration>();
    private final Map<String, Long> _companyIds = new ConcurrentHashMap<String, Long>();
    private final Map<Long, DLFileOrderConfiguration> _groupDLFileOrderConfigurations = new ConcurrentHashMap<Long, DLFileOrderConfiguration>();
    private final Map<String, Long> _groupIds = new ConcurrentHashMap<String, Long>();
    @Reference
    private GroupLocalService _groupLocalService;
    private volatile DLFileOrderConfiguration _systemDLFileOrderConfiguration;

    public void deleted(String pid) {
        this._unmapPid(pid);
    }

    public String getCompanyOrderByColumn(long companyId) {
        DLFileOrderConfiguration dlFileOrderConfiguration = this._getCompanyDLFileOrderConfiguration(companyId);
        return dlFileOrderConfiguration.orderByColumn();
    }

    public String getCompanySortBy(long companyId) {
        DLFileOrderConfiguration dlFileOrderConfiguration = this._getCompanyDLFileOrderConfiguration(companyId);
        return dlFileOrderConfiguration.sortBy();
    }

    public String getGroupOrderByColumn(long groupId) {
        DLFileOrderConfiguration dlFileOrderConfiguration = this._getGroupDLFileOrderConfiguration(groupId);
        return dlFileOrderConfiguration.orderByColumn();
    }

    public String getGroupSortBy(long groupId) {
        DLFileOrderConfiguration dlFileOrderConfiguration = this._getGroupDLFileOrderConfiguration(groupId);
        return dlFileOrderConfiguration.sortBy();
    }

    public String getName() {
        return "com.liferay.document.library.internal.configuration.DLFileOrderConfiguration.scoped";
    }

    public String getSystemOrderByColumn() {
        return this._systemDLFileOrderConfiguration.orderByColumn();
    }

    public String getSystemSortBy() {
        return this._systemDLFileOrderConfiguration.sortBy();
    }

    public void updated(String pid, Dictionary<String, ?> dictionary) throws ConfigurationException {
        long groupId;
        this._unmapPid(pid);
        long companyId = GetterUtil.getLong(dictionary.get("companyId"), (long)0L);
        if (companyId != 0L) {
            this._updateCompanyConfiguration(companyId, pid, dictionary);
        }
        if ((groupId = GetterUtil.getLong(dictionary.get("groupId"), (long)0L)) != 0L) {
            this._updateGroupConfiguration(groupId, pid, dictionary);
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._systemDLFileOrderConfiguration = (DLFileOrderConfiguration)ConfigurableUtil.createConfigurable(DLFileOrderConfiguration.class, properties);
    }

    private DLFileOrderConfiguration _getCompanyDLFileOrderConfiguration(long companyId) {
        return this._getDLFileOrderConfiguration(this._companyDLFileOrderConfigurations, companyId, () -> this._systemDLFileOrderConfiguration);
    }

    private DLFileOrderConfiguration _getDLFileOrderConfiguration(Map<Long, DLFileOrderConfiguration> dlFileOrderConfigurations, long key, Supplier<DLFileOrderConfiguration> supplier) {
        if (dlFileOrderConfigurations.containsKey(key)) {
            return dlFileOrderConfigurations.get(key);
        }
        return supplier.get();
    }

    private DLFileOrderConfiguration _getGroupDLFileOrderConfiguration(long groupId) {
        return this._getDLFileOrderConfiguration(this._groupDLFileOrderConfigurations, groupId, () -> {
            Group group = this._groupLocalService.fetchGroup(groupId);
            long companyId = CompanyThreadLocal.getCompanyId();
            if (group != null) {
                companyId = group.getCompanyId();
            }
            return this._getCompanyDLFileOrderConfiguration(companyId);
        });
    }

    private void _unmapPid(String pid) {
        if (this._companyIds.containsKey(pid)) {
            long companyId = this._companyIds.remove(pid);
            this._companyDLFileOrderConfigurations.remove(companyId);
            this._groupDLFileOrderConfigurations.clear();
            this._groupIds.clear();
        } else if (this._groupIds.containsKey(pid)) {
            long groupId = this._groupIds.remove(pid);
            this._groupDLFileOrderConfigurations.remove(groupId);
        }
    }

    private void _updateCompanyConfiguration(long companyId, String pid, Dictionary<String, ?> dictionary) {
        this._companyDLFileOrderConfigurations.put(companyId, (DLFileOrderConfiguration)ConfigurableUtil.createConfigurable(DLFileOrderConfiguration.class, dictionary));
        this._companyIds.put(pid, companyId);
    }

    private void _updateGroupConfiguration(long groupId, String pid, Dictionary<String, ?> dictionary) {
        this._groupDLFileOrderConfigurations.put(groupId, (DLFileOrderConfiguration)ConfigurableUtil.createConfigurable(DLFileOrderConfiguration.class, dictionary));
        this._groupIds.put(pid, groupId);
    }
}

