/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.util;

import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.processor.DLProcessor;
import com.liferay.document.library.kernel.processor.RawMetadataProcessor;
import com.liferay.document.library.kernel.service.DLFileEntryMetadataLocalService;
import com.liferay.dynamic.data.mapping.kernel.DDMStructureManager;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.metadata.RawMetadataProcessorUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"type=RawMetadataProcessor"}, service={DLProcessor.class})
public class RawMetadataProcessorImpl
implements DLProcessor,
RawMetadataProcessor {
    private static final Log _log = LogFactoryUtil.getLog(RawMetadataProcessorImpl.class);
    private static final Set<String> _dlFileEntryRawMetadataProcesorExcludedMimeTypes = new HashSet<String>(Arrays.asList(PropsValues.DL_FILE_ENTRY_RAW_METADATA_PROCESSOR_EXCLUDED_MIME_TYPES));
    @Reference
    private DDMStructureManager _ddmStructureManager;
    @Reference
    private DLFileEntryMetadataLocalService _dlFileEntryMetadataLocalService;
    @Reference
    private Portal _portal;

    public void cleanUp(FileEntry fileEntry) {
    }

    public void cleanUp(FileVersion fileVersion) {
    }

    public void copy(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
    }

    public void exportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) {
    }

    public void generateMetadata(FileVersion fileVersion) {
        long fileEntryMetadataCount = this._dlFileEntryMetadataLocalService.getFileVersionFileEntryMetadatasCount(fileVersion.getFileVersionId());
        if (fileEntryMetadataCount == 0L) {
            this.trigger(fileVersion);
        }
    }

    public String getType() {
        return "RawMetadataProcessor";
    }

    public void importGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) {
    }

    public boolean isSupported(FileVersion fileVersion) {
        return this.isSupported(fileVersion.getMimeType());
    }

    public boolean isSupported(String mimeType) {
        return !_dlFileEntryRawMetadataProcesorExcludedMimeTypes.contains(mimeType);
    }

    public void saveMetadata(FileVersion fileVersion) throws PortalException {
        Map rawMetadataMap;
        block18: {
            rawMetadataMap = null;
            try (InputStream inputStream = fileVersion.getContentStream(false);){
                if (inputStream == null) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("No metadata is available for file version " + fileVersion.getFileVersionId()));
                    }
                    return;
                }
                rawMetadataMap = RawMetadataProcessorUtil.getRawMetadataMap((String)fileVersion.getMimeType(), (InputStream)inputStream);
            }
            catch (IOException ioException) {
                if (!_log.isWarnEnabled()) break block18;
                _log.warn((Throwable)ioException);
            }
        }
        try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)fileVersion.getCtCollectionId());){
            Indexer indexer;
            List ddmStructures = this._ddmStructureManager.getClassStructures(fileVersion.getCompanyId(), this._portal.getClassNameId(RawMetadataProcessor.class));
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setScopeGroupId(fileVersion.getGroupId());
            serviceContext.setUserId(fileVersion.getUserId());
            this._dlFileEntryMetadataLocalService.updateFileEntryMetadata(null, fileVersion.getCompanyId(), ddmStructures, fileVersion.getFileEntryId(), fileVersion.getFileVersionId(), rawMetadataMap, serviceContext);
            FileEntry fileEntry = fileVersion.getFileEntry();
            if (fileEntry instanceof LiferayFileEntry && (indexer = IndexerRegistryUtil.getIndexer((String)DLFileEntryConstants.getClassName())) != null) {
                LiferayFileEntry liferayFileEntry = (LiferayFileEntry)fileEntry;
                indexer.reindex((Object)liferayFileEntry.getDLFileEntry());
            }
        }
    }

    public void trigger(FileVersion fileVersion) {
        this.trigger(fileVersion, fileVersion);
    }

    public void trigger(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        MessageBusUtil.sendMessage((String)"liferay/document_library_raw_metadata_processor", (Object)destinationFileVersion);
    }
}

