/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.bulk.selection;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.bulk.selection.BaseSingleEntryBulkSelection;
import com.liferay.bulk.selection.BulkSelection;
import com.liferay.bulk.selection.BulkSelectionFactory;
import com.liferay.document.library.internal.bulk.selection.FileEntryAssetEntryBulkSelection;
import com.liferay.document.library.internal.bulk.selection.FileEntryBulkSelectionFactory;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.util.DLAssetHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import java.util.Map;

public class SingleFileEntryBulkSelection
extends BaseSingleEntryBulkSelection<FileEntry> {
    private final AssetEntryLocalService _assetEntryLocalService;
    private final DLAppService _dlAppService;
    private final DLAssetHelper _dlAssetHelper;
    private final long _fileEntryId;

    public SingleFileEntryBulkSelection(long fileEntryId, Map<String, String[]> parameterMap, DLAppService dlAppService, AssetEntryLocalService assetEntryLocalService, DLAssetHelper dlAssetHelper) {
        super(fileEntryId, parameterMap);
        this._fileEntryId = fileEntryId;
        this._dlAppService = dlAppService;
        this._assetEntryLocalService = assetEntryLocalService;
        this._dlAssetHelper = dlAssetHelper;
    }

    public Class<? extends BulkSelectionFactory> getBulkSelectionFactoryClass() {
        return FileEntryBulkSelectionFactory.class;
    }

    public BulkSelection<AssetEntry> toAssetEntryBulkSelection() {
        return new FileEntryAssetEntryBulkSelection((BulkSelection<FileEntry>)this, this._assetEntryLocalService, this._dlAssetHelper);
    }

    protected FileEntry getEntry() throws PortalException {
        return this._dlAppService.getFileEntry(this._fileEntryId);
    }

    protected String getEntryName() throws PortalException {
        FileEntry fileEntry = this.getEntry();
        return fileEntry.getTitle();
    }
}

