/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.upgrade.v3_2_9;

import com.liferay.document.library.configuration.DLFileEntryConfiguration;
import com.liferay.document.library.internal.upgrade.helper.DLConfigurationUpgradeHelper;
import com.liferay.portal.configuration.upgrade.PrefsPropsToConfigurationUpgradeHelper;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.KeyValuePair;

public class DLFileEntryConfigurationUpgradeProcess
extends UpgradeProcess {
    private final DLConfigurationUpgradeHelper _dlConfigurationUpgradeHelper;
    private final PrefsPropsToConfigurationUpgradeHelper _prefsPropsToConfigurationUpgradeHelper;

    public DLFileEntryConfigurationUpgradeProcess(DLConfigurationUpgradeHelper dlConfigurationUpgradeHelper, PrefsPropsToConfigurationUpgradeHelper prefsPropsToConfigurationUpgradeHelper) {
        this._dlConfigurationUpgradeHelper = dlConfigurationUpgradeHelper;
        this._prefsPropsToConfigurationUpgradeHelper = prefsPropsToConfigurationUpgradeHelper;
    }

    protected void doUpgrade() throws Exception {
        if (!(this._dlConfigurationUpgradeHelper.hasLegacyProps() && this._dlConfigurationUpgradeHelper.hasDLSizeLimitConfigurationChanges() && this._dlConfigurationUpgradeHelper.hasDLFileEntryConfigurationChanges())) {
            return;
        }
        this._upgradeConfiguration();
    }

    private void _upgradeConfiguration() throws Exception {
        this._prefsPropsToConfigurationUpgradeHelper.mapConfigurations(DLFileEntryConfiguration.class, new KeyValuePair[]{new KeyValuePair("dl.file.entry.previewable.processor.max.size", "previewableProcessorMaxSize")});
        long systemPreviewableProcessorMaxSize = this._dlConfigurationUpgradeHelper.getDLFileEntryConfigurationPreviewableProcessorMaxSize();
        this._dlConfigurationUpgradeHelper.updateDLFileEntryConfigurationSystemConfiguration(systemPreviewableProcessorMaxSize);
        this._dlConfigurationUpgradeHelper.updateScopedConfigurations(systemPreviewableProcessorMaxSize);
        this._dlConfigurationUpgradeHelper.deleteConfigurations("com.liferay.document.library.preview.pdf.internal.configuration.PDFPreviewConfiguration");
    }
}

