/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.document.library.model.impl;

import com.liferay.document.library.model.DLStorageQuota;
import com.liferay.document.library.model.DLStorageQuotaModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the DLStorageQuota service. Represents a row in the &quot;DLStorageQuota&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>DLStorageQuotaModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link DLStorageQuotaImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DLStorageQuotaImpl
 * @generated
 */
public class DLStorageQuotaModelImpl
	extends BaseModelImpl<DLStorageQuota> implements DLStorageQuotaModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a dl storage quota model instance should use the <code>DLStorageQuota</code> interface instead.
	 */
	public static final String TABLE_NAME = "DLStorageQuota";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"dlStorageQuotaId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"storageSize", Types.BIGINT}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("dlStorageQuotaId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("storageSize", Types.BIGINT);
	}

	public static final String TABLE_SQL_CREATE =
		"create table DLStorageQuota (mvccVersion LONG default 0 not null,dlStorageQuotaId LONG not null primary key,companyId LONG,storageSize LONG)";

	public static final String TABLE_SQL_DROP = "drop table DLStorageQuota";

	public static final String ORDER_BY_JPQL =
		" ORDER BY dlStorageQuota.dlStorageQuotaId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY DLStorageQuota.dlStorageQuotaId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long DLSTORAGEQUOTAID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public DLStorageQuotaModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _dlStorageQuotaId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setDlStorageQuotaId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _dlStorageQuotaId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return DLStorageQuota.class;
	}

	@Override
	public String getModelClassName() {
		return DLStorageQuota.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<DLStorageQuota, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<DLStorageQuota, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DLStorageQuota, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((DLStorageQuota)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<DLStorageQuota, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<DLStorageQuota, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(DLStorageQuota)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<DLStorageQuota, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<DLStorageQuota, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<DLStorageQuota, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<DLStorageQuota, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String, Function<DLStorageQuota, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", DLStorageQuota::getMvccVersion);
			attributeGetterFunctions.put(
				"dlStorageQuotaId", DLStorageQuota::getDlStorageQuotaId);
			attributeGetterFunctions.put(
				"companyId", DLStorageQuota::getCompanyId);
			attributeGetterFunctions.put(
				"storageSize", DLStorageQuota::getStorageSize);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<DLStorageQuota, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<DLStorageQuota, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap<String, BiConsumer<DLStorageQuota, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<DLStorageQuota, Long>)
					DLStorageQuota::setMvccVersion);
			attributeSetterBiConsumers.put(
				"dlStorageQuotaId",
				(BiConsumer<DLStorageQuota, Long>)
					DLStorageQuota::setDlStorageQuotaId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<DLStorageQuota, Long>)DLStorageQuota::setCompanyId);
			attributeSetterBiConsumers.put(
				"storageSize",
				(BiConsumer<DLStorageQuota, Long>)
					DLStorageQuota::setStorageSize);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public long getDlStorageQuotaId() {
		return _dlStorageQuotaId;
	}

	@Override
	public void setDlStorageQuotaId(long dlStorageQuotaId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_dlStorageQuotaId = dlStorageQuotaId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@Override
	public long getStorageSize() {
		return _storageSize;
	}

	@Override
	public void setStorageSize(long storageSize) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_storageSize = storageSize;
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), DLStorageQuota.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public DLStorageQuota toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, DLStorageQuota>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		DLStorageQuotaImpl dlStorageQuotaImpl = new DLStorageQuotaImpl();

		dlStorageQuotaImpl.setMvccVersion(getMvccVersion());
		dlStorageQuotaImpl.setDlStorageQuotaId(getDlStorageQuotaId());
		dlStorageQuotaImpl.setCompanyId(getCompanyId());
		dlStorageQuotaImpl.setStorageSize(getStorageSize());

		dlStorageQuotaImpl.resetOriginalValues();

		return dlStorageQuotaImpl;
	}

	@Override
	public DLStorageQuota cloneWithOriginalValues() {
		DLStorageQuotaImpl dlStorageQuotaImpl = new DLStorageQuotaImpl();

		dlStorageQuotaImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		dlStorageQuotaImpl.setDlStorageQuotaId(
			this.<Long>getColumnOriginalValue("dlStorageQuotaId"));
		dlStorageQuotaImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		dlStorageQuotaImpl.setStorageSize(
			this.<Long>getColumnOriginalValue("storageSize"));

		return dlStorageQuotaImpl;
	}

	@Override
	public int compareTo(DLStorageQuota dlStorageQuota) {
		long primaryKey = dlStorageQuota.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof DLStorageQuota)) {
			return false;
		}

		DLStorageQuota dlStorageQuota = (DLStorageQuota)object;

		long primaryKey = dlStorageQuota.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<DLStorageQuota> toCacheModel() {
		DLStorageQuotaCacheModel dlStorageQuotaCacheModel =
			new DLStorageQuotaCacheModel();

		dlStorageQuotaCacheModel.mvccVersion = getMvccVersion();

		dlStorageQuotaCacheModel.dlStorageQuotaId = getDlStorageQuotaId();

		dlStorageQuotaCacheModel.companyId = getCompanyId();

		dlStorageQuotaCacheModel.storageSize = getStorageSize();

		return dlStorageQuotaCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<DLStorageQuota, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<DLStorageQuota, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DLStorageQuota, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((DLStorageQuota)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, DLStorageQuota>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					DLStorageQuota.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _dlStorageQuotaId;
	private long _companyId;
	private long _storageSize;

	public <T> T getColumnValue(String columnName) {
		Function<DLStorageQuota, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((DLStorageQuota)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("dlStorageQuotaId", _dlStorageQuotaId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("storageSize", _storageSize);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("dlStorageQuotaId", 2L);

		columnBitmasks.put("companyId", 4L);

		columnBitmasks.put("storageSize", 8L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private DLStorageQuota _escapedModel;

}