/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.document.library.model.impl;

import com.liferay.document.library.model.DLStorageQuota;
import com.liferay.document.library.service.DLStorageQuotaLocalServiceUtil;

/**
 * The extended model base implementation for the DLStorageQuota service. Represents a row in the &quot;DLStorageQuota&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link DLStorageQuotaImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DLStorageQuotaImpl
 * @see DLStorageQuota
 * @generated
 */
public abstract class DLStorageQuotaBaseImpl
	extends DLStorageQuotaModelImpl implements DLStorageQuota {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a dl storage quota model instance should use the <code>DLStorageQuota</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			DLStorageQuotaLocalServiceUtil.addDLStorageQuota(this);
		}
		else {
			DLStorageQuotaLocalServiceUtil.updateDLStorageQuota(this);
		}
	}

}