/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.service.impl;

import com.liferay.document.library.exception.DLStorageQuotaExceededException;
import com.liferay.document.library.kernel.model.DLFileVersionTable;
import com.liferay.document.library.model.DLStorageQuota;
import com.liferay.document.library.service.base.DLStorageQuotaLocalServiceBaseImpl;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.increment.BufferedIncrement;
import com.liferay.portal.kernel.increment.NumberIncrement;
import com.liferay.portal.util.PropsValues;
import java.util.Iterator;
import org.osgi.service.component.annotations.Component;

@CTAware
@Component(property={"model.class.name=com.liferay.document.library.model.DLStorageQuota"}, service={AopService.class})
public class DLStorageQuotaLocalServiceImpl
extends DLStorageQuotaLocalServiceBaseImpl {
    public DLStorageQuota getCompanyDLStorageQuota(long companyId) throws PortalException {
        return this.dlStorageQuotaPersistence.findByCompanyId(companyId);
    }

    @BufferedIncrement(incrementClass=NumberIncrement.class)
    public void incrementStorageSize(long companyId, long increment) {
        DLStorageQuota dlStorageQuota = this.dlStorageQuotaPersistence.fetchByCompanyId(companyId);
        if (dlStorageQuota == null) {
            if (increment <= 0L) {
                return;
            }
            dlStorageQuota = this._getDLStorageQuota(companyId);
        }
        dlStorageQuota.setStorageSize(dlStorageQuota.getStorageSize() + increment);
        this.dlStorageQuotaLocalService.updateDLStorageQuota(dlStorageQuota);
    }

    public void updateStorageSize(long companyId) {
        DLStorageQuota dlStorageQuota = this._getDLStorageQuota(companyId);
        dlStorageQuota.setStorageSize(this._getActualStorageSize(companyId));
        this.dlStorageQuotaLocalService.updateDLStorageQuota(dlStorageQuota);
    }

    public void validateStorageQuota(long companyId, long increment) throws PortalException {
        if (PropsValues.DATA_LIMIT_DL_STORAGE_MAX_SIZE <= 0L) {
            return;
        }
        long currentStorageSize = this._getStorageSize(companyId);
        if (currentStorageSize + increment > PropsValues.DATA_LIMIT_DL_STORAGE_MAX_SIZE) {
            throw new DLStorageQuotaExceededException("Unable to exceed maximum alowed document library storage size");
        }
    }

    private long _getActualStorageSize(long companyId) {
        Iterable iterable = (Iterable)this.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{DSLFunctionFactoryUtil.sum((Expression)DLFileVersionTable.INSTANCE.size).as("SUM_VALUE")}).from((Table)DLFileVersionTable.INSTANCE).where(DLFileVersionTable.INSTANCE.companyId.eq((Object)companyId)));
        Iterator iterator = iterable.iterator();
        return (Long)iterator.next();
    }

    private DLStorageQuota _getDLStorageQuota(long companyId) {
        DLStorageQuota dlStorageQuota = this.dlStorageQuotaPersistence.fetchByCompanyId(companyId);
        if (dlStorageQuota != null) {
            return dlStorageQuota;
        }
        dlStorageQuota = this.dlStorageQuotaLocalService.createDLStorageQuota(this.counterLocalService.increment());
        dlStorageQuota.setCompanyId(companyId);
        return dlStorageQuota;
    }

    private long _getStorageSize(long companyId) {
        DLStorageQuota dlStorageQuota = this.dlStorageQuotaPersistence.fetchByCompanyId(companyId);
        if (dlStorageQuota == null) {
            return 0L;
        }
        return dlStorageQuota.getStorageSize();
    }
}

