/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.search.spi.model.index.contributor;

import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import com.liferay.trash.TrashHelper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.document.library.kernel.model.DLFolder"}, service={ModelDocumentContributor.class})
public class DLFolderModelDocumentContributor
implements ModelDocumentContributor<DLFolder> {
    @Reference
    protected TrashHelper trashHelper;
    private static final Log _log = LogFactoryUtil.getLog(DLFolderModelDocumentContributor.class);

    public void contribute(Document document, DLFolder dlFolder) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing document library folder " + dlFolder));
        }
        document.addText("description", dlFolder.getDescription());
        document.addKeyword("folderId", dlFolder.getParentFolderId());
        document.addKeyword("hidden", dlFolder.isHidden() || dlFolder.isInHiddenFolder());
        String title = dlFolder.getName();
        if (dlFolder.isInTrash()) {
            title = this.trashHelper.getOriginalTitle(title);
        }
        document.addText("title", title);
        document.addKeyword("treePath", dlFolder.getTreePath());
        document.addKeyword("treePath", StringUtil.split((String)dlFolder.getTreePath(), (char)'/'));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document library folder " + dlFolder + " indexed successfully"));
        }
    }
}

