/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.model.listener;

import com.liferay.document.library.internal.util.DLExportableRepositoryPublisherUtil;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.repository.liferayrepository.LiferayRepositoryDefiner;
import com.liferay.portal.repository.temporaryrepository.TemporaryFileEntryRepositoryDefiner;
import com.liferay.staging.model.listener.StagingModelListener;
import java.util.Collection;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class RepositoryStagingModelListener
extends BaseModelListener<Repository> {
    @Reference
    private Portal _portal;
    @Reference
    private StagingModelListener<Repository> _stagingModelListener;

    public void onAfterCreate(Repository repository) throws ModelListenerException {
        if (!this._isRepositoryExportable(repository)) {
            return;
        }
        this._stagingModelListener.onAfterCreate((BaseModel)repository);
    }

    public void onAfterRemove(Repository repository) throws ModelListenerException {
        this._stagingModelListener.onAfterRemove((BaseModel)repository);
    }

    public void onAfterUpdate(Repository originalRepository, Repository repository) throws ModelListenerException {
        if (!this._isRepositoryExportable(repository)) {
            return;
        }
        this._stagingModelListener.onAfterUpdate((BaseModel)repository);
    }

    private boolean _isRepositoryExportable(Repository repository) {
        long liferayRepositoryClassNameId = this._portal.getClassNameId(LiferayRepositoryDefiner.CLASS_NAME);
        if (repository.getClassNameId() == liferayRepositoryClassNameId) {
            return false;
        }
        long tempFileRepositoryClassNameId = this._portal.getClassNameId(TemporaryFileEntryRepositoryDefiner.CLASS_NAME);
        if (repository.getClassNameId() == tempFileRepositoryClassNameId) {
            return false;
        }
        Collection<Long> exportableRepositoryIds = DLExportableRepositoryPublisherUtil.publish(repository.getGroupId());
        String portletId = repository.getPortletId();
        return Validator.isBlank((String)portletId) || Objects.equals(portletId, "com_liferay_document_library_web_portlet_DLAdminPortlet") || StringUtil.startsWith((String)portletId, (String)"com_liferay_document_library_web_portlet_DLPortlet") || exportableRepositoryIds.contains(repository.getRepositoryId());
    }
}

