/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.versioning;

import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import com.liferay.document.library.versioning.VersioningPolicy;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.ranking:Integer=100"}, service={VersioningPolicy.class})
public class ContentVersioningPolicy
implements VersioningPolicy {
    private static final Log _log = LogFactoryUtil.getLog(ContentVersioningPolicy.class);
    @Reference
    private DLFileVersionLocalService _dlFileVersionLocalService;

    public Optional<DLVersionNumberIncrease> computeDLVersionNumberIncrease(DLFileVersion previousDLFileVersion, DLFileVersion nextDLFileVersion) {
        long previousSize = previousDLFileVersion.getSize();
        long nextSize = nextDLFileVersion.getSize();
        if (previousSize == 0L && nextSize >= 0L) {
            return Optional.empty();
        }
        if (previousSize != nextSize) {
            return Optional.of(DLVersionNumberIncrease.MAJOR);
        }
        String previousChecksum = this._computeChecksum(previousDLFileVersion);
        if (previousChecksum == null) {
            return Optional.empty();
        }
        String nextChecksum = this._computeChecksum(nextDLFileVersion);
        if (nextChecksum == null || previousChecksum.equals(nextChecksum)) {
            return Optional.empty();
        }
        return Optional.of(DLVersionNumberIncrease.MAJOR);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String _computeChecksum(DLFileVersion dlFileVersion) {
        if (Validator.isNotNull((String)dlFileVersion.getChecksum())) {
            return dlFileVersion.getChecksum();
        }
        try (InputStream inputStream = dlFileVersion.getContentStream(false);){
            dlFileVersion.setChecksum(DigesterUtil.digestBase64((InputStream)inputStream));
            this._dlFileVersionLocalService.updateDLFileVersion(dlFileVersion);
            String string = dlFileVersion.getChecksum();
            return string;
        }
        catch (PortalException | IOException exception) {
            if (!_log.isWarnEnabled()) return null;
            _log.warn((Object)exception, exception);
            return null;
        }
    }
}

