/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.verify;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLAppHelperLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryMetadataLocalService;
import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.change.tracking.store.CTStoreFactory;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portal.verify.VerifyProcess;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Deprecated
@Component(property={"verify.process.name=com.liferay.document.library.service"}, service={VerifyProcess.class})
public class DLServiceVerifyProcess
extends VerifyProcess {
    private static final String _MS_OFFICE_2010_TEXT_XML_UTF8 = "text/xml; charset=\"utf-8\"";
    private static final Log _log = LogFactoryUtil.getLog(DLServiceVerifyProcess.class);
    @Reference
    private CTStoreFactory _ctStoreFactory;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    private DLAppHelperLocalService _dlAppHelperLocalService;
    private DLFileEntryLocalService _dlFileEntryLocalService;
    private DLFileEntryMetadataLocalService _dlFileEntryMetadataLocalService;
    private DLFileVersionLocalService _dlFileVersionLocalService;
    private DLFolderLocalService _dlFolderLocalService;

    protected void checkDLFileEntryMetadata() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List mismatchedCompanyIdDLFileEntryMetadatas = this._dlFileEntryMetadataLocalService.getMismatchedCompanyIdFileEntryMetadatas();
            if (_log.isDebugEnabled()) {
                int size = mismatchedCompanyIdDLFileEntryMetadatas.size();
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Deleting ", size, " file entry metadatas with mismatched company IDs"}));
            }
            for (DLFileEntryMetadata dlFileEntryMetadata : mismatchedCompanyIdDLFileEntryMetadatas) {
                this.deleteUnusedDLFileEntryMetadata(dlFileEntryMetadata);
            }
            List noStructuresDLFileEntryMetadatas = this._dlFileEntryMetadataLocalService.getNoStructuresFileEntryMetadatas();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Deleting " + noStructuresDLFileEntryMetadatas.size() + " file entry metadatas with no structures"));
            }
            for (DLFileEntryMetadata dlFileEntryMetadata : noStructuresDLFileEntryMetadatas) {
                this.deleteUnusedDLFileEntryMetadata(dlFileEntryMetadata);
            }
        }
    }

    protected void checkFileVersionMimeTypes(String[] originalMimeTypes) throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = this._dlFileVersionLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Criterion criterion = RestrictionsFactoryUtil.eq((String)"mimeType", (Object)originalMimeTypes[0]);
            for (int i = 1; i < originalMimeTypes.length; ++i) {
                criterion = RestrictionsFactoryUtil.or((Criterion)criterion, (Criterion)RestrictionsFactoryUtil.eq((String)"mimeType", (Object)originalMimeTypes[i]));
            }
            dynamicQuery.add(criterion);
        });
        actionableDynamicQuery.setPerformActionMethod(dlFileVersion -> {
            block23: {
                String title = DLUtil.getTitleWithExtension((String)dlFileVersion.getTitle(), (String)dlFileVersion.getExtension());
                try (InputStream inputStream = this._dlFileEntryLocalService.getFileAsStream(dlFileVersion.getFileEntryId(), dlFileVersion.getVersion(), false);){
                    String mimeType = MimeTypesUtil.getContentType((InputStream)inputStream, (String)title);
                    if (mimeType.equals(dlFileVersion.getMimeType())) {
                        return;
                    }
                    dlFileVersion.setMimeType(mimeType);
                    this._dlFileVersionLocalService.updateDLFileVersion(dlFileVersion);
                    try {
                        DLFileEntry dlFileEntry = dlFileVersion.getFileEntry();
                        if (Objects.equals(dlFileEntry.getVersion(), dlFileVersion.getVersion())) {
                            dlFileEntry.setMimeType(mimeType);
                            this._dlFileEntryLocalService.updateDLFileEntry(dlFileEntry);
                        }
                    }
                    catch (PortalException portalException) {
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)("Unable to get file entry " + dlFileVersion.getFileEntryId()), (Throwable)portalException);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block23;
                    DLFileEntry dlFileEntry = this._dlFileEntryLocalService.fetchDLFileEntry(dlFileVersion.getFileEntryId());
                    if (dlFileEntry == null) {
                        _log.warn((Object)("Unable to find file entry associated with file version " + dlFileVersion.getFileVersionId()), (Throwable)exception);
                    }
                    StringBundler sb = new StringBundler(4);
                    sb.append("Unable to find file version ");
                    sb.append(dlFileVersion.getVersion());
                    sb.append(" for file entry ");
                    sb.append(dlFileEntry.getName());
                    _log.warn((Object)sb.toString(), (Throwable)exception);
                }
            }
        });
        if (_log.isDebugEnabled()) {
            long count = actionableDynamicQuery.performCount();
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Processing ", count, " file versions with mime types: ", StringUtil.merge((Object[])originalMimeTypes, (String)",")}));
        }
        actionableDynamicQuery.performActions();
    }

    protected void checkMimeTypes() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.checkFileVersionMimeTypes(new String[]{"application/octet-stream", _MS_OFFICE_2010_TEXT_XML_UTF8});
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Fixed file entries with invalid mime types");
            }
        }
    }

    protected void deleteUnusedDLFileEntryMetadata(DLFileEntryMetadata dlFileEntryMetadata) throws Exception {
        this._dlFileEntryMetadataLocalService.deleteFileEntryMetadata(dlFileEntryMetadata);
    }

    protected void doVerify() throws Exception {
        this.checkDLFileEntryMetadata();
        this.checkMimeTypes();
        this.updateClassNameId();
        this.updateFileEntryAssets();
        this.updateFolderAssets();
    }

    @Reference(unbind="-")
    protected void setDLAppHelperLocalService(DLAppHelperLocalService dlAppHelperLocalService) {
        this._dlAppHelperLocalService = dlAppHelperLocalService;
    }

    @Reference(unbind="-")
    protected void setDLFileEntryLocalService(DLFileEntryLocalService dlFileEntryLocalService) {
        this._dlFileEntryLocalService = dlFileEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setDLFileEntryMetadataLocalService(DLFileEntryMetadataLocalService dlFileEntryMetadataLocalService) {
        this._dlFileEntryMetadataLocalService = dlFileEntryMetadataLocalService;
    }

    @Reference(unbind="-")
    protected void setDLFileVersionLocalService(DLFileVersionLocalService dlFileVersionLocalService) {
        this._dlFileVersionLocalService = dlFileVersionLocalService;
    }

    @Reference(unbind="-")
    protected void setDLFolderLocalService(DLFolderLocalService dlFolderLocalService) {
        this._dlFolderLocalService = dlFolderLocalService;
    }

    @Reference(target="(&(release.bundle.symbolic.name=com.liferay.document.library.service)(&(release.schema.version>=3.0.0)(!(release.schema.version>=4.0.0))))", unbind="-")
    protected void setRelease(Release release) {
    }

    protected void updateClassNameId() {
        block14: {
            try (LoggingTimer loggingTimer = new LoggingTimer();){
                this.runSQL("update DLFileEntry set classNameId = 0 where classNameId is null");
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block14;
                _log.warn((Object)"Unable to fix file entries where class name ID is null", (Throwable)exception);
            }
        }
    }

    protected void updateFileEntryAssets() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List dlFileEntries = this._dlFileEntryLocalService.getNoAssetFileEntries();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Processing " + dlFileEntries.size() + " file entries with no asset"));
            }
            for (DLFileEntry dlFileEntry : dlFileEntries) {
                LiferayFileEntry fileEntry = new LiferayFileEntry(dlFileEntry);
                LiferayFileVersion fileVersion = new LiferayFileVersion(dlFileEntry.getFileVersion());
                try {
                    this._dlAppHelperLocalService.updateAsset(dlFileEntry.getUserId(), (FileEntry)fileEntry, (FileVersion)fileVersion, null, null, null);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to update asset for file entry ", dlFileEntry.getFileEntryId(), ": ", exception.getMessage()}));
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Assets verified for file entries");
            }
        }
    }

    protected void updateFolderAssets() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List dlFolders = this._dlFolderLocalService.getNoAssetFolders();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Processing " + dlFolders.size() + " folders with no asset"));
            }
            for (DLFolder dlFolder : dlFolders) {
                LiferayFolder folder = new LiferayFolder(dlFolder);
                try {
                    this._dlAppHelperLocalService.updateAsset(dlFolder.getUserId(), (Folder)folder, null, null, null);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to update asset for folder ", dlFolder.getFolderId(), ": ", exception.getMessage()}));
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Assets verified for folders");
            }
        }
    }
}

