/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.util;

import com.liferay.document.library.configuration.DLFileEntryConfiguration;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.util.DLProcessor;
import com.liferay.document.library.kernel.util.DLProcessorRegistry;
import com.liferay.document.library.kernel.util.DLProcessorThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.xml.Element;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.document.library.configuration.DLFileEntryConfiguration"}, immediate=true, service={DLProcessorRegistry.class})
public class DLProcessorRegistryImpl
implements DLProcessorRegistry {
    private static final String[] _DL_FILE_ENTRY_PROCESSORS = PropsUtil.getArray((String)"dl.file.entry.processors");
    private static final Log _log = LogFactoryUtil.getLog(DLProcessorRegistryImpl.class);
    private BundleContext _bundleContext;
    private volatile DLFileEntryConfiguration _dlFileEntryConfiguration;
    private final List<DLProcessor> _dlProcessors = new ArrayList<DLProcessor>(_DL_FILE_ENTRY_PROCESSORS.length);
    private ServiceTrackerMap<String, DLProcessor> _dlProcessorServiceTrackerMap;
    private final Map<DLProcessor, ServiceRegistration<DLProcessor>> _serviceRegistrations = new ConcurrentHashMap<DLProcessor, ServiceRegistration<DLProcessor>>();

    public void cleanUp(FileEntry fileEntry) {
        if (!DLProcessorThreadLocal.isEnabled()) {
            return;
        }
        for (DLProcessor dlProcessor : this._dlProcessorServiceTrackerMap.values()) {
            if (!dlProcessor.isSupported(fileEntry.getMimeType())) continue;
            dlProcessor.cleanUp(fileEntry);
        }
    }

    public void cleanUp(FileVersion fileVersion) {
        if (!DLProcessorThreadLocal.isEnabled()) {
            return;
        }
        for (DLProcessor dlProcessor : this._dlProcessorServiceTrackerMap.values()) {
            if (!dlProcessor.isSupported(fileVersion)) continue;
            dlProcessor.cleanUp(fileVersion);
        }
    }

    public void exportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        if (fileEntry == null || fileEntry.getSize() == 0L) {
            return;
        }
        FileVersion latestFileVersion = this._getLatestFileVersion(fileEntry, true);
        if (latestFileVersion == null) {
            return;
        }
        for (DLProcessor dlProcessor : this._dlProcessorServiceTrackerMap.values()) {
            if (!dlProcessor.isSupported(latestFileVersion)) continue;
            dlProcessor.exportGeneratedFiles(portletDataContext, fileEntry, fileEntryElement);
        }
    }

    public DLProcessor getDLProcessor(String dlProcessorType) {
        return (DLProcessor)this._dlProcessorServiceTrackerMap.getService((Object)dlProcessorType);
    }

    public void importGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        if (importedFileEntry == null || importedFileEntry.getSize() == 0L) {
            return;
        }
        FileVersion fileVersion = importedFileEntry.getFileVersion();
        if (fileVersion == null) {
            return;
        }
        for (DLProcessor dlProcessor : this._dlProcessorServiceTrackerMap.values()) {
            if (!dlProcessor.isSupported(fileVersion)) continue;
            dlProcessor.importGeneratedFiles(portletDataContext, fileEntry, importedFileEntry, fileEntryElement);
        }
    }

    public boolean isPreviewableSize(FileVersion fileVersion) {
        long fileEntryPreviewableProcessorMaxSize = this._dlFileEntryConfiguration.previewableProcessorMaxSize();
        if (fileEntryPreviewableProcessorMaxSize == 0L) {
            return false;
        }
        return fileEntryPreviewableProcessorMaxSize <= 0L || fileVersion.getSize() <= fileEntryPreviewableProcessorMaxSize;
    }

    @Modified
    public void modified(Map<String, Object> properties) {
        this._dlFileEntryConfiguration = (DLFileEntryConfiguration)ConfigurableUtil.createConfigurable(DLFileEntryConfiguration.class, properties);
    }

    public void register(DLProcessor dlProcessor) {
        ServiceRegistration serviceRegistration = this._bundleContext.registerService(DLProcessor.class, (Object)dlProcessor, MapUtil.singletonDictionary((Object)"type", (Object)dlProcessor.getType()));
        ServiceRegistration<DLProcessor> previousServiceRegistration = this._serviceRegistrations.put(dlProcessor, (ServiceRegistration<DLProcessor>)serviceRegistration);
        if (previousServiceRegistration != null) {
            previousServiceRegistration.unregister();
        }
    }

    public void trigger(FileEntry fileEntry, FileVersion fileVersion) {
        this.trigger(fileEntry, fileVersion, false);
    }

    public void trigger(FileEntry fileEntry, FileVersion fileVersion, boolean trusted) {
        if (!DLProcessorThreadLocal.isEnabled()) {
            return;
        }
        if (fileEntry == null || fileEntry.getSize() == 0L) {
            return;
        }
        FileVersion latestFileVersion = this._getLatestFileVersion(fileEntry, trusted);
        if (latestFileVersion == null) {
            return;
        }
        for (DLProcessor dlProcessor : this._dlProcessorServiceTrackerMap.values()) {
            if (!dlProcessor.isSupported(latestFileVersion)) continue;
            dlProcessor.trigger(fileVersion, latestFileVersion);
        }
    }

    public void unregister(DLProcessor dlProcessor) {
        ServiceRegistration<DLProcessor> serviceRegistration = this._serviceRegistrations.remove(dlProcessor);
        serviceRegistration.unregister();
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) throws Exception {
        this._dlFileEntryConfiguration = (DLFileEntryConfiguration)ConfigurableUtil.createConfigurable(DLFileEntryConfiguration.class, properties);
        this._bundleContext = bundleContext;
        this._dlProcessorServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, DLProcessor.class, (String)"type");
        ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
        for (String dlProcessorClassName : _DL_FILE_ENTRY_PROCESSORS) {
            DLProcessor dlProcessor = (DLProcessor)InstanceFactory.newInstance((ClassLoader)classLoader, (String)dlProcessorClassName);
            dlProcessor.afterPropertiesSet();
            this.register(dlProcessor);
            this._dlProcessors.add(dlProcessor);
        }
    }

    @Deactivate
    protected void deactivate() throws Exception {
        this._dlProcessorServiceTrackerMap.close();
        UnsafeConsumer.accept(this._dlProcessors, dlProcessor -> {
            this.unregister((DLProcessor)dlProcessor);
            dlProcessor.destroy();
        }, Exception.class);
        this._dlProcessors.clear();
    }

    private FileVersion _getLatestFileVersion(FileEntry fileEntry, boolean trusted) {
        try {
            return fileEntry.getLatestFileVersion(trusted);
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)noSuchFileEntryException, (Throwable)noSuchFileEntryException);
            }
            return null;
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            return null;
        }
    }
}

