/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.exportimport.data.handler;

import com.liferay.asset.display.page.model.AssetDisplayPageEntry;
import com.liferay.asset.display.page.service.AssetDisplayPageEntryLocalService;
import com.liferay.changeset.service.ChangesetCollectionLocalService;
import com.liferay.changeset.service.ChangesetEntryLocalService;
import com.liferay.document.library.exportimport.data.handler.DLPluggableContentDataHandler;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryMetadataLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService;
import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import com.liferay.document.library.kernel.service.DLTrashService;
import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.document.library.kernel.util.DLProcessorThreadLocal;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.dynamic.data.mapping.util.DDMBeanTranslatorUtil;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.exportimport.portlet.data.handler.util.ExportImportGroupedModelUtil;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.RepositoryLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.portletrepository.PortletRepository;
import com.liferay.portal.util.RepositoryUtil;
import com.liferay.portlet.documentlibrary.lar.FileEntryUtil;
import com.liferay.trash.TrashHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class FileEntryStagedModelDataHandler
extends BaseStagedModelDataHandler<FileEntry> {
    public static final String[] CLASS_NAMES = new String[]{DLFileEntry.class.getName(), FileEntry.class.getName(), LiferayFileEntry.class.getName()};
    private static final Log _log = LogFactoryUtil.getLog(FileEntryStagedModelDataHandler.class);
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRED, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    @Reference
    private AssetDisplayPageEntryLocalService _assetDisplayPageEntryLocalService;
    @Reference
    private ChangesetCollectionLocalService _changesetCollectionLocalService;
    @Reference
    private ChangesetEntryLocalService _changesetEntryLocalService;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference(target="(model.class.name=com.liferay.dynamic.data.mapping.storage.DDMFormValues)")
    private ExportImportContentProcessor<DDMFormValues> _ddmFormValuesExportImportContentProcessor;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private DLFileEntryMetadataLocalService _dlFileEntryMetadataLocalService;
    @Reference
    private DLFileEntryTypeLocalService _dlFileEntryTypeLocalService;
    @Reference
    private DLFileVersionLocalService _dlFileVersionLocalService;
    @Reference
    private DLTrashService _dlTrashService;
    @Reference(target="(ddm.form.values.deserializer.type=json)")
    private DDMFormValuesDeserializer _jsonDDMFormValuesDeserializer;
    @Reference(target="(ddm.form.values.serializer.type=json)")
    private DDMFormValuesSerializer _jsonDDMFormValuesSerializer;
    @Reference
    private Portal _portal;
    @Reference
    private RepositoryLocalService _repositoryLocalService;
    private ServiceTrackerList<DLPluggableContentDataHandler, DLPluggableContentDataHandler> _serviceTrackerList;
    @Reference
    private StorageEngine _storageEngine;
    @Reference
    private TrashHelper _trashHelper;

    public void deleteStagedModel(FileEntry fileEntry) throws PortalException {
        this._dlAppLocalService.deleteFileEntry(fileEntry.getFileEntryId());
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        FileEntry fileEntry = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (fileEntry != null) {
            this.deleteStagedModel(fileEntry);
        }
    }

    public FileEntry fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        try {
            return this._dlAppLocalService.getFileEntryByUuidAndGroupId(uuid, groupId);
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)portalException, (Throwable)portalException);
            }
            return null;
        }
    }

    public List<FileEntry> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        List dlFileEntries = this._dlFileEntryLocalService.getDLFileEntriesByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
        ArrayList<FileEntry> fileEntries = new ArrayList<FileEntry>();
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            fileEntries.add((FileEntry)new LiferayFileEntry(dlFileEntry));
        }
        return fileEntries;
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(FileEntry fileEntry) {
        if (fileEntry.isInTrash()) {
            return this._trashHelper.getOriginalTitle(fileEntry.getTitle());
        }
        return fileEntry.getTitle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importStagedModel(PortletDataContext portletDataContext, FileEntry fileEntry) throws PortletDataException {
        boolean dlProcessorEnabled = DLProcessorThreadLocal.isEnabled();
        try {
            DLProcessorThreadLocal.setEnabled((boolean)false);
            super.importStagedModel(portletDataContext, (StagedModel)fileEntry);
        }
        finally {
            DLProcessorThreadLocal.setEnabled((boolean)dlProcessorEnabled);
        }
    }

    public void restoreStagedModel(PortletDataContext portletDataContext, FileEntry stagedModel) throws PortletDataException {
        try {
            this.doRestoreStagedModel(portletDataContext, stagedModel);
        }
        catch (PortletDataException portletDataException) {
            throw portletDataException;
        }
        catch (Exception exception) {
            throw new PortletDataException((Throwable)exception);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)bundleContext, DLPluggableContentDataHandler.class, (String)("(model.class.name=" + FileEntry.class.getName() + ")"));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerList.close();
    }

    protected DDMFormValues deserialize(String content, DDMForm ddmForm) {
        DDMFormValuesDeserializerDeserializeRequest.Builder builder = DDMFormValuesDeserializerDeserializeRequest.Builder.newBuilder((String)content, (DDMForm)ddmForm);
        DDMFormValuesDeserializerDeserializeResponse ddmFormValuesDeserializerDeserializeResponse = this._jsonDDMFormValuesDeserializer.deserialize(builder.build());
        return ddmFormValuesDeserializerDeserializeResponse.getDDMFormValues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExportStagedModel(PortletDataContext portletDataContext, FileEntry fileEntry) throws Exception {
        Element fileEntryElement = portletDataContext.getExportDataElement((ClassedModel)fileEntry);
        String fileEntryPath = ExportImportPathUtil.getModelPath((StagedModel)fileEntry);
        if (!fileEntry.isDefaultRepository()) {
            Repository repository = this._repositoryLocalService.getRepository(fileEntry.getRepositoryId());
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)fileEntry, (StagedModel)repository, (String)"strong");
            long portletRepositoryClassNameId = this._portal.getClassNameId(PortletRepository.class.getName());
            if (repository.getClassNameId() != portletRepositoryClassNameId) {
                return;
            }
        }
        if (fileEntry.getFolderId() != 0L) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)fileEntry, (StagedModel)fileEntry.getFolder(), (String)"parent");
        }
        FileVersion fileVersion = fileEntry.getFileVersion();
        fileEntryElement.addAttribute("fileVersionUuid", fileVersion.getUuid());
        fileEntryElement.addAttribute("version", fileEntry.getVersion());
        LiferayFileEntry liferayFileEntry = (LiferayFileEntry)fileEntry;
        liferayFileEntry.setCachedFileVersion(fileEntry.getFileVersion());
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            InputStream is;
            block15: {
                is = null;
                try {
                    is = FileEntryUtil.getContentStream((FileEntry)fileEntry);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block15;
                    _log.warn((Object)("Unable to retrieve content for file entry " + fileEntry.getFileEntryId()), (Throwable)exception);
                }
            }
            if (is == null) {
                fileEntryElement.detach();
                return;
            }
            try {
                String binPath = ExportImportPathUtil.getModelPath((StagedModel)fileEntry, (String)fileEntry.getVersion());
                portletDataContext.addZipEntry(binPath, is);
                fileEntryElement.addAttribute("bin-path", binPath);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ioException) {
                    _log.error((Object)ioException, (Throwable)ioException);
                }
            }
        }
        for (DLPluggableContentDataHandler dlPluggableContentDataHandler : this._serviceTrackerList) {
            dlPluggableContentDataHandler.exportContent(portletDataContext, fileEntryElement, (StagedModel)fileEntry);
        }
        this.exportMetaData(portletDataContext, fileEntryElement, fileEntry);
        this._exportAssetDisplayPage(portletDataContext, fileEntry);
        portletDataContext.addClassedModel(fileEntryElement, fileEntryPath, (ClassedModel)liferayFileEntry, DLFileEntry.class);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long fileEntryId) {
        FileEntry existingFileEntry = (FileEntry)this.fetchMissingReference(uuid, groupId);
        if (existingFileEntry == null) {
            return;
        }
        Map dlFileEntryIds = portletDataContext.getNewPrimaryKeysMap(DLFileEntry.class);
        dlFileEntryIds.put(fileEntryId, existingFileEntry.getFileEntryId());
        Map fileEntryIds = portletDataContext.getNewPrimaryKeysMap(FileEntry.class);
        fileEntryIds.put(fileEntryId, existingFileEntry.getFileEntryId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doImportStagedModel(PortletDataContext portletDataContext, FileEntry fileEntry) throws Exception {
        if (RepositoryUtil.isExternalRepository((long)fileEntry.getRepositoryId())) {
            return;
        }
        Map repositoryIds = portletDataContext.getNewPrimaryKeysMap(Repository.class);
        long repositoryId = MapUtil.getLong((Map)repositoryIds, (long)fileEntry.getRepositoryId(), (long)portletDataContext.getScopeGroupId());
        Map folderIds = portletDataContext.getNewPrimaryKeysMap(Folder.class);
        long folderId = MapUtil.getLong((Map)folderIds, (long)fileEntry.getFolderId(), (long)fileEntry.getFolderId());
        long[] assetCategoryIds = portletDataContext.getAssetCategoryIds(DLFileEntry.class, fileEntry.getFileEntryId());
        String[] assetTagNames = portletDataContext.getAssetTagNames(DLFileEntry.class, fileEntry.getFileEntryId());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)fileEntry, DLFileEntry.class);
        serviceContext.setAttribute("sourceFileName", (Serializable)((Object)("A." + fileEntry.getExtension())));
        long userId = portletDataContext.getUserId(fileEntry.getUserUuid());
        serviceContext.setUserId(userId);
        Element fileEntryElement = portletDataContext.getImportDataElement((StagedModel)fileEntry);
        String binPath = fileEntryElement.attributeValue("bin-path");
        String fileVersionUuid = fileEntryElement.attributeValue("fileVersionUuid");
        String version = fileEntryElement.attributeValue("version");
        Serializable validateDDMFormValues = serviceContext.getAttribute("validateDDMFormValues");
        serviceContext.setAttribute("validateDDMFormValues", (Serializable)Boolean.FALSE);
        InputStream is = null;
        try {
            if (Validator.isNull((String)binPath) && portletDataContext.isPerformDirectBinaryImport()) {
                try {
                    is = FileEntryUtil.getContentStream((FileEntry)fileEntry);
                }
                catch (Exception exception) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Unable to retrieve content for file entry " + fileEntry.getFileEntryId()), (Throwable)exception);
                    }
                    serviceContext.setAttribute("validateDDMFormValues", validateDDMFormValues);
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException ioException) {
                        _log.error((Object)ioException, (Throwable)ioException);
                    }
                    return;
                }
            }
            is = portletDataContext.getZipEntryAsInputStream(binPath);
            if (is == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("No file found for file entry " + fileEntry.getFileEntryId()));
                }
                return;
            }
            this.importMetaData(portletDataContext, fileEntryElement, fileEntry, serviceContext);
            FileEntry importedFileEntry = null;
            if (portletDataContext.isDataStrategyMirror()) {
                FileEntry existingFileEntry = this.fetchStagedModelByUuidAndGroupId(fileEntry.getUuid(), portletDataContext.getScopeGroupId());
                if (existingFileEntry == null) {
                    if (portletDataContext.isDataStrategyMirrorWithOverwriting()) {
                        FileEntry existingTitleFileEntry = FileEntryUtil.fetchByR_F_T((long)repositoryId, (long)folderId, (String)fileEntry.getTitle());
                        if (existingTitleFileEntry == null) {
                            existingTitleFileEntry = FileEntryUtil.fetchByR_F_FN((long)repositoryId, (long)folderId, (String)fileEntry.getFileName());
                        }
                        if (existingTitleFileEntry != null) {
                            this._dlAppLocalService.deleteFileEntry(existingTitleFileEntry.getFileEntryId());
                        }
                    }
                    serviceContext.setAttribute("fileVersionUuid", (Serializable)((Object)fileVersionUuid));
                    serviceContext.setUuid(fileEntry.getUuid());
                    String fileEntryTitle = this._dlFileEntryLocalService.getUniqueTitle(portletDataContext.getScopeGroupId(), folderId, 0L, fileEntry.getTitle(), fileEntry.getExtension());
                    importedFileEntry = this._dlAppLocalService.addFileEntry(userId, repositoryId, folderId, fileEntry.getFileName(), fileEntry.getMimeType(), fileEntryTitle, fileEntry.getDescription(), null, is, fileEntry.getSize(), serviceContext);
                    if (fileEntry.isInTrash()) {
                        importedFileEntry = this._dlTrashService.moveFileEntryToTrash(importedFileEntry.getFileEntryId());
                    }
                } else {
                    FileVersion latestExistingFileVersion = existingFileEntry.getLatestFileVersion(true);
                    boolean indexEnabled = serviceContext.isIndexingEnabled();
                    boolean deleteFileEntry = false;
                    boolean updateFileEntry = false;
                    if (!Objects.equals(fileVersionUuid, latestExistingFileVersion.getUuid())) {
                        deleteFileEntry = true;
                        updateFileEntry = true;
                    } else {
                        try (InputStream existingFileVersionInputStream = null;){
                            existingFileVersionInputStream = latestExistingFileVersion.getContentStream(false);
                        }
                        if (existingFileVersionInputStream == null) {
                            updateFileEntry = true;
                        }
                    }
                    try {
                        String latestExistingVersion;
                        serviceContext.setIndexingEnabled(false);
                        if (updateFileEntry) {
                            DLFileVersion alreadyExistingFileVersion = this._dlFileVersionLocalService.getFileVersionByUuidAndGroupId(fileVersionUuid, existingFileEntry.getGroupId());
                            if (alreadyExistingFileVersion != null) {
                                serviceContext.setAttribute("existingDLFileVersionId", (Serializable)Long.valueOf(alreadyExistingFileVersion.getFileVersionId()));
                            }
                            serviceContext.setUuid(fileVersionUuid);
                            String fileEntryTitle = this._dlFileEntryLocalService.getUniqueTitle(portletDataContext.getScopeGroupId(), existingFileEntry.getFolderId(), existingFileEntry.getFileEntryId(), fileEntry.getTitle(), fileEntry.getExtension());
                            importedFileEntry = this._dlAppLocalService.updateFileEntry(userId, existingFileEntry.getFileEntryId(), fileEntry.getFileName(), fileEntry.getMimeType(), fileEntryTitle, fileEntry.getDescription(), null, DLVersionNumberIncrease.MINOR, is, fileEntry.getSize(), serviceContext);
                        } else {
                            this._dlAppLocalService.updateAsset(userId, existingFileEntry, latestExistingFileVersion, assetCategoryIds, assetTagNames, null);
                            importedFileEntry = existingFileEntry;
                        }
                        if (importedFileEntry.getFolderId() != folderId) {
                            importedFileEntry = this._dlAppLocalService.moveFileEntry(userId, importedFileEntry.getFileEntryId(), folderId, serviceContext);
                        }
                        if (importedFileEntry instanceof LiferayFileEntry) {
                            LiferayFileEntry liferayFileEntry = (LiferayFileEntry)importedFileEntry;
                            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFileEntry.class);
                            indexer.reindex((Object)((DLFileEntry)liferayFileEntry.getModel()));
                        }
                        if (deleteFileEntry && ExportImportThreadLocal.isStagingInProcess() && !(latestExistingVersion = latestExistingFileVersion.getVersion()).equals(importedFileEntry.getVersion()) && !latestExistingVersion.equals("PWC")) {
                            this._dlAppService.deleteFileVersion(latestExistingFileVersion.getFileEntryId(), latestExistingFileVersion.getVersion());
                        }
                    }
                    finally {
                        serviceContext.setIndexingEnabled(indexEnabled);
                    }
                }
                if (ExportImportThreadLocal.isStagingInProcess()) {
                    importedFileEntry = this._overrideFileVersion(importedFileEntry, version, serviceContext);
                }
            } else {
                String fileEntryTitle = this._dlFileEntryLocalService.getUniqueTitle(portletDataContext.getScopeGroupId(), folderId, 0L, fileEntry.getTitle(), fileEntry.getExtension());
                importedFileEntry = this._dlAppLocalService.addFileEntry(userId, repositoryId, folderId, fileEntry.getFileName(), fileEntry.getMimeType(), fileEntryTitle, fileEntry.getDescription(), null, is, fileEntry.getSize(), serviceContext);
            }
            for (DLPluggableContentDataHandler dlPluggableContentDataHandler : this._serviceTrackerList) {
                dlPluggableContentDataHandler.importContent(portletDataContext, fileEntryElement, (StagedModel)fileEntry, (StagedModel)importedFileEntry);
            }
            portletDataContext.importClassedModel((ClassedModel)fileEntry, (ClassedModel)importedFileEntry, DLFileEntry.class);
            Map fileEntryIds = portletDataContext.getNewPrimaryKeysMap(FileEntry.class);
            fileEntryIds.put(fileEntry.getFileEntryId(), importedFileEntry.getFileEntryId());
            this._importAssetDisplayPage(portletDataContext, fileEntry, importedFileEntry);
        }
        finally {
            serviceContext.setAttribute("validateDDMFormValues", validateDDMFormValues);
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioException) {
                _log.error((Object)ioException, (Throwable)ioException);
            }
        }
    }

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, FileEntry fileEntry) throws Exception {
        FileEntry existingFileEntry = this.fetchStagedModelByUuidAndGroupId(fileEntry.getUuid(), portletDataContext.getScopeGroupId());
        if (existingFileEntry == null || !existingFileEntry.isInTrash()) {
            return;
        }
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)DLFileEntry.class.getName());
        if (trashHandler.isRestorable(existingFileEntry.getFileEntryId())) {
            trashHandler.restoreTrashEntry(portletDataContext.getUserId(fileEntry.getUserUuid()), existingFileEntry.getFileEntryId());
        }
    }

    protected void exportDDMFormValues(PortletDataContext portletDataContext, DDMStructure ddmStructure, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        FileVersion fileVersion = fileEntry.getFileVersion();
        DLFileEntryMetadata dlFileEntryMetadata = this._dlFileEntryMetadataLocalService.fetchFileEntryMetadata(ddmStructure.getStructureId(), fileVersion.getFileVersionId());
        if (dlFileEntryMetadata == null) {
            return;
        }
        Element structureFields = fileEntryElement.addElement("structure-fields");
        String ddmFormValuesPath = ExportImportPathUtil.getModelPath((StagedModel)ddmStructure, (String)String.valueOf(dlFileEntryMetadata.getDDMStorageId()));
        structureFields.addAttribute("ddm-form-values-path", ddmFormValuesPath);
        structureFields.addAttribute("structureUuid", ddmStructure.getUuid());
        DDMFormValues ddmFormValues = this._storageEngine.getDDMFormValues(dlFileEntryMetadata.getDDMStorageId());
        ddmFormValues = (DDMFormValues)this._ddmFormValuesExportImportContentProcessor.replaceExportContentReferences(portletDataContext, (StagedModel)fileEntry, (Serializable)ddmFormValues, true, false);
        portletDataContext.addZipEntry(ddmFormValuesPath, this.serialize(ddmFormValues));
    }

    protected void exportMetaData(PortletDataContext portletDataContext, Element fileEntryElement, FileEntry fileEntry) throws Exception {
        LiferayFileEntry liferayFileEntry = (LiferayFileEntry)fileEntry;
        DLFileEntry dlFileEntry = liferayFileEntry.getDLFileEntry();
        DLFileEntryType dlFileEntryType = this._dlFileEntryTypeLocalService.fetchFileEntryType(dlFileEntry.getFileEntryTypeId());
        if (dlFileEntryType == null || !dlFileEntryType.isExportable()) {
            return;
        }
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)fileEntry, (StagedModel)dlFileEntryType, (String)"strong");
        List ddmStructures = dlFileEntryType.getDDMStructures();
        for (DDMStructure ddmStructure : ddmStructures) {
            this.exportDDMFormValues(portletDataContext, ddmStructure, fileEntry, fileEntryElement);
        }
    }

    protected com.liferay.dynamic.data.mapping.kernel.DDMFormValues getImportDDMFormValues(PortletDataContext portletDataContext, Element structureFieldsElement, DDMStructure ddmStructure) throws Exception {
        String ddmFormValuesPath = structureFieldsElement.attributeValue("ddm-form-values-path");
        String serializedDDMFormValues = portletDataContext.getZipEntryAsString(ddmFormValuesPath);
        DDMFormValues ddmFormValues = this.deserialize(serializedDDMFormValues, DDMBeanTranslatorUtil.translate((com.liferay.dynamic.data.mapping.kernel.DDMForm)ddmStructure.getDDMForm()));
        ddmFormValues = (DDMFormValues)this._ddmFormValuesExportImportContentProcessor.replaceImportContentReferences(portletDataContext, (StagedModel)ddmStructure, (Serializable)ddmFormValues);
        return DDMBeanTranslatorUtil.translate((DDMFormValues)ddmFormValues);
    }

    protected String[] getSkipImportReferenceStagedModelNames() {
        return new String[]{AssetDisplayPageEntry.class.getName()};
    }

    protected void importMetaData(PortletDataContext portletDataContext, Element fileEntryElement, FileEntry fileEntry, ServiceContext serviceContext) throws Exception {
        LiferayFileEntry liferayFileEntry = (LiferayFileEntry)fileEntry;
        DLFileEntry dlFileEntry = liferayFileEntry.getDLFileEntry();
        Map dlFileEntryTypeIds = portletDataContext.getNewPrimaryKeysMap(DLFileEntryType.class);
        long dlFileEntryTypeId = MapUtil.getLong((Map)dlFileEntryTypeIds, (long)dlFileEntry.getFileEntryTypeId(), (long)dlFileEntry.getFileEntryTypeId());
        DLFileEntryType existingDLFileEntryType = this._dlFileEntryTypeLocalService.fetchDLFileEntryType(dlFileEntryTypeId);
        if (existingDLFileEntryType == null) {
            serviceContext.setAttribute("fileEntryTypeId", (Serializable)Integer.valueOf(-1));
            return;
        }
        serviceContext.setAttribute("fileEntryTypeId", (Serializable)Long.valueOf(existingDLFileEntryType.getFileEntryTypeId()));
        List ddmStructures = existingDLFileEntryType.getDDMStructures();
        for (DDMStructure ddmStructure : ddmStructures) {
            Element structureFieldsElement = (Element)fileEntryElement.selectSingleNode("structure-fields[@structureUuid='".concat(ddmStructure.getUuid()).concat("']"));
            if (structureFieldsElement == null) continue;
            com.liferay.dynamic.data.mapping.kernel.DDMFormValues ddmFormValues = this.getImportDDMFormValues(portletDataContext, structureFieldsElement, ddmStructure);
            serviceContext.setAttribute(com.liferay.dynamic.data.mapping.kernel.DDMFormValues.class.getName() + "#" + ddmStructure.getStructureId(), (Serializable)ddmFormValues);
        }
    }

    protected boolean isStagedModelInTrash(FileEntry fileEntry) {
        return fileEntry.isInTrash();
    }

    protected String serialize(DDMFormValues ddmFormValues) {
        DDMFormValuesSerializerSerializeRequest.Builder builder = DDMFormValuesSerializerSerializeRequest.Builder.newBuilder((DDMFormValues)ddmFormValues);
        DDMFormValuesSerializerSerializeResponse ddmFormValuesSerializerSerializeResponse = this._jsonDDMFormValuesSerializer.serialize(builder.build());
        return ddmFormValuesSerializerSerializeResponse.getContent();
    }

    @Reference(target="(&(verify.process.name=com.liferay.document.library.service))", unbind="-")
    protected void setVerifyProcessCompletionMarker(Object object) {
    }

    protected void validateExport(PortletDataContext portletDataContext, FileEntry fileEntry) throws PortletDataException {
        block7: {
            if (fileEntry.getGroupId() != portletDataContext.getGroupId() && fileEntry.getGroupId() != portletDataContext.getScopeGroupId() && !ExportImportGroupedModelUtil.isReferenceInLayoutGroupWithinExportScope((PortletDataContext)portletDataContext, (GroupedModel)fileEntry)) {
                PortletDataException portletDataException = new PortletDataException(4);
                portletDataException.setStagedModelDisplayName(this.getDisplayName(fileEntry));
                portletDataException.setStagedModelClassName(fileEntry.getModelClassName());
                portletDataException.setStagedModelClassPK(GetterUtil.getString((Object)fileEntry.getFileEntryId()));
                throw portletDataException;
            }
            try {
                FileVersion fileVersion = fileEntry.getFileVersion();
                if (!portletDataContext.isInitialPublication() && !ArrayUtil.contains((int[])this.getExportableStatuses(), (int)fileVersion.getStatus())) {
                    PortletDataException portletDataException = new PortletDataException(9);
                    portletDataException.setStagedModelDisplayName(this.getDisplayName(fileEntry));
                    portletDataException.setStagedModelClassName(fileVersion.getModelClassName());
                    portletDataException.setStagedModelClassPK(GetterUtil.getString((Object)fileVersion.getFileVersionId()));
                    throw portletDataException;
                }
            }
            catch (PortletDataException portletDataException) {
                throw portletDataException;
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)exception, (Throwable)exception);
                }
                if (!_log.isWarnEnabled()) break block7;
                _log.warn((Object)("Unable to check workflow status for file entry " + fileEntry.getFileEntryId()));
            }
        }
        if (fileEntry.isInTrash() || fileEntry.isInTrashContainer()) {
            PortletDataException portletDataException = new PortletDataException(8);
            portletDataException.setStagedModel((StagedModel)fileEntry);
            throw portletDataException;
        }
    }

    private void _exportAssetDisplayPage(PortletDataContext portletDataContext, FileEntry fileEntry) throws PortletDataException {
        AssetDisplayPageEntry assetDisplayPageEntry = this._assetDisplayPageEntryLocalService.fetchAssetDisplayPageEntry(fileEntry.getGroupId(), this._portal.getClassNameId(DLFileEntry.class), fileEntry.getFileEntryId());
        if (assetDisplayPageEntry != null) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)fileEntry, (StagedModel)assetDisplayPageEntry, (String)"dependency");
        }
    }

    private void _importAssetDisplayPage(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry) throws PortalException {
        List assetDisplayPageEntryElements = portletDataContext.getReferenceDataElements((StagedModel)fileEntry, AssetDisplayPageEntry.class);
        Map articleNewPrimaryKeys = portletDataContext.getNewPrimaryKeysMap(DLFileEntry.class);
        articleNewPrimaryKeys.put(fileEntry.getFileEntryId(), importedFileEntry.getFileEntryId());
        for (Element assetDisplayPageEntryElement : assetDisplayPageEntryElements) {
            String path = assetDisplayPageEntryElement.attributeValue("path");
            AssetDisplayPageEntry assetDisplayPageEntry = (AssetDisplayPageEntry)portletDataContext.getZipEntryAsObject(path);
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)assetDisplayPageEntryElement);
            Map assetDisplayPageEntries = portletDataContext.getNewPrimaryKeysMap(AssetDisplayPageEntry.class);
            long assetDisplayPageEntryId = MapUtil.getLong((Map)assetDisplayPageEntries, (long)assetDisplayPageEntry.getAssetDisplayPageEntryId(), (long)assetDisplayPageEntry.getAssetDisplayPageEntryId());
            AssetDisplayPageEntry existingAssetDisplayPageEntry = this._assetDisplayPageEntryLocalService.fetchAssetDisplayPageEntry(assetDisplayPageEntryId);
            if (existingAssetDisplayPageEntry == null) continue;
            existingAssetDisplayPageEntry.setClassPK(importedFileEntry.getFileEntryId());
            this._assetDisplayPageEntryLocalService.updateAssetDisplayPageEntry(existingAssetDisplayPageEntry);
        }
    }

    private FileEntry _overrideFileVersion(FileEntry importedFileEntry, String version, ServiceContext serviceContext) throws PortalException {
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        try {
            FileEntry fileEntry = (FileEntry)TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, () -> {
                DLFileEntry dlFileEntry = this._dlFileEntryLocalService.getDLFileEntry(importedFileEntry.getFileEntryId());
                if (version.equals(dlFileEntry.getVersion())) {
                    return importedFileEntry;
                }
                DLFileVersion dlFileVersion = dlFileEntry.getFileVersion();
                String oldVersion = dlFileVersion.getVersion();
                dlFileVersion.setVersion(version);
                this._dlFileVersionLocalService.updateDLFileVersion(dlFileVersion);
                dlFileEntry.setVersion(version);
                dlFileEntry = this._dlFileEntryLocalService.updateDLFileEntry(dlFileEntry);
                if (DLStoreUtil.hasFile((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)oldVersion)) {
                    DLStoreUtil.updateFileVersion((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)oldVersion, (String)version);
                }
                return this._dlAppLocalService.getFileEntry(dlFileEntry.getFileEntryId());
            });
            return fileEntry;
        }
        catch (PortalException | SystemException exception) {
            throw exception;
        }
        catch (Throwable t) {
            throw new PortalException(t);
        }
        finally {
            ServiceContextThreadLocal.popServiceContext();
        }
    }
}

