/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.search;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.MatchQuery;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.query.QueryHelper;
import com.liferay.portal.search.spi.model.query.contributor.KeywordQueryContributor;
import com.liferay.portal.search.spi.model.query.contributor.helper.KeywordQueryContributorHelper;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.document.library.kernel.model.DLFileEntry"}, service={KeywordQueryContributor.class})
public class DLFileEntryKeywordQueryContributor
implements KeywordQueryContributor {
    @Reference
    protected QueryHelper queryHelper;

    public void contribute(String keywords, BooleanQuery booleanQuery, KeywordQueryContributorHelper keywordQueryContributorHelper) {
        BooleanQueryImpl siteDefaultLocaleQuery;
        Query addSearchTermResult;
        Locale siteDefaultLocale;
        SearchContext searchContext = keywordQueryContributorHelper.getSearchContext();
        if (Validator.isNull((String)keywords)) {
            this.queryHelper.addSearchTerm(booleanQuery, searchContext, "description", false);
            this.queryHelper.addSearchTerm(booleanQuery, searchContext, "userName", false);
        }
        this.queryHelper.addSearchTerm(booleanQuery, searchContext, "ddmContent", false);
        this.queryHelper.addSearchTerm(booleanQuery, searchContext, "extension", false);
        this.queryHelper.addSearchTerm(booleanQuery, searchContext, "fileEntryTypeId", false);
        this.queryHelper.addSearchTerm(booleanQuery, searchContext, "path", false);
        this.queryHelper.addSearchLocalizedTerm(booleanQuery, searchContext, "content", false);
        this.queryHelper.addSearchTerm(booleanQuery, searchContext, "title", false);
        if (Validator.isNotNull((String)keywords)) {
            try {
                booleanQuery.add((Query)this._getMatchQuery("fileExtension", keywords, MatchQuery.Type.PHRASE_PREFIX), BooleanClauseOccur.SHOULD);
            }
            catch (ParseException parseException) {
                throw new SystemException((Throwable)parseException);
            }
        }
        if ((siteDefaultLocale = LocaleUtil.getSiteDefault()) != searchContext.getLocale() && (addSearchTermResult = this.queryHelper.addSearchTerm((BooleanQuery)(siteDefaultLocaleQuery = new BooleanQueryImpl()), searchContext, this.getLocalizedName("content", siteDefaultLocale), false)) != null) {
            try {
                BooleanQueryImpl query = new BooleanQueryImpl();
                query.add((Query)siteDefaultLocaleQuery, BooleanClauseOccur.MUST);
                BooleanQueryImpl isDLFileEntryQuery = new BooleanQueryImpl();
                isDLFileEntryQuery.addTerm("entryClassName", "com.liferay.document.library.kernel.model.DLFileEntry", false);
                query.add((Query)isDLFileEntryQuery, BooleanClauseOccur.MUST);
                booleanQuery.add((Query)query, BooleanClauseOccur.SHOULD);
            }
            catch (ParseException parseException) {
                throw new SystemException((Throwable)parseException);
            }
        }
    }

    protected String getLocalizedName(String name, Locale locale) {
        Localization localization = LocalizationUtil.getLocalization();
        return localization.getLocalizedName(name, LocaleUtil.toLanguageId((Locale)locale));
    }

    private MatchQuery _getMatchQuery(String field, String keywords, MatchQuery.Type phrase) {
        MatchQuery matchPhraseQuery = new MatchQuery(field, keywords);
        matchPhraseQuery.setType(phrase);
        return matchPhraseQuery;
    }
}

